/* ==========================================================================
*    : ̼
*    : 2006.12.20
*      :   
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneNode.h"
#include "ActorManagerForPartition.h"
#include "TrailGeometry.h"

class cEffectSceneNode;
//class cShadowGeometry;
class cSoundSceneNode;
//class cObjectNameCard;
//class cChatBubble;
//class cBaseObject;

///    
class cDynamicSceneNodeParam : public cSceneNodeParam
{
public:
	cDynamicSceneNodeParam();

public:
	bool mUseShadow;
};

inline cDynamicSceneNodeParam::cDynamicSceneNodeParam()
: mUseShadow( true )
{
}

struct sTrailInfo
{
	cRibbonGeometry*	mRibbonGeom;
	float				mLifeTime;

	unsigned int		mStartLink;
	unsigned int		mEndLink;

	bool				mLoop;

	sTrailInfo()
	{
		mRibbonGeom = 0;
		mLoop = false;
	}
	~sTrailInfo()
	{
		SAFE_NIDELETE(mRibbonGeom);
	}
};

///   
class cDynamicSceneNode : public cSceneNode
{
	friend class cSceneManager;

public:
	/// ó
	virtual void OnProcess( float deltaTime, float accumTime  );
	virtual bool OnVisible( cSceneCuller& culler );

	virtual bool Pick( const NiPoint3& origin, const NiPoint3& dir );

	/// ̵
	virtual bool Move( float /*x*/, float /*y*/ ) { return true; }

	///  ü ٲ۴. ( ü ο ü üѴ.)
	virtual bool			ChangeParts( unsigned int /*partIdx*/, const char* /*fileName*/ ) { return true; }
	virtual bool			ChangeParts( unsigned int partsIdx, NiNode* pNode );

	virtual bool			ChangePartsTexture( unsigned int /*partsIdx*/, const char* /*fileName*/ ) { return true; }
	virtual bool			ChangePartsTexture( unsigned int /*partsIdx*/, NiTexture* /*pTex*/ );

	/// ̿ ü ũ ũ Ѵ. ( ߰  )
	virtual unsigned int	LinkObrject( unsigned int /*dummyIdx*/, const char* /*fileName*/ ) { return UINT_MAX; }
	virtual unsigned int	LinkObject( unsigned int dummyIdx, NiNode* pNode );

	/// ũ 
	void					UnLinkObject( unsigned int linkIdx );

	cEffectSceneNode* 		LinkEffect( unsigned int dummyIdx, const char* fileName, NiTransform* trans, bool bLoop, bool bFollow );
	void					UnLinkEffect( cEffectSceneNode* pnode );

	void ClearAllEffect();

	/////  ü ũϴ  ƴϰ,
	cSoundSceneNode*		LinkSound( unsigned long soundIdx, bool bLoop );
	void					UnLinkSound( cSoundSceneNode* pnode );

	//cEffectSceneNode*		LinkDamage( unsigned int dummyIdx, const char* fileName, NiTransform* trans, bool bLoop, bool bFollow );

	sTrailInfo*				LinkTrailEffect( cString str, float lifeTime, unsigned int link1, unsigned int link2, float lenPer, float factor );
	void					UnLinkTrailEffect( sTrailInfo* pInfo );


	/////  ü ũ ȿ Ʈ  ˻Ѵ.
	bool					IsLinkedEffect( cEffectSceneNode* pnode );
	bool					IsLinkedSound( cSoundSceneNode* pnode );

	NiAVObject*				GetLinkObject( unsigned int linkId );

	/// 
	void	UpdateAniScaleFactor( float factor );

	///  
	/// : ٿ ڽ ߽ ƴϴ.
	virtual NiPoint3 GetObjectCenter() = 0;

	///  ü
	virtual NiAVObject*		GetPartObject( unsigned int index ) const;
	virtual NiAVObject*		GetPartWeapon( unsigned int /*objectIdx*/, bool /*left*/ ) { return 0; }

	///  ڸ 
	inline cActorManagerForPartition* GetActorManager() { return mActorManager; }

	///  ִϸ̼
	cActorManagerForPartition::EventCode GetTargetAnimation() const { return mTargetAnimation; }
	virtual void SetTargetAnimation( unsigned int code );
	virtual bool UpdateTargetAnimation( unsigned int code );

	///  ü  
	//inline cBaseObject* GetGameObject() { return mpGameObject; }

	/// ü  Morpher ϱ ؼ..
	void StartMorpher();
	void StopMorpher();

	/// ǳ ǥ.
	//virtual void ActiveChatBubble( LPTSTR msg, unsigned long color );

	/// ü ̸ǥ
	//void UpdateNameCardTextValue();
	//void UpdateNameCardGaugeValue();

	/// 
	void GotoLastFrame();

	/// 
	virtual float GetRadius() const;

	inline void SetBaseAnimationIndex( unsigned int idx ) { mBaseAnimationIndex = idx; }
	inline unsigned int GetBaseAnimationIndex() { return mBaseAnimationIndex; }

protected:
	cDynamicSceneNode( eType type = eDYNAMIC );
	virtual ~cDynamicSceneNode();

	/// ʱȭ
	virtual bool Init( const cDynamicSceneNodeParam& param );


	/// picking  ڽ, , Ǹ ü .
	void CollectPickData( NiAVObject* pobj );

	void LinkDataInit( NiNode* node );

	/// 
	//virtual cObjectNameCard* CreateNameCard( cBaseObject* pObj ) = 0;
	//virtual void CreateShadow();

	///->
	/// ũ  ʱȭ Ѵ.
	virtual bool InitLinkInfo() = 0;

	///   ʱȭ Ѵ.
	virtual bool InitPartsName() = 0;

	/// Idleִϰ   ʱȭ Ѵ.
	virtual void InitializeRandomIdle() {}

	/// е带  ̴ 쿡 ó (ü ó ..)
	virtual void	UpdateBipedRootTransforms( float /*time*/ ) {}

	/// ü  Ѵ.
	void			KeepParts( unsigned int partIdx );

	/// ÿ   ó ʿ
	virtual void AddToVisibleArray( NiVisibleArray* psolidArray, NiVisibleArray* pskinedArray, NiVisibleArray* palphaArray );
	//virtual void AddDepthPlaneObject() const;

	virtual void ProcessTrail( float /*delta*/ ) {}

	virtual bool CheckParts( unsigned int /*partIdx*/ ) { return false; }

protected:
	struct sBoneDataObj : public NiMemObject
	{
		///  
		NiSkinData::BoneData* pBoneData;

		///   
		NiTPrimitiveSet<NiSkinData::BoneVertData*> BoneVertData;
	};

	struct sLinkInfo : public NiMemObject
	{
		///  ε
		unsigned int DummyIndex;

		///  Geom  
		//		NiGeometry* pObject;
		NiAVObject* pObject;
	};

protected:
	///  
	cActorManagerForPartition* mActorManager;

	///  ִ ε
	cActorManagerForPartition::EventCode mTargetAnimation;

	///    
	NiGeomMorpherController* mMorpherController;
	float mEyeMorpherTime;
	bool mStopMorpherProcess;

	/// ũ ֱ
	float mWinkInterval;

	/// Idleִ 
	NiTPrimitiveArray<cActorManagerForPartition::EventCode>* mRandomIdle;

	///  ̿ LinkǾ ü 
	NiTPrimitiveArray<sLinkInfo*>* mLinkInfo;

	///  ɷ ִ Effect 
	NiTPointerList<cEffectSceneNode*> mEffectList;
	NiTPointerList<cSoundSceneNode*> mSoundList;

	///  Ʈ Geomü ̸ (׷ ۽  ̸ Ѵ.)
	NiTPointerMap<unsigned int, const char*> mPartsNameMap;

	/// ü   
	NiAVObject*		mHead;
	float			mHeadDist;

	/// ü  ǥϱ  ü
	//cObjectNameCard*		mpNameCard;

	/// ǳ
	//cChatBubble*			mpChatBubble;

	typedef tList<void*> cPickDataList;
	cPickDataList mPickDataList;

	NiTPointerList<sTrailInfo*> mRibbonList;
	NiTPointerList<sTrailInfo*> mDeleteRibbonList;

protected:
	/// ִ ӵ 
	float	mScaleAccumTime;
	float	mLastTime;
	float	mScaleFactor;

	/// ִϸ̼ ε ϱ    ´.
	cModelInstance* mModel;

	///  ü  ( Ӱü ϴ ٸ)
	//cBaseObject*	mpGameObject;

	unsigned int	mBaseAnimationIndex;

	/// 
	float mRadius;
};
