#include "stdafx.h"
#include "gameResourceManager.h"
#include "ResourceManager.h"
#include "Player_Common.h"
#include "SkillScript.h"

#include "UIText.h"

#include "GameFileLexer.h"
#include "Parser.h"
#include "FileSystem.h"

#define HAIRCOLOR_KEY(hair,color)	(unsigned int)(((unsigned char)(hair)|((unsigned short)((unsigned char)(color))<<8)))

cGameResourceManager* cGameResourceManager::mpGameResourceManager = NULL;

cGameResourceManager::cGameResourceManager()
{
	mpGameResourceManager = this;

	mpSkillScript = 0;

	mpGameText = 0;
	mpSkillNameText = 0;
	mpNpcNameText = 0;
	mpMonsterNameText = 0;

	mHairColorMax = 0;

	mBaseFaceCount = 0;

}

cGameResourceManager::~cGameResourceManager()
{
	delete mpMonsterNameText;
	delete mpNpcNameText;
	delete mpItemNameText;
	delete mpSkillNameText;
	delete mpGameText;
}

/* ------------------------------------------------------------------
 * Լ̸ :	Init()
 *      :	Application Init() ȴ.
 *				α׷  ѹ εȴ.
 * ǻ :	 εؾ ϴ°͵鸸 .. (Selectâ Makeâ  ͵)
 * ------------------------------------------------------------------ */
bool cGameResourceManager::Init()
{
	//////////////////////////////////////////////////////////////////////////
	/// ũƮ  εѴ.

	/// Game ؽƮ 
	if( !LoadGameText() )
	{
		NiMessageBox( "Lang ׷̵ üũ!!", "Error" );
		return false;
	}

	/// Model
	if( !LoadModelFileInfo() )
	{
		NiMessageBox( "ModelFileList.txt üũϼ!!", "Error" );
		return false;
	}

	if( !LoadCharacterBaseHairFileInfo() )
	{
		NiMessageBox( "CharacterHairFile.txt üũϼ!!", "Error" );
		return false;
	}

	if( !LoadCharacterBaseFileInfo() )
	{
		NiMessageBox( "CharacterBaseFile.txt üũϼ!!", "Error" );
		return false;
	}

	if( !LoadFaceEmotionInfo() )
	{
		NiMessageBox( "EmotionList.txt üũϼ!!", "Error" );
		return false;
	}

	///
	if( !LoadItemInfo() )
	{
		NiMessageBox( "Item_Define.txt üũϼ!!", "Error" );
		return false;
	}

	if( !LoadItemFileInfo() )
	{
		NiMessageBox( "Item_FileName.txt üũϼ!!", "Error" );
		return false;
	}

	if( !LoadMonsterInfo() )
	{
		NiMessageBox( "MonsterList.txt üũϼ!!", "Error" );
		return false;
	}

	if( !LoadNpcInfo() )
	{
		NiMessageBox( "NPCList.txt üũϼ!!", "Error" );
		return false;
	}

	mpSkillScript = new cSkillScript;
	if( !mpSkillScript->Init() )
	{
		return false;
	}

	//////////////////////////////////////////////////////////////////////////
	///  ׷ ͵ εѴ.

	/// 1. ⺻ ̽ ̹ ε..

	/// 2. ⺻   ε..

	/// 3. kfm ε..
	cArrayHashMap::cIterator i = mModelFileNameMap.Begin();
	cArrayHashMap::cIterator end = mModelFileNameMap.End();
	cString* pModelFile;

	for( ; i != end; ++i )
	{
		unsigned long idx = (unsigned long)(*i).mFirst;
		pModelFile = (cString*)(*i).mSecond;

		if( pModelFile )
		{
			cString pathName;
			if( idx <= 100 )
				pathName.Format( "Data/Character/%s", pModelFile->Cstr() );
			else if( idx <= 1000 )
				pathName.Format( "Data/Npc/%s", pModelFile->Cstr() );
			else
				pathName.Format( "Data/Monster/%s", pModelFile->Cstr() );

			RESOURCEMAN->LoadKFM( pathName );
		}
	}

	unsigned int characterCount = eGENDER_MAX * eRACE_MAX;
	cFileNameArray* pArray = 0;
	cArrayHashMap::cIterator iter;
	cArrayHashMap::cIterator iterEnd;
	cString* name = NULL;

	/// default hair loading
	iter = mDefaultHairFileNameMap.Begin();
	iterEnd = mDefaultHairFileNameMap.End();
	for( ; iter != iterEnd; ++iter )
	{
		pArray = (cFileNameArray*)(*iter).mSecond;
		if( pArray )
		{
			for( unsigned int cnt=0; cnt<characterCount; ++cnt )
			{
				name = (cString*) (*pArray)[cnt];
				if( name && name->GetLength() )
				{
					cString pathName;
					pathName.Format( "Data/Character/%s", name->Cstr() );
					RESOURCEMAN->LoadNIF( pathName );
				}
			}
		}
	}

	/// default face loading
	iter = mDefaultFaceFileNameMap.Begin();
	iterEnd = mDefaultFaceFileNameMap.End();
	for( ; iter != iterEnd; ++iter )
	{
		pArray = (cFileNameArray*)(*iter).mSecond;
		if( pArray )
		{
			for( unsigned int cnt=0; cnt<characterCount; ++cnt )
			{
				name = (cString*) (*pArray)[cnt];
				if( name && name->GetLength() )
				{
					cString pathName;
					pathName.Format( "Data/Character/%s", name->Cstr() );
					RESOURCEMAN->LoadNIF( pathName );
				}
			}
		}
	}

	/// default body, hand, foot loading
	iter = mDefaultWearFileNameMap.Begin();
	iterEnd = mDefaultWearFileNameMap.End();
	for( ; iter != iterEnd; ++iter )
	{
		pArray = (cFileNameArray*)(*iter).mSecond;
		if( pArray )
		{
			for( unsigned int cnt=0; cnt<characterCount; ++cnt )
			{
				name = (cString*) (*pArray)[cnt];
				if( name && name->GetLength() )
				{
					cString pathName;
					pathName.Format( "Data/Character/%s", name->Cstr() );
					RESOURCEMAN->LoadNIF( pathName );
				}
			}
		}
	}
	//
	//////////////////////////////////////////////////////////////////////////

	return true;
}

/* ------------------------------------------------------------------
 * Լ̸ :	Exit()
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
void cGameResourceManager::Exit()
{
	mpSkillScript->Release();
	SAFE_DELETE( mpSkillScript );

	RemoveAllCharacterBaseFileInfo();
	RemoveAllModelFileName();

	/// 
	{
		cArrayHashMap::cIterator i = mItemInfo.Begin();
		cArrayHashMap::cIterator iend = mItemInfo.End();

		for( ; i != iend; ++i )
		{
			delete (sItemInfo*)(i->mSecond);
		}
		mItemInfo.Clear();
	}

	/// ϸ
	{
		cArrayHashMap::cIterator i = mItemFileInfo.Begin();
		cArrayHashMap::cIterator iend = mItemFileInfo.End();

		for( ; i != iend; ++i )
		{
			delete [] ((cString*)(i->mSecond));
		}
		mItemFileInfo.Clear();
	}

	{
		cArrayHashMap::cIterator i = mFaceEmotionMap.Begin();
		cArrayHashMap::cIterator end = mFaceEmotionMap.End();
		for( ; i != end; ++i )
		{
			sFaceEmoteInfo* p = (sFaceEmoteInfo*)(*i).mSecond;
			SAFE_DELETE(p);
		}
		mFaceEmotionMap.Clear();
	}
}


/* ------------------------------------------------------------------
 * Լ̸ :	GetModelFileName( unsigned long modelIndex )
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
const char* cGameResourceManager::GetModelFileName( unsigned long modelIndex )
{
	cString* str = (cString*)mModelFileNameMap.GetAt( modelIndex );
	if( !str ) return 0;

	return (*str).Cstr();
}

/* ------------------------------------------------------------------
 * Լ̸ :	LoadModleFileInfo()
 *      :	 ϵ εѴ.
 * ǻ :	
 * ------------------------------------------------------------------ */
bool cGameResourceManager::LoadModelFileInfo()
{
	///  
	cFileLoader loader;
	if( loader.Open( "./Script/Resource/ModelFileList.txt", true ) == false )
	{
		return false;
	}

	///
	cToken token;
	cLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, "./Script/Resource/ModelFileList.txt" );

	unsigned long fileIdx;
	cString* name = NULL;

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_INT:	
			{
				name = NiNew cString;

				fileIdx = token.ToInt();
				*name = parser.ParseString();

				mModelFileNameMap.Insert( fileIdx, name );
				name = NULL;
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}

	return true;
}

/* ------------------------------------------------------------------
 * Լ̸ :	GetDefaultHairFileName( unsigned int hairIdx, char race, char gender )
 *      :	⺻ Ӹ ϸ 
 * ǻ :	
 * ------------------------------------------------------------------ */
const char* cGameResourceManager::GetDefaultHairFileName( unsigned int hairIdx, char race, char gender )
{
	assert(race < eRACE_MAX);
	assert(gender < eGENDER_MAX);
	if( race < eRACE_MAX || gender < eGENDER_MAX )
	{
		cFileNameArray* pArray = (cFileNameArray*)mDefaultHairFileNameMap.GetAt( hairIdx );
		if( pArray ) 
		{
			cString* name = (cString*)(*pArray)[(race*eGENDER_MAX) + gender];
			if( name )
				return name->Cstr();
		}
	}
	return NULL;
}

const char* cGameResourceManager::GetHairColorTextureFileName( unsigned int hairIdx, unsigned int colorIdx, char race, char gender )
{
	if( colorIdx >= mHairColorMax )
		return NULL;

	assert(race < eRACE_MAX);
	assert(gender < eGENDER_MAX);
	if( race < eRACE_MAX || gender < eGENDER_MAX )
	{
		unsigned int key = HAIRCOLOR_KEY(hairIdx,colorIdx);

		cFileNameArray* pArray = (cFileNameArray*)mHairColorTextureMap.GetAt( key );
		if( pArray ) 
		{
			cString* name = (cString*)(*pArray)[(race*eGENDER_MAX) + gender];
			if( name )
				return name->Cstr();
		}
	}

	return NULL;
}

/* ------------------------------------------------------------------
 * Լ̸ :	GetDefaultFaceFileName( unsigned int faceIdx, char race, char gender )
 *      :	⺻  ϸ 
 * ǻ :	
 * ------------------------------------------------------------------ */
const char* cGameResourceManager::GetDefaultFaceFileName( unsigned int faceIdx, char race, char gender )
{
	assert(race < eRACE_MAX);
	assert(gender < eGENDER_MAX);
	if( race < eRACE_MAX || gender < eGENDER_MAX )
	{
		cFileNameArray* pArray = (cFileNameArray*)mDefaultFaceFileNameMap.GetAt( faceIdx );
		if( pArray ) 
		{
			cString* name = (cString*)(*pArray)[(race*eGENDER_MAX) + gender];
			if( name )
				return name->Cstr();
		}
	}
	return NULL;
}

const char* cGameResourceManager::GetFaceTextureFileName( unsigned long idx, char race, char gender )
{
	assert(race < eRACE_MAX);
	assert(gender < eGENDER_MAX);
	if( race < eRACE_MAX || gender < eGENDER_MAX )
	{
		sFaceEmoteInfo* info = (sFaceEmoteInfo*)mFaceEmotionMap.GetAt(idx);
		if( info )
		{
			if( info->textureName[race*eGENDER_MAX+gender].Compare("None") == 0 )
				return NULL;

			return info->textureName[race*eGENDER_MAX+gender].Cstr();
		}
	}
	return NULL;
}

/* ------------------------------------------------------------------
* Լ̸ :	GetDefaultWearFileName( unsigned int part, char race, char gender )
*      :	  ⺻ ׷  ̸ Ѵ.
* ǻ :	
* ------------------------------------------------------------------ */
const char*	cGameResourceManager::GetDefaultWearFileName( unsigned int part, char race, char gender )
{
	assert(race < eRACE_MAX);
	assert(gender < eGENDER_MAX);
	if( race < eRACE_MAX || gender < eGENDER_MAX )
	{
		cFileNameArray* pArray = (cFileNameArray*)mDefaultWearFileNameMap.GetAt( part );
		if( pArray ) 
		{
			cString* name = (cString*)(*pArray)[(race*eGENDER_MAX) + gender];
			if( name )
				return name->Cstr();
		}
	}
	return NULL;
}

/* ------------------------------------------------------------------
 * Լ̸ :	LoadCharacterBaseFileInfo()
 *      :	ĳ ⺻ ü εѴ.
 * ǻ :	
 * ------------------------------------------------------------------ */
bool cGameResourceManager::LoadCharacterBaseFileInfo()
{
	///  
	cFileLoader loader;
	if( loader.Open( "./Script/Resource/CharacterBaseFile.txt", true ) == false )
	{
		return false;
	}

	///
	cToken token;
	cLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, "./Script/Resource/CharacterBaseFile.txt" );

	cFileNameArray* pArray = 0;
	unsigned int index = 0;
	char type = 0;
	cString* fileName = 0;

	unsigned int count = eRACE_MAX * eGENDER_MAX;
	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_INT:	
			{
				pArray = new cFileNameArray;
				pArray->Reserve( count );

				// ε 	 ϸ(count )
				index = token.ToInt();
				type = (char)parser.ParseInt();
				for( unsigned int i=0; i<count; ++i)
				{
					fileName = new cString;
					*fileName = parser.ParseString();
					pArray->PushBack( fileName );
				}

				switch( type )
				{
				case ePART_FACE:
					{
						mDefaultFaceFileNameMap.Insert( index, pArray );
					}
					break;
				case ePART_BODY1:
				case ePART_BODY2:
				case ePART_HAND:
				case ePART_FOOT:
					mDefaultWearFileNameMap.Insert( type, pArray );
				}
				pArray = NULL;
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}
	return true;
}

bool cGameResourceManager::LoadFaceEmotionInfo()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/EmotionList.txt";
	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load MapData.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	unsigned int count = eRACE_MAX * eGENDER_MAX;
	sFaceEmoteInfo* pInfo = 0;
	unsigned long filterKey = 0;
	while( tokenizer.IsEnd() == false )
	{
		pInfo = new sFaceEmoteInfo;

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->index = str.ToInt();

		/// type
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pInfo->type = (unsigned char)str.ToInt();

		/// texture file name
		for( unsigned int i=0; i<count; i++ )
		{
			if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
			pInfo->textureName[i] = str;
		}

		/// filter text index
		for( unsigned int i=0; i<10; i++ )
		{
			if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
			filterKey = str.ToInt();
		}

		/// ؽ   
		if( mFaceEmotionMap.Insert( pInfo->index, pInfo ) == false )
		{
			assert(0);
		}

		if( pInfo->type == 0 )
			mBaseFaceCount++;
	}

	return true;

ERR:
	delete pInfo;
	return false;
}

bool cGameResourceManager::LoadCharacterBaseHairFileInfo()
{
	///  
	cFileLoader loader;
	if( loader.Open( "./Script/Resource/CharacterHairFile.txt", true ) == false )
	{
		return false;
	}

	///
	cToken token;
	cGameFileLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, "./Script/Resource/CharacterHairFile.txt" );

	while( lexer.IsEnd() == false )
	{
		lexer.GetNextToken( &token );

		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_HAIR:
			{
				if( LoadHair(parser) == false )
				{
					assert(0);
					return false;
				}
			}
			break;
		case eTOKEN_HAIRCOLOR:
			{
				mHairColorMax = parser.ParseInt();
				if( LoadHairColor(parser) == false )
				{
					assert(0);
					return false;
				}
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}

	return true;
}

bool cGameResourceManager::LoadHair( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		assert( 0 && "wrong script" );
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	cFileNameArray* pArray = 0;
	unsigned int index = 0;
	cString* fileName = 0;

	unsigned int count = eRACE_MAX * eGENDER_MAX;
	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			break;
		}
		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_INT:
			{
				pArray = new cFileNameArray;
				pArray->Reserve( count );

				// ε 	 ϸ(count )
				index = token.ToInt();
				for( unsigned int i=0; i<count; ++i)
				{
					fileName = new cString;
					*fileName = parser.ParseString();
					pArray->PushBack( fileName );
				}

				mDefaultHairFileNameMap.Insert( index, pArray );
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}

	return true;
}

bool cGameResourceManager::LoadHairColor( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		assert( 0 && "wrong script" );
		return false;
	}

	cToken token;
	cLexer* lexer = parser.GetLexer();

	cFileNameArray* pArray = 0;
	unsigned int hairIdx = 0;
	unsigned int colorIdx = 0;
	cString* fileName = 0;

	unsigned int count = eRACE_MAX * eGENDER_MAX;
	while( lexer->GetNextToken( &token ) )
	{
		if( token == "}" )
		{
			break;
		}
		switch( token.mType )
		{
		case eTOKEN_ERROR:
			return false;
		case eTOKEN_NULL:
			continue;
		case eTOKEN_INT:
			{
				pArray = new cFileNameArray;
				pArray->Reserve( count );

				// Ű 
				hairIdx = token.ToInt();
				colorIdx = parser.ParseInt();
				unsigned int key = HAIRCOLOR_KEY(hairIdx,colorIdx);

				for( unsigned int i=0; i<count; ++i)
				{
					fileName = new cString;
					*fileName = parser.ParseString();
					pArray->PushBack( fileName );
				}

				mHairColorTextureMap.Insert( key, pArray );
			}
			break;
		default:
			assert( 0 && "invalid token" );
			return false;
		}
	}

	return true;
}

/* ------------------------------------------------------------------
 * Լ̸ :	RemoveAllModleFileName()
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
void cGameResourceManager::RemoveAllModelFileName()
{
	cArrayHashMap::cIterator i = mModelFileNameMap.Begin();
	cArrayHashMap::cIterator end = mModelFileNameMap.End();
	NiString* pModelFile;

	for( ; i != end; ++i )
	{
		pModelFile = (NiString*)(*i).mSecond;
		delete pModelFile;
	}
	mModelFileNameMap.Clear();
}

/* ------------------------------------------------------------------
 * Լ̸ :	RemoveAllCharacterBaseFileInfo()
 *      :	
 * ǻ :	
 * ------------------------------------------------------------------ */
void cGameResourceManager::RemoveAllCharacterBaseFileInfo()
{
	cFileNameArray* pArray = 0;
	cString* name = 0;

	/// ⺻   
	cArrayHashMap::cIterator i = mDefaultWearFileNameMap.Begin();
	cArrayHashMap::cIterator end = mDefaultWearFileNameMap.End();
	for( ; i != end; ++i )
	{
		pArray = (cFileNameArray*)(*i).mSecond;
		if( pArray )
		{
			for( unsigned int cnt=0; cnt< pArray->GetSize(); ++cnt )
			{
				name = (cString*)(*pArray)[cnt];
				SAFE_DELETE(name);
			}
			SAFE_DELETE(pArray);
		}
	}
	mDefaultWearFileNameMap.Clear();

	/// ⺻   
	i = mDefaultFaceFileNameMap.Begin();
	end = mDefaultFaceFileNameMap.End();
	for( ; i != end; ++i )
	{
		pArray = (cFileNameArray*)(*i).mSecond;
		if( pArray )
		{
			for( unsigned int cnt=0; cnt< pArray->GetSize(); ++cnt )
			{
				name = (cString*)(*pArray)[cnt];
				SAFE_DELETE(name);
			}
			SAFE_DELETE(pArray);
		}
	}
	mDefaultFaceFileNameMap.Clear();

	/// ⺻  ؽ  
	i = mHairColorTextureMap.Begin();
	end = mHairColorTextureMap.End();
	for( ; i != end; ++i )
	{
		pArray = (cFileNameArray*)(*i).mSecond;
		if( pArray )
		{
			for( unsigned int cnt=0; cnt< pArray->GetSize(); ++cnt )
			{
				name = (cString*)(*pArray)[cnt];
				SAFE_DELETE(name);
			}
			SAFE_DELETE(pArray);
		}
	}
	mHairColorTextureMap.Clear();

	/// ⺻   
	i = mDefaultHairFileNameMap.Begin();
	end = mDefaultHairFileNameMap.End();
	for( ; i != end; ++i )
	{
		pArray = (cFileNameArray*)(*i).mSecond;
		if( pArray )
		{
			for( unsigned int cnt=0; cnt< pArray->GetSize(); ++cnt )
			{
				name = (cString*)(*pArray)[cnt];
				SAFE_DELETE(name);
			}
			SAFE_DELETE(pArray);
		}
	}
	mDefaultHairFileNameMap.Clear();
}

bool cGameResourceManager::LoadItemInfo()
{
	cFileLoader loader;

	if( loader.Open( "./Script/Resource/Item_Define.txt", true ) == false )
	{
		assert( 0 && "failed to load item define" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), "\t\r\n", "./Script/Resource/Item_Define.txt" );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = (long)str.ToInt();
		assert( index > 0 );

		/// ̸
		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ̸ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int nameIndex = (unsigned int)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		unsigned int tipIndex = (unsigned int)str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned char type = (unsigned char)str.ToInt();

		///  
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned char subType = (unsigned char)str.ToInt();

		/// 
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		short weight = (short)str.ToInt();

		/// ħ
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		short capacity = (short)str.ToInt();

		/// ǸŹ
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		unsigned long sellType = (unsigned long)str.ToInt();

		/// ǸŰ
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		unsigned long sellPrice = (unsigned long)str.ToInt();

		/// Թ
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		unsigned long buyType = (unsigned long)str.ToInt();

		/// ԰
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		unsigned long buyPrice = (unsigned long)str.ToInt();

		/// ִ 
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		unsigned short presentNum = (unsigned short)str.ToInt();

		///  ɰ
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		unsigned long maxHaveInven = (unsigned long)str.ToInt();

		/// ڰŷ (0ŷ/1ŷҰ)
		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ɷ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		long abilityIndex = (long)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		long limitIndex = (long)str.ToInt();

		/// ī ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		//long cardIndex = (long)str.ToInt();

		/// Ÿ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		long tarotIndex = (long)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		long spreadIndex = (long)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		long disjointIndex = (long)str.ToInt();

		/// ī彽 ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		long cardSlotIndex = (long)str.ToInt();

		/// ȭȮ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		long enhanceRateIndex = (long)str.ToInt();

		/// ȭ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		long enhanceIndex = (long)str.ToInt();

		/// ü ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		/// ȣĪ ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		long titleIndex = (long)str.ToInt();

		///  ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		unsigned int iconIndex = (unsigned int)str.ToInt();

		///  ε0
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int fileIndex0 = (unsigned int)str.ToInt();

		///  ε1
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned int fileIndex1 = (unsigned int)str.ToInt();

		///  ̱ (0:Ӹǥ, 1:Ӹǥ )
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		char showHead = (char)str.ToInt();

		///  ÷ (  )
		if( tokenizer.GetNext( &str ) == false )
			return false;

//		unsigned short tooltipColor = (unsigned short)str.ToInt();

		sItemInfo* p = new sItemInfo;
		p->mIndex = index;
		p->mNameIndex = nameIndex;
		p->mType = type;
		p->mSubType = subType;
		p->mModelIndex1 = fileIndex0;
		p->mModelIndex2 = fileIndex1;

		if( mItemInfo.Insert( index, p ) == false )
		{
			assert( 0 && "failed to insert item define, maybe already exist" );
			return false;
		}
	}
	return true;
}

bool cGameResourceManager::LoadItemFileInfo()
{
	cFileLoader loader;

	if( loader.Open( "./Script/Resource/Item_FileName.txt", true ) == false )
	{
		assert( 0 && "failed to load item file name" );
		return false;
	}

	unsigned int iend = eRACE_MAX * eGENDER_MAX;

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", "./Script/Resource/Item_FileName.txt" );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		long index = str.ToInt();
		assert( index > 0 );

		iend = eRACE_MAX * eGENDER_MAX;

		///   ̸ 迭 
		cString* p = new cString[iend];

		for( unsigned int i = 0; i < iend; ++i )
		{
			if( tokenizer.GetNext( &(p[i]) ) == false )
			{
				delete [] p;
				return false;
			}
		}

		if( mItemFileInfo.Insert( index, p ) == false )
		{
			assert( 0 && "failed to insert item file names, maybe already exist" );
			return false;
		}
	}
	return true;
}

bool cGameResourceManager::LoadMonsterInfo()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/MonsterList.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load MonsterList.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sMonsterInfo* info = NULL;
	while( tokenizer.IsEnd() == false )
	{
		info = new sMonsterInfo;

		//  index
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		info->mIndex = str.ToInt();

		///  ̸Idx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		info->mNameIndex = str.ToInt();

		char name[32];
		///  ̸
		::sprintf( name, "%s", GAMERESOURCEMAN->GetMonsterName( info->mNameIndex ) ); 
		info->mName = name;

		/// kfmidx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		info->mModelIndex = str.ToInt();

		/// ̸ ̰
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// з
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// Ӽ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// HP
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// MP
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// expȹ淮
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// sxpȹ淮
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ȸ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// þ߹
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ũ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		info->mScale = str.ToFloat();

		/// ع -  
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ൿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ൿ()
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ൿ(ȱ)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ൿ(ٱ)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ð
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ̵ӵ(ȱ)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ̵ӵ(ٱ,)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ð
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ȸ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ȸ۽ð
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }

		/// ؽ   
		if( mMonsterInfo.Insert( info->mIndex, info ) == false )
		{
			assert(0);
			return false;
		}
	}

	return true;

ERR:
	delete info;
	return false;
}

bool cGameResourceManager::LoadNpcInfo()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/NPCList.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load NPCList.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// NPC ȣ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long npcClassIdx = str.ToInt(); 

		/// NPC ̸
		if( tokenizer.GetNext( &str ) == false )	{ return false; }

		unsigned long nameIdx = str.ToInt();

		char name[32];
		::sprintf( name, "%s", GAMERESOURCEMAN->GetNpcName( nameIdx ) ); 

		/// NPC  ε
		if( tokenizer.GetNext( &str ) == false )	{ return false; }

//		char jobName[32];
//		_stprintf( jobName, _T( "%s" ), GAMERESOURCEMAN->GetNpcName( str.ToInt() ) ); 

		/// NPC ִϸ̼  ȣ(KFM)]
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned char modelIndex = static_cast<unsigned char>(str.ToInt()); 

		if( tokenizer.GetNext( &str ) == false )	{ return false; }

		if( tokenizer.GetNext( &str ) == false )	{ return false; }

		sNpcInfo* info = new sNpcInfo;

		info->mIndex = npcClassIdx;
		char str[32];
		::sprintf( str, "%s", name );
		info->mName = str;
		info->mNameIndex = nameIdx;
		info->mModelIndex = modelIndex;

		/// ؽ NPC  
		if( mNpceInfo.Insert( info->mIndex, info ) == false )
		{
			assert(0);
			delete info;
			return false;
		}
	}

	return true;
}

///
bool cGameResourceManager::LoadGameText()
{
	///
	mpGameText = new cUIText;
	if( !mpGameText )
	{
		assert( 0 && "mpGameText not create!" );
		return false;
	}
	if( mpGameText->Load( "./Script/Language/SystemMsg.txt" ) == false )
	{
		assert( 0 && "failed to load GameText" );
		return false;
	}

	/// ų
	mpSkillNameText = new cUIText;
	if( !mpSkillNameText )
	{
		assert( 0 && "mpSkillNameText not create!" );
		return false;
	}
	if( mpSkillNameText->Load( "./Script/Language/Skill_Name.txt" ) == false )
	{
		assert( 0 && "failed to load GameText" );
		return false;
	}

	/// item̸
	mpItemNameText = new cUIText;
	if( !mpItemNameText )
	{
		assert( 0 && "mpItemNameText not create!" );
		return false;
	}
	if( mpItemNameText->Load( "./Script/Language/Item_Name.txt" ) == false )
	{
		assert( 0 && "failed to load GameText" );
		return false;
	}

	/// NPC ̸
	mpNpcNameText = new cUIText;
	if( !mpNpcNameText )
	{
		assert( 0 && "mpNpcNameText not create!" );
		return false;
	}
	if( mpNpcNameText->Load( "./Script/Language/NPC_Name.txt" ) == false )
	{
		assert( 0 && "failed to load NpcName" );
		return false;
	}

	///  ̸
	mpMonsterNameText = new cUIText;
	if( !mpMonsterNameText )
	{
		assert( 0 && "mpMonsterNameText not create!" );
		return false;
	}
	if( mpMonsterNameText->Load( "./Script/Language/Mon_Name.txt" ) == false )
	{
		assert( 0 && "failed to load MonsterName" );
		return false;
	}

	return true;
}

LPCTSTR cGameResourceManager::GetGameText( unsigned int textIdx )
{
	assert(mpGameText);
	return mpGameText->GetText( textIdx ).Cstr();
}

LPCTSTR cGameResourceManager::GetSkillNameText( unsigned int textIdx )
{
	assert(mpSkillNameText);
	return mpSkillNameText->GetText( textIdx ).Cstr();
}

LPCTSTR cGameResourceManager::GetNpcName( unsigned int nameIdx )
{
	assert( mpNpcNameText );
	return mpNpcNameText->GetText( nameIdx ).Cstr();
}

LPCTSTR cGameResourceManager::GetMonsterName( unsigned int nameIdx )
{
	assert( mpMonsterNameText );
	return mpMonsterNameText->GetText( nameIdx ).Cstr();
}

LPCTSTR cGameResourceManager::GetItemNameText( unsigned int nameIdx )
{
	assert(mpItemNameText);
	return mpItemNameText->GetText( nameIdx ).Cstr();
}

const char* cGameResourceManager::GetItemFileName( unsigned long itemFileIdx, char race, char gender, bool weapon )
{
	if( itemFileIdx == 0 )
		return 0;

	cArrayHashMap::cConstIterator i = mItemFileInfo.Find( itemFileIdx );

	if( i == mItemFileInfo.End() )
		return 0;

	cString* p = (cString*)i->mSecond;
	if( p[race * eGENDER_MAX + gender] == "None" )
	{
		if( weapon )
			return p[0].Cstr();

		return 0;
	}

	return p[race * eGENDER_MAX + gender].Cstr();
}
