/* ====================================================================
 *      :	GameResourceManager.h
 *      :	 ҽ(ũƮ ϵ) 
 *    :	̹
 *    :	2006.06
 *
 * ߰ :
 *		߰¥ 	۾		߰
 *		2006.06     ̹	    
 * 
 * ǻ :	
 * =================================================================== */
#pragma once
#include "Player_Common.h"

class cSkillScript;

struct sNpcInfo
{
	unsigned long mIndex;

	cString mName;
	unsigned long mNameIndex;

	unsigned long mModelIndex;
};

struct sMonsterInfo
{
	unsigned long mIndex;

	cString		mName;
	unsigned long mNameIndex;

	unsigned long mModelIndex;

	float mScale;
};

struct sItemInfo
{
	unsigned long mIndex;

	unsigned char mType;
	unsigned char mSubType;

	unsigned long mNameIndex;

	unsigned long mModelIndex1;
	unsigned long mModelIndex2;
};

struct sFaceEmoteInfo
{
	unsigned long	index;				/// list index
	unsigned char	type;				/// 0:base, 1:wink, 2:emote

	cString			textureName[eRACE_MAX*eGENDER_MAX];
};

class cUIText;
class cParser;

//     ڷᱸ..
typedef tPointerHashMap<unsigned long, void*>	cArrayHashMap;
typedef tArray<void*>							cFileNameArray;

typedef tArray<void*>	cArray;

class cGameResourceManager
{
public:
	static cGameResourceManager* mpGameResourceManager;

	cGameResourceManager();
	~cGameResourceManager();

	/// ʱȭ
	bool Init();

	/// 
	void Exit();

	const char*	GetModelFileName( unsigned long modelIndex );

	///  ⺻ ϸ Ѵ.
	const char*	GetDefaultHairFileName( unsigned int hairIdx, char race, char gender );
	const char*	GetHairColorTextureFileName( unsigned int hairIdx, unsigned int colorIdx, char race, char gender );
	const char*	GetDefaultFaceFileName( unsigned int faceIdx, char race, char gender );
	const char*	GetDefaultWearFileName( unsigned int part, char race, char gender );

	const char*	GetFaceTextureFileName( unsigned long idx, char race, char gender );

	inline unsigned int	GetDefaultFaceCount() { return mBaseFaceCount; }
	inline unsigned int	GetDefaultHairCount() { return mDefaultHairFileNameMap.GetSize(); }
	inline unsigned int	GetHairColorCount() { return mHairColorMax; }

	LPCTSTR		GetGameText( unsigned int textIdx );

	LPCTSTR		GetSkillNameText( unsigned int textIdx );
	LPCTSTR		GetItemNameText( unsigned int nameIdx );

	LPCTSTR		GetNpcName( unsigned int nameIdx );
	LPCTSTR		GetMonsterName( unsigned int nameIdx );


	/// Item  
	cArrayHashMap*	GetItemList() { return &mItemInfo; }
	const char*		GetItemFileName( unsigned long itemFileIdx, char race, char gender, bool weapon );

	/// monster 
	cArrayHashMap*	GetMonsterList() { return &mMonsterInfo; }

	/// npc
	cArrayHashMap*	GetNpcList() { return &mNpceInfo; }

protected:

	/// Game Ǵ  ؽƮ εѴ.
	bool LoadGameText();

	///   ĳ ⺻  ..
	/// player, npc, monster  kfm
	bool LoadModelFileInfo();

	/// ĳ ⺻  nif..
	bool LoadCharacterBaseFileInfo();

	/// ĳ   ( / ؽ)
	bool LoadCharacterBaseHairFileInfo();
	bool LoadHair( cParser& parser );
	bool LoadHairColor( cParser& parser );

	bool LoadFaceEmotionInfo();

	bool LoadItemInfo();
	bool LoadItemFileInfo();

	bool LoadMonsterInfo();
	bool LoadNpcInfo();

	///  ͸ ε Ұ쿡 Ϸ  .
	void RemoveAllModelFileName();
	void RemoveAllCharacterBaseFileInfo();

protected:
	// text 
	cUIText*	mpGameText;

	cUIText*	mpItemNameText;

	cUIText*	mpSkillNameText;

	cUIText*	mpNpcNameText;

	cUIText*	mpMonsterNameText;

	/// kfm ( NiString  )
	cArrayHashMap mModelFileNameMap;

	/// Ӹ 
	cArrayHashMap mDefaultHairFileNameMap;

	/// Ӹ ( ؽ  )
	cArrayHashMap mHairColorTextureMap;
	unsigned int mHairColorMax;

	///  
	cArrayHashMap mDefaultFaceFileNameMap;

	/// ε ->      1  ´.
	cArrayHashMap mDefaultWearFileNameMap;

	cArrayHashMap			mFaceEmotionMap;
	unsigned int			mBaseFaceCount;

	///  
	cArrayHashMap mItemInfo;
	cArrayHashMap mItemFileInfo;

	///  Ʈ
	cArrayHashMap mMonsterInfo;
	cArrayHashMap mNpceInfo;

	cSkillScript*		mpSkillScript;

};

#define GAMERESOURCEMAN	cGameResourceManager::mpGameResourceManager
