/* ==========================================================================
*    : ̼
*    : 2007.02.08
*      :   ī޶ Ŭ
* ǻ : 
*===========================================================================*/
#pragma once

#include "Camera.h"

///   ī޶
class cLookAtCamera : public cCamera
{
public:
	cLookAtCamera();
	virtual ~cLookAtCamera();

	/// 
	void SetLookAt( const NiPoint3& target );
	void SetLookAt( float x, float y, float z );
	const NiPoint3& GetLookAt() const;

	/// ǥκ  Ÿ
	float GetActualLookAtDistance() const;
	float GetDesiredLookAtDistance() const;

	void SetMinCameraDist( float dist );
	void SetMaxCameraDist( float dist );

protected:
	/// ó
	virtual void OnProcess( float deltaTime );
	virtual void OnProcessInput( float deltaTime );

protected:
	/// 
	NiPoint3 mLookAt;

	float mMinCameraDist;
	float mMaxCameraDist;

	/// 
	NiPoint3 mTargetDirection;
	NiPoint3 mDirection;

	/// ġ
	NiPoint3 mTargetPos;
	NiPoint3 mPos;

	/// ȸ 
	//float mTargetYawAngle;
	float mYawAngle;
	//float mTargetPitchAngle;
	float mPitchAngle;

	///  ī޶  Ÿ
	float mDesiredLookAtDistance;

	///   ī޶   Ÿ
	float mActualLookAtDistance;
};

inline void cLookAtCamera::SetLookAt( const NiPoint3& target )
{
	mLookAt = target;
}

inline void cLookAtCamera::SetLookAt( float x, float y, float z )
{
	mLookAt.x = x;
	mLookAt.y = y;
	mLookAt.z = z;
}

inline const NiPoint3& cLookAtCamera::GetLookAt() const
{
	return mLookAt;
}

inline float cLookAtCamera::GetActualLookAtDistance() const
{
	return mActualLookAtDistance;
}

inline float cLookAtCamera::GetDesiredLookAtDistance() const
{
	return mDesiredLookAtDistance;
}
