#include "StdAfx.h"
#include "MonsterSceneNode.h"
#include "ResourceManager.h"

//#include "ObjectNameCard.h"
#include "SceneManager.h"
#include "CameraManager.h"
#include "RenderSystem.h"

//#include "ChatBubble.h"

cMonsterSceneNode::cMonsterSceneNode( eType type )
: cDynamicSceneNode( type )
{
}

cMonsterSceneNode::~cMonsterSceneNode()
{
}

bool cMonsterSceneNode::Init( const cMonsterSceneNodeParam& param )
{
	if( cDynamicSceneNode::Init( param ) == false )
	{
		return false;
	}

	mHead = GetPartObject( eLINK_HEAD );
	//if( !mHead )
	//	assert(0);

	//if( param.mMakeChatBubble == true )
	//{
	//	/// ǳ ü 
	//	mpChatBubble = new cChatBubble;
	//}

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	InitLinkInfo()
*      :	ũ  ޸𸮸 ʱȭ Ѵ.
* ǻ :	
* ------------------------------------------------------------------ */
bool cMonsterSceneNode::InitLinkInfo()
{
	mLinkInfo = NiNew NiTPrimitiveArray<sLinkInfo*>(10, 2);
	assert(mLinkInfo);
	if( mLinkInfo == NULL ) 
	{
		return false;
	}

	for( unsigned int i=0; i<mLinkInfo->GetAllocatedSize(); ++i )
	{
		mLinkInfo->SetAt( i,0 );
	}

	return true;

}

/* ------------------------------------------------------------------
* Լ̸ :	InitPartsName()
*      :	׷  ü ̸ Ѵ.
* ǻ :	
* ------------------------------------------------------------------ */
bool cMonsterSceneNode::InitPartsName()
{
	mPartsNameMap.SetAt( eLINK_HEAD,	"head_dummy" );
	mPartsNameMap.SetAt( eLINK_BODY,	"body_dummy" );
	mPartsNameMap.SetAt( eLINK_RHAND,	"Rhand_dummy" );
	mPartsNameMap.SetAt( eLINK_LHAND,	"Lhand_dummy" );
	mPartsNameMap.SetAt( eLINK_FOOT,	"foot_dummy" );

	return true;
}

/* ------------------------------------------------------------------
* Լ̸ :	InitializeRandomIdle()
*      :	 پ缺 ϱ ؼ
* ǻ :	
* ------------------------------------------------------------------ */
void cMonsterSceneNode::InitializeRandomIdle()
{
	mRandomIdle = NiNew NiTPrimitiveArray<cActorManagerForPartition::EventCode>(1);
	mRandomIdle->SetAt(0, 0);
}

/// 061016 PKH 
/* ------------------------------------------------------------------
* Լ̸ :	GetObjectCenter()
*      :	ü ߽ǥ Ѵ.
* ǻ :	÷̾ Spine ǥ ߽ǥ Ѵ.
* ------------------------------------------------------------------ */
NiPoint3 cMonsterSceneNode::GetObjectCenter()
{
	NiAVObject* spine = GetPartObject( eLINK_BODY );

	NiPoint3 cen = GetCenter();
	NiPoint3 pos;
	if( spine )	
	{
		pos = spine->GetWorldTranslate();
		pos = NiPoint3( pos.x, pos.y, cen.z );
		return pos;
	}
	else
	{
		return NiPoint3::ZERO;
	}
}

/// 061013 PKH 
unsigned int cMonsterSceneNode::LinkObject( unsigned int dummyIdx, const char* fileName )
{
	NiNode* pNode = RESOURCEMAN->GetObjectByName( fileName );
	if( !pNode ) 
	{
		assert(0);
		return UINT_MAX;
	}
/*
	NiTimeController* pCtrl = GetTimeController( (NiAVObject*)pNode );
	if( pCtrl )
	{
		pCtrl->SetAnimType( NiTimeController::APP_INIT );
		pCtrl->SetCycleType( NiTimeController::LOOP );
		pCtrl->Start();
	}
*/
	return cDynamicSceneNode::LinkObject( dummyIdx, pNode );
}

///
//cObjectNameCard* cMonsterSceneNode::CreateNameCard( cBaseObject* pObj )
//{
//	if( !pObj )
//	{
//		assert(0);
//		return 0;
//	}
//	return new cMonsterNameCard( pObj );
//}

///
//void cMonsterSceneNode::AddDepthPlaneObject() const
//{
//	cDynamicSceneNode::AddDepthPlaneObject();
//
//	/// ̸ ǥ ɼ üũ
//
//	/// vŰ  toggle type1 or type2
//	if( mpNameCard )
//		mpNameCard->SetCardType( eNameCard_Type_Default );
//}


void cMonsterSceneNode::ProcessTrail( float delta )
{
//	unsigned long scaleDelta = (unsigned long)(delta * mScaleFactor);

	///
	NiTListIterator pos = mRibbonList.GetHeadPos();
	while( pos )
	{
		sTrailInfo* p = mRibbonList.GetNext(pos);
		cRibbonGeometry* geom = p->mRibbonGeom;
		if( p->mLoop == false )
		{
			if( p->mLifeTime <= delta )
			{
				p->mLifeTime = 0;
				geom->SetPushEnabled( false );

				if( geom->GetNumVerts() == 0 )
				{
					/// delete
					mDeleteRibbonList.AddTail(p);
					continue;
				}
			}
			else
				p->mLifeTime -= delta;
		}

		if( geom )
		{
			/// push point
			NiAVObject* obj1 = GetPartObject( p->mStartLink );
			NiAVObject* obj2 = GetPartObject( p->mEndLink );
			if( obj1 && obj2 )
			{
				const NiPoint3& pos1 = obj1->GetWorldTranslate();
				const NiPoint3& pos2 = obj2->GetWorldTranslate();

				geom->SetPushPoint( pos1, pos2 );
			}

			geom->Process( delta );
		}
	}
}
