/* ==========================================================================
*    : ̼
*    : 2006.12.17
*      : 콺 ߰
* ǻ : 
*===========================================================================*/
#pragma once

/// 콺 ߰
class cMouseAgent
{
	static cMouseAgent* mSingleton;

public:
	cMouseAgent();
	~cMouseAgent();

	/// ó
	void Process();

	/// 콺 ޽ ó Լ
	///  ޽ ó Լ  ڵ ȣȴ.
	void SetLButtonDown( int x, int y );
	void SetLButtonUp( int x, int y );
	void SetRButtonDown( int x, int y );
	void SetRButtonUp( int x, int y );
	void SetMButtonDown( int x, int y );
	void SetMButtonUp( int x, int y );
	void SetPosition( int x, int y );
	void SetDeltaWheel( float dw );

	/// 콺 ǥ ȯ
	int GetX() const;
	int GetY() const;
	int GetDeltaX() const;
	int GetDeltaY() const;

	///  콺 ư ȴ θ ȯ
	bool IsLButtonDown() const;
	bool IsLButtonUp() const;

	///  콺 ư ȴ θ ȯ
	bool IsRButtonDown() const;
	bool IsRButtonUp() const;

	///  콺 ư ȴ θ ȯ
	bool IsMButtonDown() const;
	bool IsMButtonUp() const;

	/// 콺 ٰ
	float GetWheel() const;
	float GetDeltaWheel() const;

public:
	/// ü 
	static cMouseAgent* GetSingleton();

protected:
	/// 콺 
	bool mLeft;
	bool mRight;
	bool mMiddle;

	/// 콺 ġ
	int mX;
	int mY;
	int mOldX;
	int mOldY;
	int mDeltaX;
	int mDeltaY;

	/// 콺   [-1.0, 1.0]
	float mWheel;
	float mOldWheel;
	float mDeltaWheel;
};

inline int cMouseAgent::GetX() const
{
	return mX;
}

inline int cMouseAgent::GetY() const
{
	return mY;
}

inline int cMouseAgent::GetDeltaX() const
{
	return mDeltaX;
}

inline int cMouseAgent::GetDeltaY() const
{
	return mDeltaY;
}

inline bool cMouseAgent::IsLButtonDown() const
{
	return mLeft;
}

inline bool cMouseAgent::IsLButtonUp() const
{
	return !mLeft;
}

inline bool cMouseAgent::IsRButtonDown() const
{
	return mRight;
}

inline bool cMouseAgent::IsRButtonUp() const
{
	return !mRight;
}

inline bool cMouseAgent::IsMButtonDown() const
{
	return mMiddle;
}

inline bool cMouseAgent::IsMButtonUp() const
{
	return !mMiddle;
}

inline float cMouseAgent::GetWheel() const
{
	return mWheel;
}

inline float cMouseAgent::GetDeltaWheel() const
{
	return mDeltaWheel;
}

inline cMouseAgent* cMouseAgent::GetSingleton()
{
	return mSingleton;
}

#define MOUSE cMouseAgent::GetSingleton()
