#include "stdafx.h"
#include "RenderSystem.h"

#include "AppWindow.h"
#include "ResourceManager.h"
#include "CameraManager.h"
#include "ShaderHelper.h"
#include "SceneManager.h"
#include "DevSystem.h"

cRenderSystem* cRenderSystem::mSingleton = 0;

cRenderSystem::cRenderSystem( cAppWindow* window )
: mWindow( window )
, mShaderHelper( 0 )
, mShadowShader( 0 )
{
	assert( mSingleton == 0 && "bad singleton!" );
	mSingleton = this;

	mClearColor = NiColor(0.0f,0.0f,0.0f);

	// It can filter flat images into mipmap pyramids, and can convert 
	// from standard Gamebryo pixel formats (PAL8, PALA8, RGB24, RGBA32, etc)
	// to non-standard formats, and from non-standard formats to a few standard formats
	NiImageConverter::SetImageConverter( NiNew NiDevImageConverter );
	NiTexture::SetMipmapByDefault( true );
}

cRenderSystem::~cRenderSystem()
{
	/// ̹ ȯڸ 
	NiImageConverter::SetImageConverter( NiNew NiDevImageConverter );

	/// ̴ ̸ 
	delete mShaderHelper;

	mSingleton = 0;
}

bool cRenderSystem::Init()
{
	///  
	if( CreateRenderer() == false )
	{
		assert( 0 && "failed to create renderer" );
		return false;
	}
	if( mRenderer->Init() == false )
	{
		assert( 0 );
		return false;
	}

	/// ̴    ̺귯 
	mShaderHelper = new cShaderHelper;
	if( mShaderHelper == 0 )
		return false;
#ifdef MAP_EDITOR
	if( mShaderHelper->SetupShaderSystem( "./MapData" ) == false )
		return false;
#else
	if( mShaderHelper->SetupShaderSystem( "./Script/Resource" ) == false )
		return false;
#endif

	/// ̴ 
	mShadowShader = NiShaderFactory::GetInstance()->RetrieveShader( "ShadowShader", 0 );

	if( mShadowShader == 0 )
	{
		assert( 0 && "failed to retrieve shadow shader" );
		return false;
	}
	return true;
}

void cRenderSystem::Render()
{
	assert( 0 && "do not use this func in map editor" );
}

void cRenderSystem::BeginFrame()
{
	mRenderer->BeginFrame();
	{
		mRenderer->SetBackgroundColor( mClearColor );

		mRenderer->BeginUsingDefaultRenderTargetGroup( NiRenderer::CLEAR_ALL );
		{
			/// ī޶ 
			mRenderer->SetCameraData( (NiCamera*)(*CAMERAMAN->GetCurrent()) );
		}
	}
}

void cRenderSystem::EndFrame()
{
	{
		mRenderer->EndUsingRenderTargetGroup();
	}
	mRenderer->EndFrame();
}

void cRenderSystem::DisplayFrame()
{
	mRenderer->DisplayFrame();
}

void cRenderSystem::Reset()
{
	mRenderer->OnLostDevice();

	/// ø̼  ڵ 
	NiWindowRef handle = mWindow->GetHandle();
	mWindow->ToggleWindow( IsFullScreen() );

	///   
	NiDX9Renderer::RecreateStatus ret = NiDX9Renderer::GetRenderer()->Recreate(
		mRenderOption.mWidth,
		mRenderOption.mHeight,
		mRenderOption.mFlags,
		handle,
		mRenderOption.mFrameBufferFormat, 
		mRenderOption.mDepthStencilFormat, 
		mRenderOption.mPresentationInterval, 
		mRenderOption.mSwapEffect, 
		mRenderOption.mFrameBufferMode, 
		mRenderOption.mBackBufferCount, 
		mRenderOption.mRefreshRate );

	if( ret == NiDX9Renderer::RECREATESTATUS_FAILED || ret == NiDX9Renderer::RECREATESTATUS_RESTORED )
	{
		OutputDebugString(_T("Error: failed to recreate renderer"));

		mRenderOption.mFlags = NiDX9Renderer::USE_STENCIL | NiDX9Renderer::USE_MULTITHREADED;
		if( IsFullScreen() )
			mRenderOption.mFlags |= NiDX9Renderer::USE_FULLSCREEN;

		ret = NiDX9Renderer::GetRenderer()->Recreate(
			mRenderOption.mWidth,
			mRenderOption.mHeight,
			mRenderOption.mFlags,
			handle, 
			mRenderOption.mFrameBufferFormat, 
			mRenderOption.mDepthStencilFormat, 
			mRenderOption.mPresentationInterval, 
			mRenderOption.mSwapEffect, 
			mRenderOption.mFrameBufferMode, 
			mRenderOption.mBackBufferCount, 
			mRenderOption.mRefreshRate );

		if( ret == NiDX9Renderer::RECREATESTATUS_FAILED || ret == NiDX9Renderer::RECREATESTATUS_RESTORED )
		{
			NiMessageBox( "Failed to Recreate DX9 Renderer.", "Error!" );
			::SendMessage( mWindow->GetHandle(), WM_CLOSE, 0, 0 );
		}
	}

	mRenderer->OnResetDevice();
}

bool cRenderSystem::CreateRenderer()
{
	const NiDX9SystemDesc* systemDesc = NiDX9Renderer::GetSystemDesc();
	unsigned int numAdapters = systemDesc->GetAdapterCount();

	for( unsigned int i = 0; i < numAdapters; ++i )
	{
		const NiDX9AdapterDesc* adapterDesc = systemDesc->GetAdapter( i );
		const char* adapterName = adapterDesc->GetStringDescription();

		if( adapterName && ::strstr( adapterName, "NVPerfHUD" ) )
		{
			mRenderOption.mAdapter = i;
			mRenderOption.mDeviceDesc = NiDX9Renderer::DEVDESC_REF_HWVERTEX;
		}
	}

	//   
	NiWindowRef handle = mWindow->GetHandle();

	mRenderer = cRenderer::Create(
		mRenderOption.mWidth,
		mRenderOption.mHeight,
		(NiDX9Renderer::FlagType)mRenderOption.mFlags,
		handle,
		handle,
		mRenderOption.mAdapter,
		mRenderOption.mDeviceDesc, 
		mRenderOption.mFrameBufferFormat, 
		mRenderOption.mDepthStencilFormat,
		mRenderOption.mPresentationInterval,
		mRenderOption.mSwapEffect,
		mRenderOption.mFrameBufferMode,
		mRenderOption.mBackBufferCount,
		mRenderOption.mRefreshRate
		);

	if( mRenderer == 0 )
	{
		NiMessageBox( "Failed to Create DX9 Renderer.", "Error!" );
		return false;
	}

	///  
	mRenderer->SetBackgroundColor( mClearColor );

	///  ó
	mWindow->ToggleWindow( IsFullScreen() );
	return true;
}

void cRenderSystem::ToggleScreenMode()
{
	if( IsFullScreen() )
		mRenderOption.mFlags &= ~(NiDX9Renderer::USE_FULLSCREEN);
	else
		mRenderOption.mFlags |= NiDX9Renderer::USE_FULLSCREEN;
}
