/* ==========================================================================
*    : ̼
*    : 2006.12.17
*      :  ý
* ǻ : 
*===========================================================================*/
#pragma once

#include "Renderer.h"

class cAppWindow;
class cShaderHelper;

///  ɼ
class cRenderOption
{
public:
	cRenderOption();

public:
	/// ũ
	unsigned int mWidth;
	unsigned int mHeight;

	/// ÷װ
	unsigned int mFlags;

	/// 
	unsigned int mAdapter;

	///  
	unsigned int mBackBufferCount;

	/// 
	unsigned int mRefreshRate;

	///  
	NiDX9Renderer::DeviceDesc mDeviceDesc;
	NiDX9Renderer::FrameBufferFormat mFrameBufferFormat;
	NiDX9Renderer::DepthStencilFormat mDepthStencilFormat;
	NiDX9Renderer::PresentationInterval mPresentationInterval;
	NiDX9Renderer::SwapEffect mSwapEffect;
	NiDX9Renderer::FramebufferMode mFrameBufferMode;
};

inline
cRenderOption::cRenderOption()
{
	mWidth = 800;
	mHeight = 600;
	mFlags = NiDX9Renderer::USE_STENCIL;// | NiDX9Renderer::USE_MULTITHREADED;
	mAdapter = D3DADAPTER_DEFAULT;
	mBackBufferCount = 1;
	mRefreshRate = NiDX9Renderer::REFRESHRATE_DEFAULT;
	mDeviceDesc = NiDX9Renderer::DEVDESC_PURE;
	mFrameBufferFormat = NiDX9Renderer::FBFMT_X8R8G8B8;//FBFMT_UNKNOWN;
	mDepthStencilFormat = NiDX9Renderer::DSFMT_D24S8;//DSFMT_UNKNOWN;
	mPresentationInterval = NiDX9Renderer::PRESENT_INTERVAL_IMMEDIATE;
	mSwapEffect = NiDX9Renderer::SWAPEFFECT_DISCARD;
	mFrameBufferMode = NiDX9Renderer::FBMODE_DEFAULT;//NiDX9Renderer::FBMODE_MULTISAMPLES_2;
}

///  ý
class cRenderSystem
{
	static cRenderSystem* mSingleton;

public:
	cRenderSystem( cAppWindow* window );
	~cRenderSystem();

	/// ʱȭ
	bool Init();

	/// 
	void Render();
	void BeginFrame();
	void EndFrame();
	void DisplayFrame();

	/// 缳
	void Reset();

	/// ȭ ũ
	void SetScreenSize( unsigned int width, unsigned int height );
	unsigned int GetScreenWidth() const;
	unsigned int GetScreenHeight() const;

	inline void	SetClearColor( NiColor color ) { mClearColor = color; }

	/// ȭ  
	void ToggleScreenMode();

	/// ü ȭ 
	bool IsFullScreen() const;

	///  ɼ
	const cRenderOption* GetOption() const;

	/// 
	cRenderer* GetRenderer();

	/// ׸ ̴
	NiShader* GetShadowShader();

private:
	///  
	bool CreateRenderer();

public:
	/// ü 
	static cRenderSystem* GetSingleton();

private:
	///  ɼ
	cRenderOption mRenderOption;

	/// 
	cRendererPtr mRenderer;

	/// ø̼ 
	cAppWindow* mWindow;

	/// ̴
	cShaderHelper* mShaderHelper;
	NiShaderPtr mShadowShader;

	NiColor		mClearColor;
};

inline
void cRenderSystem::SetScreenSize( unsigned int w, unsigned int h )
{
	mRenderOption.mWidth = w;
	mRenderOption.mHeight = h;
}

inline
unsigned int cRenderSystem::GetScreenWidth() const
{
	return mRenderOption.mWidth;
}

inline
unsigned int cRenderSystem::GetScreenHeight() const
{
	return mRenderOption.mHeight;
}

inline
bool cRenderSystem::IsFullScreen() const
{
	return (mRenderOption.mFlags & NiDX9Renderer::USE_FULLSCREEN) ? true : false;
}

inline
const cRenderOption* cRenderSystem::GetOption() const
{
	return &mRenderOption;
}

inline
cRenderer* cRenderSystem::GetRenderer()
{
	return mRenderer;
}

inline
NiShader* cRenderSystem::GetShadowShader()
{
	return mShadowShader;
}

inline
cRenderSystem* cRenderSystem::GetSingleton()
{
	return mSingleton;
}

#define RENDERSYS cRenderSystem::GetSingleton()
