/* ====================================================================
*      :	 ׷ ҽ  ε ̽    ޸ 
*    :	̹
*    :	2006.01
* ǻ :	 ̽  뵵̹Ƿ   Ѵ.
*				̰ εǴ ü ؽĴ  ϴ.
* =================================================================== */
#pragma once

#include "TexturePalette.h"
#include "ModelInstance.h"

class cCallbackStreamPACK;

/// ҽ 
class cResourceManager
{
	static cResourceManager* mpSingleton;

public:
	cResourceManager();
	~cResourceManager();

	enum
	{
		eCHARACTEREFFECT = 0,
		eOBJECTEFFECT,

		/// Ͽ   ״ Ѵ.
		eFILEEFFECT,
	};

	/// ʱȭ
	bool Init();

	void Close();

	void Clear();

	/// 
	void Exit();

	/// ⺻ ü ε Լ
	bool LoadNIF( const cString& pathName, NiAVObject** nifRoot = 0);
	bool LoadMapNIF( const cString& pathName );

	/// 带 ̿ ü ε(  Ѵ)
	void LoadThreadNIF( const char* fileName );

	/// ε  
	void FinishThread();

	/// ؽó
	NiTexture* LoadTexture( const cString& pathName, bool useMipMap = true );
	LPDIRECT3DTEXTURE9 LoadD3DTexture( const cString& pathName, bool useMipMap = true, DWORD filter = D3DX_FILTER_LINEAR, DWORD mipFilter = D3DX_FILTER_LINEAR );
	LPDIRECT3DTEXTURE9 GetD3DTexture( const cString& pathName );

	/// 
	NiAudioSource* LoadSound( const cString& fileName );

	///  ó
	void Process();

	/// ε nif ü  ߰Ѵ.
	//terrain_temp
	unsigned int AddObject( NiNode* n, const cString& pathName );

	/// ü ſ ̽
	void RemoveObject( const char* objectName );
	void RemoveObject( NiNode* n );
	void RemoveAllObjects();

	void RemoveAllMapTexture();

	/// ü  ̽
	//	inline unsigned int	GetObjectCount() const { return mObjectArray.GetSize(); }
	//	NiAVObject*			GetObjectAt( unsigned int objcetIdx );
	//	NiAVObject*			GetObjectByName( const char* objectName );

	inline unsigned int	GetObjectCount() const { return mNodeArray.GetSize(); }
	NiNode*				GetObjectAt( unsigned int objcetIdx );
	NiNode*				GetObjectByName( const cString& pathName );
	NiAudioSource*		GetSoundByName( const cString& fileName );

	/// ü  ̽
	NiNode*				CloneObjectAt( unsigned int objectIdx );
	NiNode*				CloneObjectByName( const cString& pathName );
	NiAudioSource*		CloneSoundByName( const cString& fileName );

	/// kfm  
	bool LoadKFM( const cString& pathName );
	unsigned int AddModel( cModelInstance* model, const cString& pathName );
	void RemoveAllModels();
	inline unsigned int GetModelCount() const { return mModelArray.GetSize(); }
	cModelInstance* GetModelAt( unsigned int modelIdx );
	cModelInstance* GetModelByName( const cString& modelName );

	/// ׸ ؽó
	NiTexture* GetShadowTexture() const;

public:
	/// ü 
	static cResourceManager* GetSingleton();

protected:
	///  ε Ŭ
	cCallbackStreamPACK* mpStreamPAK;

	/// ũƼ 
	static NiCriticalSection mObjectListCriticalSection;
	static NiCriticalSection mTexturePaletteCriticalSection;
	static NiCriticalSection mSoundListCriticalSection;

	/// ؽó ȷƮ
	cTexturePalettePtr mTexturePalette;
	cTexturePalettePtr mMapTexturePalette;

	/// 3D Ʈ
	NiTObjectArray<NiNodePtr> mNodeArray;
	NiTStringPointerMap<unsigned int> mObjectIndexMap;

	///  Ʈ
	tArray<unsigned int> mMapIndexArray;

	/// 
	NiTObjectArray<cModelInstancePtr> mModelArray;
	NiTStringPointerMap<unsigned int> mModelIndexMap;

	/// 
	typedef tPointerHashMap<cString, NiAudioSource*> cSoundMap;
	cSoundMap mSoundMap;

	/// ؽó
	typedef tHashMap<cString, void*> cD3DTextureMap;
	cD3DTextureMap mD3DTextureMap;

	/// ׸ ؽó
	NiTexture* mShadowTexture;
};

inline
NiTexture* cResourceManager::GetShadowTexture() const
{
	return mShadowTexture;
}

inline
cResourceManager* cResourceManager::GetSingleton()
{
	return mpSingleton;
}

#define RESOURCEMAN	cResourceManager::GetSingleton()
