/* ==========================================================================
*    : ̼
*    : 2006.12.15
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneTree.h"
#include "VisibleArray.h"
#include "VisibleArraySorter.h"
#include "CullingProcess.h"

class cRay;
class cCamera;
class cDynamicSceneNode;
class cNpcSceneNode;
class cNpcSceneNodeParam;
class cMonsterSceneNode;
class cMonsterSceneNodeParam;
class cPlayerSceneNode;
class cPlayerSceneNodeParam;
class cEffectSceneNode;
class cEffectSceneNodeParam;
class cSoundSceneNode;
class cSoundSceneNodeParam;
class cStaticSceneNode;

///   
#pragma pack( push, 1 )
class cSceneFileHeader
{
public:
	/// ĺ ڵ
	char mCode[10];

	/// 
	unsigned int mVersion;

	///  Ʈ 
	NiPoint3 mCenter;
	float mMinRadius;
	float mMaxRadius;

	///   
	unsigned int mNumSceneNodes;
};
#pragma pack( pop )

///  ÷
class cSceneCuller : public NiCullingProcess
{
public:
	cSceneCuller( const cCamera* cam, const NiPoint3& heroPos );

public:
	const cCamera* mCamera;
	NiPoint3 mHeroPos;
};

///  
///  带 , ϴ ̴.
///  ϰ,
/// 浹 ˻, ü ˻,   ۾ Ѵ.
class cSceneManager
{
	static cSceneManager* mSingleton;
public:
	cSceneManager();
	~cSceneManager();

	/// 
	void Clear();

	/// ʱȭ
	bool Init( const NiPoint3& center, float minRadius, float maxRadius );
	bool InitTree( const NiPoint3& center, float minRadius, float maxRadius );
	bool IsInited() const;

	/// ó
	void Process( float deltaTime, float accumTime );

	/// 
	void Render();

	/// ȭ  ǥ ϴ   
	/// ﰢ  ˻Ѵ.
	bool PickDynamics( tArray<void*>* pickedArray, int mouseX, int mouseY, bool sortByDistance = false );

	/// 浹ϴ   
	bool PickDynamics( tArray<void*>* pickedArray, const cRay& ray, float maxDistance, bool sortByDistance = false );
	bool PickDynamics( tArray<void*>* pickedArray, const cSphere& sphere );
	bool PickSounds( tArray<void*>* pickedArray, const cSphere& sphere );

	/// 带 
	void DestroyAll();
	bool DestroyDynamic( cSceneNode* node );
	bool DestroyDynamic( unsigned int index );
	bool DestroyEffectNode( cSceneNode* node, bool DelListRemove = false );
	bool DestroySoundNode( cSceneNode* node, bool DelListRemove = false );

	///  Ǿ  Ʈ 忡  ó
	void AddDeleteEffectNode( cEffectSceneNode* node );
	void AddDeleteSoundNode( cSoundSceneNode* node );

	/// 带 
	cSoundSceneNode* CreateEffectSound( const cSoundSceneNodeParam& param );

	void ActiveSoundNodeAll( bool active );

	cNpcSceneNode* CreateNPC( unsigned long modelIndex );
	cMonsterSceneNode* CreateMonster( unsigned long modelIndex );
	cPlayerSceneNode* CreatePlayer( unsigned long modelIndex );

	cEffectSceneNode* CreateEffect( const cEffectSceneNodeParam& param );
	cEffectSceneNode* CreateSelfEffect( cString pathName, NiTransform& trans, bool bLoop );

	void AddAmbientLight( NiColor ambientColor, NiColor diffuseColor, float dimmer );
	void AddDirLight( NiColor ambientColor, NiColor diffuseColor, float dimmer, NiMatrix3 rot );

	NiAmbientLight* GetAmbientLight() const;
	NiDirectionalLight* GetDirLight() const;

	inline unsigned int GetLightCount() { return mAmbientLightArray.GetSize(); }
	inline unsigned int GetCurrentLightIndex() { return mCurrentLightIndex; }

	void ChangeLight( unsigned int index );

	/*
	/// ֺ
	void SetAmbientLightAmbient( unsigned int i, const NiColor& color );
	void SetAmbientLightDiffuse( unsigned int i, const NiColor& color );
	void SetAmbientLightDimmer( unsigned int i, float dimmer );

	/// Ɽ
	void SetDirLightAmbient( unsigned int i, const NiColor& color );
	void SetDirLightDiffuse( unsigned int i, const NiColor& color );
	void SetDirLightDimmer( unsigned int i, float dimmer );
	void SetDirLightRotate( unsigned int i, float xangle, float yangle, float zangle );
	*/



	///  Ʈ 
	const NiPoint3& GetCenter() const;
	float GetMinRadius() const;
	float GetMaxRadius() const;

	/// ̴   
	unsigned int GetNumVisibleAlphaNodes() const;
	unsigned int GetNumVisibleSolidNodes() const;

	cDynamicSceneNode* GetCurrentSceneNode() { return mpCurrentSceneNode; }

	inline void SetDramaProcess( bool isDrama ) { mDramaProcess = isDrama; }

	inline NiNode* GetSceneDummy() { return mpDummy; }

protected:
	/// 带 ߰
	unsigned int AddDynamic( cDynamicSceneNode* node );
	unsigned int AddStatic( cSceneNode* node );
	unsigned int AddEffectNode( cSceneNode* node );
	unsigned int AddSound( cSoundSceneNode* node );

	void LoadMapLightSetting( const char* fullPath );
	void ScanDir( LPCTSTR pathname, bool filescan = false );

	bool LoadEnv6( cFileLoader& loader );
	bool LoadEnv7( cFileLoader& loader );
	bool LoadEnv8( cFileLoader& loader );
	bool LoadEnv9( cFileLoader& loader );
	bool LoadEnv10( cFileLoader& loader );
	bool LoadGlobalArea6( cFileLoader& loader );
	bool LoadGlobalArea7( cFileLoader& loader );
	bool LoadGlobalArea8( cFileLoader& loader );
	bool LoadGlobalArea9( cFileLoader& loader );
	bool LoadGlobalArea10( cFileLoader& loader );

	void InterpretPlayer( float accumtime );
	void InterpretMonster( float accumtime );
	void InterpretNpc( float accumtime );

	void CreateDummy( NiPoint3 pos );

public:
	/// ü 
	static cSceneManager* GetSingleton();

protected:
	/// ʱȭ 
	bool mInited;

	/// ؽó 
	typedef tHashMap<unsigned int, NiTexture*> cTextureMap;
	cTextureMap mTextureMap;

	/// Ʈ
	///  Ͽ   Ѵ.
	/// 浹 ˻  ø ȿ ϱ Ѵ.
	NiPoint3 mCenter;
	float mMinRadius;
	float mMaxRadius;

	/// ø
	cCullingProcess mCuller;

	typedef tArray<void*> cNodeArray;

	////  ü ü..
	cDynamicSceneNode*			mpCurrentSceneNode;

	unsigned int mDummyIdx;
	NiNode* mpDummy;

	cSceneTree mSoundTree;
	cNodeArray mSoundArray;


	cSceneTree mDynamicTree;
	cNodeArray mDynamicArray;

	cSceneTree mStaticObjectTree;
	cNodeArray mStaticObjectArray;

	/// Ʈ (Ʈ  ʿ )
	cNodeArray mEffectNodeArray;

	/// Ʈ 
	//	typedef tPointerList<cSceneNode*> cDelEffectList;
	typedef tPointerList<void*> cDelEffectList;
	cDelEffectList mDelEffectList;

	typedef tPointerList<void*> cDelSoundList;
	cDelSoundList mDelSoundList;


	///    迭
	cVisibleArray mAlphaArray;

	///    迭
	cVisibleArray mSolidArray;
	cVisibleArray mSkinedArray;

	///    迭 
	cAlphaArraySorter mAlphaArraySorter;

	///    迭 
	cSolidArraySorter mSolidArraySorter;
	cSolidArraySorter mSkinedArraySorter;

	unsigned int mCurrentLightIndex;

	bool mDramaProcess;

	/// light
	NiTObjectArray<NiAmbientLightPtr>		mAmbientLightArray;
	NiTObjectArray<NiDirectionalLightPtr>	mDirLightArray;

	/// 
//	NiAmbientLightPtr mAmbientLight[2];
//	NiDirectionalLightPtr mDirLight[2];

	/// ŷ   迭
	typedef tArray<void*> cPickedArray;
	cPickedArray mPickedArray;
};

inline
bool cSceneManager::IsInited() const
{
	return mInited;
}

/*
inline
NiFogProperty* cSceneManager::GetFogProperty() const
{
	return mFogProp;
}
*/

inline
NiAmbientLight* cSceneManager::GetAmbientLight() const
{
	return mAmbientLightArray.GetAt( 0 );//mCurrentLightIndex );
}

inline
NiDirectionalLight* cSceneManager::GetDirLight() const
{
	return mDirLightArray.GetAt( 0 );//mCurrentLightIndex);
}

inline
const NiPoint3& cSceneManager::GetCenter() const
{
	return mCenter;
}

inline
float cSceneManager::GetMinRadius() const
{
	return mMinRadius;
}

inline
float cSceneManager::GetMaxRadius() const
{
	return mMaxRadius;
}

inline
unsigned int cSceneManager::GetNumVisibleAlphaNodes() const
{
	return mAlphaArray.GetCount();
}

inline
unsigned int cSceneManager::GetNumVisibleSolidNodes() const
{
	return mSolidArray.GetCount();
}

inline
cSceneManager* cSceneManager::GetSingleton()
{
	return mSingleton;
}

#define SCENEMAN cSceneManager::GetSingleton()
