/* ==========================================================================
*    : ̼
*    : 2006.12.08
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "Sphere.h"

class cSceneCuller;
class cLightSceneNode;

///  Ÿ
class cAlphaData
{
public:
	cAlphaData( bool blendEnabled, bool testEnabled, NiAlphaProperty::TestFunction testFunc, unsigned char testRef, NiAlphaProperty* prop );

public:
	///  
	bool mBlendEnabled;

	///  ׽
	bool mTestEnabled;
	NiAlphaProperty::TestFunction mTestFunc;
	unsigned char mTestRef;

	///  Ӽ
	NiAlphaProperty* mProp;
};

inline
cAlphaData::cAlphaData( bool blendEnabled, bool testEnabled, NiAlphaProperty::TestFunction testFunc, unsigned char testRef, NiAlphaProperty* prop )
: mBlendEnabled( blendEnabled )
, mTestEnabled( testEnabled )
, mTestFunc( testFunc )
, mTestRef( testRef )
, mProp( prop )
{
	assert( prop );
}

///   
class cSceneNodeParam
{
public:
	cSceneNodeParam();

public:
	///  ̸
	mutable cString mPathName;

	/// ġ
	mutable NiPoint3 mTranslate;

	/// ȸ
	mutable NiMatrix3 mRotate;

	/// 
	mutable float mScale;

	/// ŷ
	mutable NiPick::PickType mPickType;
	mutable NiPick::SortType mPickSort;
	mutable NiPick::IntersectType mPickIntersect;
	mutable NiPick::CoordinateType mPickCoordinate;
	mutable bool mPickFrontOnly;
	mutable bool mPickReturnTexture;
	mutable bool mPickReturnNormal;
	mutable bool mPickReturnColor;
};

inline
cSceneNodeParam::cSceneNodeParam()
: mTranslate( NiPoint3::ZERO )
, mRotate( NiMatrix3::IDENTITY )
, mScale( 1.0f )
, mPickType( NiPick::FIND_ALL )
, mPickSort( NiPick::SORT )
, mPickIntersect( NiPick::TRIANGLE_INTERSECT )
, mPickCoordinate( NiPick::WORLD_COORDINATES )
, mPickFrontOnly( false )
, mPickReturnTexture( false )
, mPickReturnNormal( false )
, mPickReturnColor( false )
{
}

///  
class cSceneNode
{
	friend class cSceneManager;
	friend class cSceneTree;
	friend class cSceneTreeNode;

public:
	///   Ÿ
	enum eType
	{
		eNULL		= 0,
		eRENDERING	= (1 <<  0),

		eAREA		= (1 <<  1),
		eLIGHT		= (1 <<  2),
		eSOUND		= (1 <<  3),
		eSTATIC		= (1 <<  4) | eRENDERING,
		eDYNAMIC	= (1 <<  5) | eRENDERING,
		eEFFECT		= (1 <<  6) | eRENDERING,

		eDROPITEM	= (1 <<  7) | eSTATIC,
		eMAPPORTAL	= (1 <<  8) | eSTATIC,

		ePLAYER		= (1 <<  9) | eDYNAMIC,
		eNPC		= (1 << 10) | eDYNAMIC,
		eMONSTER	= (1 << 11) | eDYNAMIC,

		eHERO		= (1 << 12) | ePLAYER,
	};

	enum eTypeVer8
	{
		eNULL_VER8	= 0,
		eAREA_VER8,
		eLIGHT_VER8,
		eSOUND_VER8,
		eSTATIC_VER8,
		eDYNAMIC_VER8,
	};

public:
	/// ó
	virtual void OnProcess( float deltaTime, float accumTime );
	virtual void OnProcessAlpha( float deltaTime );
	virtual bool OnVisible( cSceneCuller& culler );

	/// 
	void Update();

	/// ŷ
	virtual bool Pick( const NiPoint3& origin, const NiPoint3& dir );

	/// ŷ 
	/// : Pick() ȣ Ŀ ؾ Ѵ.
	const NiPick::Results& GetPickResults() const;
	const NiPoint3& GetPickPos() const;
	float GetPickDistance() const;

	///  
	void SetAlphaBlended( bool blended, float targetAlpha );
	bool IsAlphaBlended() const;

	/// Ÿ
	eType GetType() const;
	bool IsKindof( eType type ) const;

	///  Ʈ
	NiAVObject* GetNiObject() const;

	/// ̵
	void Translate( const NiPoint3& move );
	void SetTranslate( const NiPoint3& trans );
	const NiPoint3& GetTranslate() const;

	void SetWorldTranslate( const NiPoint3& trans );
	virtual const NiPoint3& GetWorldTranslate() const;

	/// ȸ
	void SetRotate( const NiPoint3& axis, float angle );
	void SetRotate( float xangle, float yangle, float zangle );
	void SetRotate( const NiMatrix3& rot );
	const NiMatrix3& GetRotate() const;
	const NiMatrix3& GetWorldRotate() const;

	/// ũ
	virtual void SetScale( float scale );
	float GetScale() const;
	float GetWorldScale() const;

	///  
	const cSphere& GetBoundSphere() const;

	/// ߽
	virtual const NiPoint3& GetCenter() const;

	/// 
	virtual float GetRadius() const;

	///  
	virtual unsigned int WhichSide( const NiPlane& plane ) const;

	/// ̸
	const char* GetName() const;

	static NiGeometry* GetGeom( NiAVObject* obj );
	static void SetAppCulled( NiAVObject* obj, bool cull );

	void SetSelectLightFlag( bool attach );

	virtual void Play( unsigned long ) {}
	virtual void Rew( unsigned long ) {}
	virtual void Stop() {}

	virtual void SetViewNode( bool view );
	inline bool IsViewNode() { return mViewNode; }

protected:
	cSceneNode( eType = eNULL );
	virtual ~cSceneNode();

	/// ʱȭ
	virtual bool Init( const cSceneNodeParam& param );

	///  Ʈ
	virtual void RecollectGeoms();
	virtual void CollectGeoms( NiAVObject* obj );
	void CollectBillboards( NiAVObject* obj );

	///  Ӽ
	void CollectProperties( NiAVObject* obj );

	///  Ʈ  迭 ߰
	virtual void AddToVisibleArray( NiVisibleArray* solidArray, NiVisibleArray* skinedArray, NiVisibleArray* alphaArray );

private:
	/// ĸ 
	virtual void UpdateAlpha();

protected:
	/// Ÿ
	eType mType;

	///  Ʈ
	NiAVObjectPtr mNiObject;

	///  Ӽ Ʈ
	typedef tList<void*> cMatPropList;
	cMatPropList mMatPropList;

	///  Ÿ Ʈ
	typedef tList<void*> cAlphaDataList;
	cAlphaDataList mAlphaDataList;

	///  Ʈ Ʈ
	typedef tPair<NiTriBasedGeom*, bool> cGeomPair;
	typedef tList<cGeomPair> cGeomList;
	cGeomList mGeomList;

	///   Ʈ
	typedef tList<void*> cBillboardList;
	cBillboardList mBillboardList;

	/// ŷ
	///  Ʈ ̿ 浹 ˻  ŷ ϰ,   Ѵ.
	NiPick mPick;
	NiPoint3 mPickPos;
	float mPickDistance;

	/// 
	bool mViewNode;

	///  ʿ 
	bool mNeedUpdate;

	///   ð
	float mAccumTime;

	///  
	cSphere mBoundSphere;

	/// 
	bool mAlphaForced;
	bool mAlphaBlended;
	float mTargetAlpha;
	float mAlpha;
	float mAlphaSpeed;

	/// over & select node attach selectLight
	bool mAttachSelectLight;
	bool mUpdateSelectLIght;

	///  迭
	typedef tArray<void*> cLightArray;
	cLightArray mLightArray;

	///  ڿ    ε
	unsigned int mIndexByManager;

	/// ̳
	///  带 ϴ  Ʈ 
	cSceneTreeNode* mContainer;

	/// ̳ʿ    ݺ
	bool mIteratorValid;
	tPointerList<void*>::cIterator mIteratorByContainer;
};

inline
void cSceneNode::Update()
{
	mNiObject->Update(0.0f);
	mNeedUpdate = true;
}

inline
const NiPick::Results& cSceneNode::GetPickResults() const
{
	return mPick.GetResults();
}

inline
const NiPoint3& cSceneNode::GetPickPos() const
{
	return mPickPos;
}

inline
float cSceneNode::GetPickDistance() const
{
	return mPickDistance;
}

inline
void cSceneNode::SetAlphaBlended( bool blended, float targetAlpha )
{
	mAlphaBlended = blended;
	mTargetAlpha = targetAlpha;
}

inline
bool cSceneNode::IsAlphaBlended() const
{
	return mAlphaForced ? true : mAlphaBlended;
}

inline
cSceneNode::eType cSceneNode::GetType() const
{
	return mType;
}

inline
bool cSceneNode::IsKindof( eType type ) const
{
	return (mType & type) == type;
}

inline
NiAVObject* cSceneNode::GetNiObject() const
{
	return mNiObject;
}

inline
const NiPoint3& cSceneNode::GetTranslate() const
{
	return mNiObject->GetTranslate();
}

inline
const NiMatrix3& cSceneNode::GetRotate() const
{
	return mNiObject->GetRotate();
}

inline
float cSceneNode::GetScale() const
{
	return mNiObject->GetScale();
}

inline
const NiPoint3& cSceneNode::GetWorldTranslate() const
{
	return mNiObject->GetWorldTranslate();
}

inline
const NiMatrix3& cSceneNode::GetWorldRotate() const
{
	return mNiObject->GetWorldRotate();
}

inline
float cSceneNode::GetWorldScale() const
{
	return mNiObject->GetWorldScale();
}

inline
const cSphere& cSceneNode::GetBoundSphere() const
{
	return mBoundSphere;
}

inline
unsigned int cSceneNode::WhichSide( const NiPlane& plane ) const
{
	float dist = plane.Distance( GetCenter() );
	float radius = GetRadius();

	if( dist <= -radius )
		return NiPlane::NEGATIVE_SIDE;
	else if( dist >= radius )
		return NiPlane::POSITIVE_SIDE;
	else
		return NiPlane::NO_SIDE;
}

inline
const char* cSceneNode::GetName() const
{
	return (const char*)mNiObject->GetName();
}

inline
void cSceneNode::SetSelectLightFlag( bool attach )
{
	if( mAttachSelectLight != attach )
	{
		mAttachSelectLight = attach;
		mUpdateSelectLIght = true;

		mNeedUpdate = true;
	}
}

///    Լ
/// ŷ Ÿ Ѵ.
class cSceneNodeCompareByPickDistance
{
public:
	bool operator () ( const void* left, const void* right ) const
	{
		return ( ((cSceneNode*)left)->GetPickDistance() < ((cSceneNode*)right)->GetPickDistance() );
	};
};
