/* ==========================================================================
*    : ̼
*    : 2006.12.07
*      :  Ʈ
* ǻ : 
*===========================================================================*/
#pragma once

//#include "Sphere.h"
#include "SceneNode.h"

class cSceneTree;
class cSceneCuller;

/// ׽Ʈ 
///  带  ϴ  ˻ϴµ δ.
class cTestSphere : public cSphere
{
public:
	/// ˻ 
	bool mResult;
};

///  Ʈ 
///    ϴ ̴̳.
class cSceneTreeNode : public cSphere
{
	friend class cSceneTree;

public:
	cSceneTreeNode( cSceneTree* tree, cSceneTreeNode* parent, const NiPoint3& center, float radius );
	cSceneTreeNode( cSceneTree* tree, cSceneTreeNode* parent, const cSphere& sphere );
	~cSceneTreeNode();

	void* operator new( size_t n ); 
	void operator delete( void* p );

	///  带 ߰
	void Push( cSceneNode* node );

	///  带 
	void Remove( cSceneNode* node );

	///   ̵ Ǵ ũ ȭ  
	void Update( cSceneNode* node );

	/// ø
	void Cull( NiVisibleArray* solidArray, NiVisibleArray* skinedArray, NiVisibleArray* alphaArray, NiFrustumPlanes& frustum );

	///  浹ϴ   
	/// ﰢ  ˻Ѵ.
	bool CollideRay( tArray<void*>* collidableArray, const cRay& ray, float maxDistance );

	///  浹ϴ   
	///   ˻Ѵ.
	bool CollideSphere( tArray<void*>* collidableArray, const cSphere& sphere );

protected:
	///  迭 ߰
	void AddToVisibleArray( NiVisibleArray* solidArray, NiVisibleArray* skinedArray, NiVisibleArray* alphaArray ) const;

private:
	/// Ʈ
	cSceneTree* mTree;

	/// θ
	cSceneTreeNode* mParent;

	/// ڽ 迭
	cSceneTreeNode* mChild[4];

	/// ׽Ʈ 
	cTestSphere mTestSpheres[4];

	///   Ʈ
	typedef tPointerList<void*> cObjectList;
	cObjectList mObjectList;

	/// ޸ Ǯ
	static tPool<cSceneTreeNode> mPool;

	/// ӽ ÷
	static cSceneCuller* mCuller;
};

///  Ʈ
///      øϰų 浹 ˻縦 ϱ  Ѵ.
class cSceneTree
{
public:
	cSceneTree();
	virtual ~cSceneTree();

	///    
	void Clear();

	/// ʱȭ
	void Init( const NiPoint3& center, float minRadius, float maxRadius );

	///  带 ߰
	void Push( cSceneNode* node );

	/// ø
	void Cull( NiVisibleArray* solidArray, NiVisibleArray* skinedArray, NiVisibleArray* alphaArray, NiFrustumPlanes& frustum, cSceneCuller& culler );

	///  浹ϴ   
	/// ﰢ  ˻Ѵ.
	bool CollideRay( tArray<void*>* collidableArray, const cRay& ray, float maxDistance, bool sortByDistance = false );

	///  浹ϴ   
	///   ˻Ѵ.
	bool CollideSphere( tArray<void*>* collidableArray, const cSphere& sphere );

	///  
	const NiPoint3& GetCenter() const;

	/// ּ  
	float GetMinRadius() const;

	/// ִ  
	float GetMaxRadius() const;

	/// ִ θ 
	bool IsEmpty() const;

protected:
	/// Ʈ 
	cSceneTreeNode* mRootNode;

	/// 
	NiPoint3 mCenter;

	/// ּ 
	float mMinRadius;

	/// ִ 
	float mMaxRadius;
};

inline
const NiPoint3& cSceneTree::GetCenter() const
{
	return mCenter;
}

inline
float cSceneTree::GetMinRadius() const
{
	return mMinRadius;
}

inline
float cSceneTree::GetMaxRadius() const
{
	return mMaxRadius;
}

inline
bool cSceneTree::IsEmpty() const
{
	return mRootNode ? false : true;
}
