/* =====================================================================
*      :	SkillObject.h , SkillObject.cpp
*      :	 ų ü ,  ޾ Ѵ.
*    :	̹
*    :    2007 7 13
*
* ߰ :
*		߰¥    ۾	  ߰
* 
* ǻ :	.
* =======================================================================*/
#pragma once
#include "BaseObject_Common.h"
#include "DramaturgyInfo.h"

struct sTargetDamage;
struct sTargetHeal;

enum eAPPLYDRAMA_TYPE;

class cDynamicSceneNode;
class cEffectSceneNode;
class cSoundSceneNode;
struct sTrailInfo;


class cBaseObject;
class cBulletObj;

struct sApplyDrama
{
	sObject mTargetObj;
	cDramaturgyInfo* mpInfo;
};

///
class cDramaturgyObject 
{
public:
	virtual ~cDramaturgyObject();

	virtual void Process( float time ) = 0;

	/// TODO:
	/// 󿡰 ü ũ ϸ鼭
	///  ϴ ƾ ־ Ѵ.
	/// Thread ɸ鼭 ߰ ó Ѵ.

	/// TODO : 
	///    Լ
	inline eDRAMASTATE GetDramaState() { return mCurrentState; }
	inline void SetDramaState( eDRAMASTATE state ) { mCurrentState = state; }

	inline unsigned long	GetManagedKey() { return mManagedKey; }
	inline unsigned long	GetSkillIdx() { return mSkillIdx; }

	void	Removed() { mRemoved = true; }
	bool	IsRemoved() { return mRemoved; }

protected:
	virtual void UpdateDramaObject( sDramaActionBase* pBase, bool bTarget = false, const NiPoint3& dir = -NiPoint3::UNIT_Y );
	virtual void UpdateTrailObject( sDramaActionBase* pBase );
	virtual void AddLoopEffect( cEffectSceneNode* pNode );
	virtual void AddLoopSound( cSoundSceneNode* pNode );
	virtual void AddLoopTrail( sTrailInfo* pInfo );

	void ChangeDramaState( eDRAMASTATE state );

protected:
	cDramaturgyObject();

	///    ü
	struct sDramaStateController
	{
		sDramaStateController()
			: pAct(0), startTime(FLT_MAX)
		{
			mLoopEffect.Reserve(10);
			mLoopSound.Reserve(10);
			mLoopTrail.Reserve(10);
			animationIdx = UINT_MAX;
		}
		sDramaActionBase*	pAct;
		unsigned int		animationIdx;


		float	startTime;

		tPointerArray<void*>	mLoopEffect;
		tPointerArray<void*>	mLoopSound;
		tPointerArray<void*>	mLoopTrail;
	};

	/// ü ҿ   
	unsigned long			mManagedKey;

	/// ų 
	unsigned long			mSkillIdx;

	///  
	eDRAMASTATE				mCurrentState;
	cDramaturgyInfo*		mpDramaInfo;

	/// 
	cDynamicSceneNode*		mViewNode;

	/// Ÿ 
//	sObject					mTargetObj;

	///   
	sDramaStateController	mApplyController;

	bool			mRemoved;

};

//////////////////////////////////////////////////////////////////////////


///
class cSkillObject : public cDramaturgyObject
{
public:
	cSkillObject();
	virtual ~cSkillObject();

	void*			operator new( size_t n ); 
	void			operator delete( void* ptr );

	enum eVERIFY
	{
		eVerify_Faile = 0,
		eVerify_Wait,
		eVerify_Success,
	};

	virtual bool Init( unsigned long skillIdx, float speedFactor );

	virtual void Process( float time );

	void			SetManagedKey( unsigned long key, bool isDummy ) { mManagedKey = key; mIsDummy = isDummy; }
	bool			IsDummySkill() { return mIsDummy; }

	void			WaitCancel();

	///
//	void			AddDamageTargetInfo( sTargetDamage* dInfo );
//	void			AddHealTargetInfo( sTargetHeal* dInfo );
//	void			AddTargetInfo( sObject* dInfo );

	void			EndCast();

protected:
	/// ĳ ó
	void			ProcessCasting( float time );
	/// ߵ ó
	void			ProcessActivity( float time );
	///  ó
	void			ProcessApply( float time );

	void			ApplyDamage( const sDramaActionBase* pAct );
	void			ApplyHeal( const sDramaActionBase* pAct );

	virtual void	AddLoopEffect( cEffectSceneNode* pNode );
	virtual void	AddLoopSound( cSoundSceneNode* pNode );
	virtual void	AddLoopTrail( sTrailInfo* pInfo );

	void FadeOutAllLoopEffect();
	void FadeOutAllSoundEffect();
	void RemoveAllTrail();

	void			ChangeDramaState( eDRAMASTATE state );

	/// ߻ü
	void AddBulletObject( sDramaActionBase* pBase );

	void BulletProcess( float time );

protected:
	struct sDamageInfo
	{
		unsigned long damageValue;
		unsigned char damageType;
		sObject obj;
	};

	enum
	{
		ePRINT_NONE =0,
		ePRINT_DAMAGE,
		ePRINT_HEAL,
	};

	///  
	bool					mIsDummy;

	eVERIFY					mVerifyState;

	/// ĳ  
	sDramaStateController	mCastingController;
	float					mCastTime;

	/// ߵ  
	sDramaStateController	mActivityController;

	///  
//	sObject					mUserObj;
	unsigned char			mUserWeapon;

	/// damage  Ÿ
	unsigned char			mPrintType;
	tArray<void*>			mTargetObjArray;

	/// ߻ü 
	tPointerList<void*>		mBulletList;
	tArray<void*>			mDelBulletArray;

	/// Apply Drama 
	tPointerList<void*>		mApplyDramaList;

	///  speed 
	float	mSpeedFactor;

	bool	mUsedAnimation;
};

//////////////////////////////////////////////////////////////////////////

///
class cInfluenceObject : public cDramaturgyObject
{
public:
	cInfluenceObject();
	virtual ~cInfluenceObject();

	void*			operator new( size_t n ); 
	void			operator delete( void* ptr );

	virtual bool Init( unsigned long uniqueIdx, unsigned long influenceIdx, bool isbuff );

	/// 뿡  ó 
	virtual void Process( float time );

	///  processϴ Ÿ̹ 
	void StartProcess( float restTime = FLT_MAX, bool onlyLoopEffect = false );

	enum
	{
		eTick_HP,
		eTick_MP,
	};

	void SetTickInfo( unsigned char tickType, long value );

	inline float GetRestTime() { return mRestTime; }

	/// hero ȿ  ó ؼ
	inline bool IsHeroInfluence() { return mIsHeroInfluce; }

protected:
	void ApplyHP( sDramaActionBase* pAct );
	void ApplyMP( sDramaActionBase* pAct );

protected:
	bool			mIsBuff;
	bool			mRemoved;

	bool			mCheckBlink;
	bool			mIsHeroInfluce;
	bool			mOnlyShowLoopEffect;
	unsigned long	mBlinkTime;

	float	mStartTime;
	float	mLifeTime;

	float	mRestTime;

	bool			mStartTimeCheck;

	unsigned char	mInfluenceType;

	/// tickȿ  Ѵ.
	bool			mTickInit; /// ʿ⿡ ܽŰ..
	bool			mTickInfluence;
	unsigned char	mTickType;
	float			mTickValue;
};

class cApplyObject : public cDramaturgyObject
{
public:
	cApplyObject();
	virtual ~cApplyObject();

	void*			operator new( size_t n ); 
	void			operator delete( void* ptr );

	/// apply drama  ȹѴ.
	virtual bool Init( unsigned long managedKey, unsigned char weaponType, eAPPLYDRAMA_TYPE type );

	/// ȿȣ Apply ´.(item ȿ  )
	virtual bool Init( unsigned long managedKey, unsigned long influenceIdx );

	virtual void Process( float time );

private:

	enum
	{
		eINDEX_DRAMA,
		eINDEX_INFLUENCE,
	};

//	sObject				mUserObj;
	unsigned char		mUserWeapon;

	/// drama or influence
	unsigned char		mIndexType;
	///
	unsigned long		mApplyIndex;

//	eAPPLYDRAMA_TYPE	mApplyType;
//	unsigned long		mInfluenceIdx;
};