#include "StdAfx.h"
#include "SkillScript.h"

#include "FileLoader.h"
#include "Tokenizer.h"

#include "DramaturgyManager.h"
#include "GameResourceManager.h"


cSkillScript* cSkillScript::mpSkillScript = NULL;



cSkillScript::cSkillScript(void)
{
	/// ̱
	mpSkillScript = this;
}

bool cSkillScript::Init()
{
	Release();

	/// ų ũƮ ε
	if( !PlayerSkillScriptLoad() )
	{
		assert(NULL);
		return false;
	}

	/// ų ũƮ ε
	if( !MonsterSkillScriptLoad() )
	{
		assert(NULL);
		return false;
	}

	if( !PlayerSkillStepLoad() )
	{
		assert(NULL);
		return false;
	}

	if( DRAMATURGYMAN->Init() == false )
	{
		assert(0);
		return false;
	}

	if( !InfluenceLoad() )
	{
		assert(NULL);
		return false;
	}

	///// ų ũƮ ε
	//if( !PlayerSkillJobScriptLoad() )
	//{
	//	assert(NULL);
	//	return false;
	//}

	//PlayerFreeSkillList();

	return true;

}

void cSkillScript::Release()
{
	cSkillHashMap::cIterator iter;

	for(iter = mPlayerSkillInfoMap.Begin() ; iter != mPlayerSkillInfoMap.End() ; ++iter)
	{
		delete (sPlayerSkillBaseInfo*)(*iter).mSecond;
	}
	mPlayerSkillInfoMap.Clear();

	///  ⺻ų  
	for( iter = mMonsterBaseSkillMap.Begin(); iter != mMonsterBaseSkillMap.End(); ++iter )
	{
		delete (cArray*)iter->mSecond;
	}
	mMonsterBaseSkillMap.Clear();

	/// Ʈ() Ư ų  
	for( iter = mMonsterEliteSkillMap.Begin(); iter != mMonsterEliteSkillMap.End(); ++iter )
	{
		delete (cArray*)iter->mSecond;
	}
	mMonsterEliteSkillMap.Clear();

	/// üų  
	for( iter = mMonsterSkillTotalMap.Begin(); iter != mMonsterSkillTotalMap.End(); ++iter )
	{
		delete (sMonsterSkillScript*)iter->mSecond;
	}
	mMonsterSkillTotalMap.Clear();

	for( iter = mInfluenceMap.Begin() ; iter != mInfluenceMap.End() ; ++iter )
	{
		delete (sInfluenceScript*)(*iter).mSecond;
	}
	mInfluenceMap.Clear();

	for( iter = mSkillJobMap.Begin() ; iter != mSkillJobMap.End() ; ++iter )
	{
		delete (tArray<unsigned short>*)(*iter).mSecond;
	}
	mSkillJobMap.Clear();

	for( iter = mFreeSkillMap.Begin() ; iter != mFreeSkillMap.End() ; ++iter )
	{
		delete (tArray<unsigned long>*)(*iter).mSecond;
	}
	mFreeSkillMap.Clear();
}

void cSkillScript::PlayerFreeSkillList()
{
	cSkillHashMap::cIterator i = mPlayerSkillInfoMap.Begin();
	cSkillHashMap::cIterator iend = mPlayerSkillInfoMap.End();

	/// ޿ ų
	for( ; i!=iend; i++ )
	{
		sPlayerSkillBaseInfo* info = (sPlayerSkillBaseInfo*)(*i).mSecond;

		unsigned long idx = (unsigned long)(*i).mFirst;
		if( idx <= 100 )
			continue;

		if( info )
		{
			if( info->mpSetpInfoArray[0].mPlayerLevel == 0 )
			{
				if( info->mpSetpInfoArray[0].mJobType == 0 )
				{
					///    
					tArray<unsigned long>* p = (tArray<unsigned long>*)mFreeSkillMap.GetAt(0);
					if( p == 0 )
					{
						p = new tArray<unsigned long>;
						mFreeSkillMap.Insert( 0, p );
					}

					p->PushBack( (*i).mFirst );
				}
				else
				{
					/// Ư   
					tArray<unsigned long>* pArray = GetPlayerSkillJob( info->mpSetpInfoArray[0].mJobType );
					for( unsigned int ui=0; ui<pArray->GetSize(); ui++ )
					{
						tArray<unsigned long>* p = (tArray<unsigned long>*)mFreeSkillMap.GetAt( (*pArray)[ui] );
						if( p == 0 )
						{
							p = new tArray<unsigned long>;
							mFreeSkillMap.Insert( (*pArray)[ui], p );
						}
							

						p->PushBack( (*i).mFirst );
					}
				}
			}
		}
	}
	///
}


bool cSkillScript::PlayerSkillScriptLoad()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/SkillList_PC.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load SkillList_PC.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sPlayerSkillBaseInfo* pSkillInfo = 0;
	while( tokenizer.IsEnd() == false )
	{
		pSkillInfo = new sPlayerSkillBaseInfo;

		/// ų Idx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mSkillIdx = str.ToInt();

		/// ų ̸Idx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mNameIdx = str.ToInt();

		/// ų Idx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mIconIdx = str.ToInt();

		/// , 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mRace = static_cast<unsigned char>(str.ToInt());

		/// ų1 - ʿ佺ųidx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mLearnSkillIdx1 = str.ToInt();

		/// ų1 - ųʿܰ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mLearnSkillStep1 = static_cast<unsigned char>(str.ToInt());

		/// ų2 - ʿ佺ųidx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mLearnSkillIdx2 = str.ToInt();

		/// ų2 - ųʿܰ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mLearnSkillStep2 = static_cast<unsigned char>(str.ToInt());

		///  ܰ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mJobStep = static_cast<unsigned char>(str.ToInt());

		/// ų - ѻ SP
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mBeforeReqSP = str.ToInt();

		/// ų - ʿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mUseEquipment = static_cast<unsigned char>(str.ToInt());

		/// ų - ĳͻ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mUseState = static_cast<unsigned char>(str.ToInt());

		/// ų - ĳͻ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mUseItem = str.ToInt();

		/// з - ų  
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mType = static_cast<eSKILLTYPE>(str.ToInt());

		/// ų - Ӽ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mAttributeType = static_cast<eATTRIBUTETYPE>(str.ToInt());

		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mShotType = static_cast<eSHOTTYPE>(str.ToInt());

		///  - ų   
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mBoundType = static_cast<eBOUNDTYPE>(str.ToInt());

		/// ȿŸ - ȿ ȿ ޴ 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mApplyType = static_cast<eAPPLYTYPE>(str.ToInt());

		/// ų - Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mRangeType = static_cast<eRANGETYPE>(str.ToInt());

		/// ۷ιŸ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mIsGlobalCoolTime = str.ToInt() == 0 ? false : true;

		/// ׷Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mGroupCoolTimeIdx = str.ToInt();

		///  
		if( mPlayerSkillInfoMap.Insert( pSkillInfo->mSkillIdx, pSkillInfo ) == false )
		{
			assert(0);
			goto ERR;
		}

	}
	return true;

ERR:
	delete pSkillInfo;
	return false;
}

bool cSkillScript::PlayerSkillStepLoad()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/SkillList_Sub.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load SkillList_Sub.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	unsigned long skillIdx = ULONG_MAX;
	unsigned char step;

	sPlayerSkillStepInfo	stepArray[50] = {0,};
	unsigned int			stepCount = 0;
	unsigned long			currentSkillIdx = ULONG_MAX;

	while( tokenizer.IsEnd() == false )
	{
		/// ų Idx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		skillIdx = str.ToInt();

		if( currentSkillIdx != ULONG_MAX && (currentSkillIdx != skillIdx) )
		{
			/// ݱ   Ѵ.
			assert(stepCount);
			assert(stepCount<50);

			sPlayerSkillBaseInfo* pSkillInfo = GetPlayerSkillInfo( currentSkillIdx );
			if( pSkillInfo == 0 )
			{
				assert(0);
				return false;
			}

			/// о  Ѵ.
			pSkillInfo->mpSetpInfoArray = new sPlayerSkillStepInfo[stepCount];
			::memcpy( pSkillInfo->mpSetpInfoArray, stepArray, sizeof(sPlayerSkillStepInfo)*stepCount);
			pSkillInfo->mStepCount = stepCount;

			///  ʱȭ
			stepCount = 0;
		}
		currentSkillIdx = skillIdx;
		stepCount++;

		/// ų ܰ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		step = static_cast<unsigned char>(str.ToInt());

		/// Index
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mToolTipIdx = str.ToInt();

		/// SPʿ䰪	
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mRequireSP = static_cast<unsigned short>(str.ToInt());

		///  Index
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mJobType = static_cast<unsigned long>(str.ToInt());

		/// ĳ ʿLv	
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mPlayerLevel = static_cast<unsigned char>(str.ToInt());

		/// Ҹݾ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mUseMoney = str.ToInt();

		/// ¼ġ	
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mUseStateValue = static_cast<unsigned short>(str.ToInt());

		/// ҸMP
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mUseMP = str.ToInt();

		/// ҸHP
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mUseHP = str.ToInt();

		/// Ҹ۰	
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mUseItemCount = static_cast<unsigned char>(str.ToInt());

		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mTargetDist = static_cast<float>(str.ToInt());

		/// ĳýð
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mCastingTime = (float)(str.ToInt()/1000.0f);

		/// Ÿ	
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mCoolTime = (float)(str.ToInt()/1000.0f);

		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mBoundDist = static_cast<unsigned short>(str.ToInt());

		/// ߷	
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mAccuracyValue = static_cast<unsigned short>(str.ToInt());

		/// ũƼ	
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mCriticalValue = static_cast<unsigned short>(str.ToInt());

		///  ׷ ġ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mDistressValue = str.ToInt();

		/// 밪 type1
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mApplyValueType1 = static_cast<unsigned short>(str.ToInt());

		/// 밪1	
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mApplyValue1 = str.ToInt();

		/// 밪 type2
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mApplyValueType2 = static_cast<unsigned short>(str.ToInt());

		/// 밪2	
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mApplyValue2 = str.ToInt();

		/// ȿ Index
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		stepArray[step].mInfulenceIdx = str.ToInt();
		
		if( tokenizer.IsEnd() )
		{
			/// ݱ   Ѵ.
			assert(stepCount);
			assert(stepCount<50);

			sPlayerSkillBaseInfo* pSkillInfo = GetPlayerSkillInfo( currentSkillIdx );
			if( pSkillInfo == 0 )
			{
				assert(0);
				return false;
			}

			/// о  Ѵ.
			pSkillInfo->mpSetpInfoArray = new sPlayerSkillStepInfo[stepCount];
			::memcpy( pSkillInfo->mpSetpInfoArray, stepArray, sizeof(sPlayerSkillStepInfo)*stepCount);
			pSkillInfo->mStepCount = stepCount;

			///  ʱȭ
			stepCount = 0;
		}
	}
	return true;
}



bool cSkillScript::InfluenceLoad()
{
	///   
	cSkillHashMap::cIterator iter;
	for( iter = mInfluenceMap.Begin() ; iter != mInfluenceMap.End() ; ++iter )
	{
		delete (sInfluenceScript*)(*iter).mSecond;
	}
	mInfluenceMap.Clear();

	/// ε..
	cFileLoader loader;
	cString pathName = "./Script/Resource/SkillList_Effect.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load SkillList_Effect.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		/// ȿIdx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long influenceIdx = str.ToInt();

		///ϸ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		cString dramaturgyFile = str;

		/// ̸Idx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long nameidx = str.ToInt();

		/// ȿIdx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long iconIdx = str.ToInt();

		/// ȿIdx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long toolTipIdx = str.ToInt();

		/// Ӽ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned char type = static_cast<unsigned char>(str.ToInt());

		/// з
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned char typeDetail = static_cast<unsigned char>(str.ToInt());

		/// ״° ȿ 
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		bool dieDelete = str.ToInt() == 0 ? true : false;

		/// ȿ ׷
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long groupIdx = str.ToInt();

		/// ȿ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long groupOrder = str.ToInt();

		/// ߺҰ׷
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long notOverlapGroupIdx = static_cast<unsigned short>(str.ToInt());

		/// (äθ)ð
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float continuanceTime = str.ToFloat() / 1000.0f;

		/// ߵȮ
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned char activityPer = static_cast<unsigned char>(str.ToInt());

		/// ȿȣ1
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned short statusPlusIdx1 = static_cast<unsigned short>(str.ToInt());

		/// ð1
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		float time1 = str.ToFloat() / 1000.0f;

		/// ȿ1
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		long value1 = str.ToInt();

		/// ȿȣ2
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned short statusPlusIdx2 = static_cast<unsigned short>(str.ToInt());

		/// ð2
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long time2 = str.ToInt();

		/// ȿ2
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		long value2 = str.ToInt();

		/// ȿȣ3
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned short statusPlusIdx3 = static_cast<unsigned short>(str.ToInt());

		/// ȿ3
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		long value3 = str.ToInt();

		sInfluenceScript* pInfluence = new sInfluenceScript;
		
		pInfluence->mInfluenceIdx = influenceIdx;
		pInfluence->mDramaturgyFile = dramaturgyFile;
		pInfluence->mNameidx = nameidx;
		pInfluence->mIconIdx = iconIdx;
		pInfluence->mToolTipIdx = toolTipIdx;
		pInfluence->mType = type;
		pInfluence->mTypeDetail = typeDetail;
		pInfluence->mDieDelete = dieDelete;
		pInfluence->mGroupIdx = groupIdx;
		pInfluence->mGroupOrder = groupOrder;
		pInfluence->mNotOverlapGroupIdx = notOverlapGroupIdx;
		pInfluence->mContinuanceTime = continuanceTime;
		pInfluence->mActivityPer = activityPer;
		pInfluence->mStatusPlusIdx1 = statusPlusIdx1;
		pInfluence->mTime1 = time1;
		pInfluence->mValue1 = value1;
		pInfluence->mStatusPlusIdx2 = statusPlusIdx2;
		pInfluence->mTime2 = time2;
		pInfluence->mValue2 = value2;
		pInfluence->mStatusPlusIdx3 = statusPlusIdx3;
		pInfluence->mValue3 = value3;

		if( !mInfluenceMap.Insert( influenceIdx, pInfluence ) )
		{
			assert(0);
			return false;
		}

// ̷ ڵ  ʵ   κи Common 
		///  Ͽ  ε
		DRAMATURGYMAN->LoadInfluenceDrama( pInfluence->mInfluenceIdx, pInfluence->mDramaturgyFile, false );
	}

	return true;
}


bool cSkillScript::PlayerSkillJobScriptLoad()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/SkillList_Class.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load SkillList_Class.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	tArray<unsigned long>	*pJobArry;

	while( tokenizer.IsEnd() == false )
	{
		/// Idx
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		unsigned long jobIdx = str.ToInt();

		/// ڵ1
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		ePLAYER_JOB jobCode1 = static_cast<ePLAYER_JOB>(str.ToInt());

		/// ڵ2
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		ePLAYER_JOB jobCode2 = static_cast<ePLAYER_JOB>(str.ToInt());

		/// ڵ3
		if( tokenizer.GetNext( &str ) == false )	{ return false; }
		ePLAYER_JOB jobCode3 = static_cast<ePLAYER_JOB>(str.ToInt());
		
		pJobArry = new tArray<unsigned long>;

		/// 迭  
		if( jobCode1 != 0 )	pJobArry->PushBack( static_cast<unsigned long>(jobCode1) );
		if( jobCode2 != 0 )	pJobArry->PushBack( static_cast<unsigned long>(jobCode2) );
		if( jobCode3 != 0 )	pJobArry->PushBack( static_cast<unsigned long>(jobCode3) );

		if( !mSkillJobMap.Insert( jobIdx, pJobArry ) )
		{
			return false;
		}


	}

	return true;
}



bool cSkillScript::MonsterSkillScriptLoad()
{
	cFileLoader loader;
	cString pathName = "./Script/Resource/SkillList_Mon.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load SkillList_Mon.txt" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	sMonsterSkillScript* pSkillInfo;

	while( tokenizer.IsEnd() == false )
	{
		pSkillInfo = new sMonsterSkillScript;

		/// Idx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mMonsterIdx = str.ToInt();

		/// ݹ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mAttackType = (eMONSTERATTACK_TYPE)str.ToInt();

		/// Drama file
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mDramaFile = str;


		/// Idx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mToolTipIdx = str.ToInt();

		/// ų з
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mType = (eMONSTERSKILLTYPE)str.ToInt();

		/// Ӽ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mAttributeType = (eATTRIBUTETYPE)str.ToInt();
		
		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mRangeType = (eRANGETYPE)str.ToInt();
		
		/// ݷ()
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mMinAttackValue = str.ToInt();
		
		/// ݷ()
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mMaxAttackValue = str.ToInt();
		
		/// ߷
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mAccuracyValue = (unsigned short)str.ToInt();
		
		/// ũƼ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mCriticalValue = (unsigned short)str.ToInt();
		
		/// (HP)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mUseHPCheck = (eMONSTERHPCHECK)str.ToInt();
		
		/// (ҸMP)
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mUseMP = str.ToInt();
		
		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mTargetDist = (float)str.ToInt();
		
		/// ݼӵ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mAttackSpd = str.ToFloat() / 1000.f;

		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mCoolTime = (float)str.ToInt() / 1000.0f;
		
		/// Ȯ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mSkillUsePer = (unsigned char)str.ToInt();
		
		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mShotType = (eMONSTERSHOTTYPE)str.ToInt();
		
		/// 
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mBoundType = (eBOUNDTYPE)str.ToInt();
		
		/// Ÿ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mBoundDist = (unsigned short)str.ToInt();
		
		/// ȿŸ
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mApplyType = (eAPPLYTYPE)str.ToInt();
		
		/// ĳýð
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mCastingTime = (float)str.ToInt();
		
		/// ȿȣ1
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mApplyValueType1 = (unsigned short)str.ToInt();
		
		/// ȿ1
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mApplyValue1 = str.ToInt();
		
		/// ȿȣ2
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mApplyValueType2 = (unsigned short)str.ToInt();
	
		/// ȿ2
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mApplyValue2 = str.ToInt();
		
		/// ȿIdx
		if( tokenizer.GetNext( &str ) == false )	{ goto ERR; }
		pSkillInfo->mInfulenceIdx = str.ToInt();

		///  ų ε  - Ŭε * 100 + Ÿ
		unsigned long monSkillIdx = pSkillInfo->mMonsterIdx * 100 + pSkillInfo->mAttackType;

		/// ü ų Ʈ ´.
		if( mMonsterSkillTotalMap.Insert( monSkillIdx, pSkillInfo ) == false )
		{
			assert(0);
			return false;
		}

		if( pSkillInfo->mAttackType < eMONSTERATTACK_MAX )
		{
			/// ⺻ ų 5  ´.
			cArray* pMonsterSkillAry = (cArray*)mMonsterBaseSkillMap.GetAt( pSkillInfo->mMonsterIdx );
			if( pMonsterSkillAry == NULL )
			{
				pMonsterSkillAry = new cArray;
				if( mMonsterBaseSkillMap.Insert( pSkillInfo->mMonsterIdx, pMonsterSkillAry ) == false)
				{
					assert(NULL);
					return false;
				}
			}
			pMonsterSkillAry->PushBack( pSkillInfo );
		}
		else	
		{
			/// Ʈ() Ư ų 
			cArray* pEliteSkillAry = (cArray*)mMonsterEliteSkillMap.GetAt( pSkillInfo->mMonsterIdx );
			if( pEliteSkillAry == NULL )
			{
				pEliteSkillAry = new cArray;
				if( mMonsterEliteSkillMap.Insert( pSkillInfo->mMonsterIdx, pEliteSkillAry ) == false)
				{
					assert(NULL);
					return false;
				}
			}
			pEliteSkillAry->PushBack( pSkillInfo );
		}
	}

	return true;

ERR:
	delete pSkillInfo;
	return false;
}



sPlayerSkillBaseInfo* cSkillScript::GetPlayerSkillInfo( unsigned long skillNumber )
{
	sPlayerSkillBaseInfo* pSkillInfo = NULL;

	cSkillHashMap::cIterator start = mPlayerSkillInfoMap.Find( skillNumber );
	cSkillHashMap::cIterator end = mPlayerSkillInfoMap.End();

	if( start == end )	
	{ 
		return NULL; 
	}

	pSkillInfo = (sPlayerSkillBaseInfo*)((*start).mSecond);

	if( pSkillInfo == NULL )
	{
		assert(NULL);
		return NULL;
	}

	return pSkillInfo;
}



sMonsterSkillScript* cSkillScript::GetMonsterSkillInfo( unsigned long monsterClassIdx, eMONSTERATTACK_TYPE attackType )
{
	unsigned long skillIdx = monsterClassIdx*100 + attackType;

	return (sMonsterSkillScript*)mMonsterSkillTotalMap.GetAt( skillIdx );
}

cSkillHashMap* cSkillScript::GetMonsterSkillTotalMap()
{
	return &mMonsterSkillTotalMap;
}

void* cSkillScript::GetMonsterBaseSkillArr( unsigned long monsterClassIdx )
{
	return mMonsterBaseSkillMap.GetAt( monsterClassIdx );
}

void* cSkillScript::GetMonsterEliteSkillArr( unsigned long monsterClassIdx )
{
	return mMonsterEliteSkillMap.GetAt( monsterClassIdx );
}

tArray<unsigned long>* cSkillScript::GetPlayerSkillJob( unsigned long jobIdx )
{
	return (tArray<unsigned long>*)mSkillJobMap.GetAt( jobIdx );
}



sInfluenceScript* cSkillScript::GetInfluenceInfo( unsigned long influenceClassIdx )
{
	return (sInfluenceScript*)mInfluenceMap.GetAt( influenceClassIdx );
}

bool cSkillScript::IsCastSkill( unsigned long skillIdx, unsigned long skillStep )
{
	sPlayerSkillBaseInfo* pInfo = GetPlayerSkillInfo( skillIdx );
	if( pInfo )
	{
		if( pInfo->mStepCount <= skillStep )
			return false;

		sPlayerSkillStepInfo step = pInfo->mpSetpInfoArray[skillStep];
		if( step.mCastingTime > 0.0f )
			return true;
	}
	return false;
}
