/* ==========================================================================
*    : ̼
*    : 2007.03.20
*      :  ý
* ǻ : 
*===========================================================================*/
#pragma once

struct sSoundInfo
{
	unsigned long	mIndex;
	cString			mFileName;
	float			mVolume;
	float			mRadius;
};


///  ý
class cSoundSystem
{
	static cSoundSystem* mSingleton;

public:
	/// ü 
	static cSoundSystem* GetSingleton();

	cSoundSystem();
	~cSoundSystem();

	/// ʱȭ
	bool Init( NiWindowRef hwnd );

	void Close();

	/// ó
	void Process( float deltaTime, float accumTime );

	void ProcessStageBGM( unsigned long accumTime );
	inline bool IsBGMFading() { return mFadeBGM; }

	inline bool IsSoundActive() { return mActiveSound; }
	void ActiveSound( bool active );

	/// 
	void StopAll();

	///  
	NiAudioSource* LoadAreaSound( unsigned int index, const cString& pathName, bool streamed = false );
	NiAudioSource* GetAreaSound( unsigned int index ) const;
	//bool DestroyAreaSound( unsigned int index );

public:
	/// 忡   
	sSoundInfo*	GetSoundInfo( unsigned long index );

	/// 2D 
	bool Play2DSound( unsigned long index );

	bool LoadBGMList();
	void PlayBGMSound( unsigned int index );

protected:
	bool LoadSoundFiles();
	bool LoadSoundList();

private:
	///   
	typedef tHashMap<unsigned int, void*> cAreaSoundMap;
	cAreaSoundMap mAreaSoundMap;

	/// ũƮ ε, 
	typedef tPointerHashMap<unsigned long, void*> cPointHashMap;
	cPointHashMap mSoundListMap;

	///  2D  
	typedef tPointerList<void*> cPlay2DSoundList;
	cPlay2DSoundList mPlayList;

	/// ..
	typedef tPointerList<void*> cDelList;
	cDelList mDelList;

	NiAudioSource*		mBGMArray[2];
	NiAudioSource*		mCurrentBGM;
	NiAudioSource*		mNewBGM;
	bool				mFadeBGM;

	bool				mActiveSound;
};

inline
NiAudioSource* cSoundSystem::GetAreaSound( unsigned int index ) const
{
	cAreaSoundMap::cConstIterator i = mAreaSoundMap.Find( index );

	if( i != mAreaSoundMap.End() )
		return (NiAudioSource*)(*i).mSecond;
	else
		return 0;
}

inline
sSoundInfo* cSoundSystem::GetSoundInfo( unsigned long index )
{
	return (sSoundInfo*)mSoundListMap.GetAt( index );
}

inline
cSoundSystem* cSoundSystem::GetSingleton()
{
	return mSingleton;
}

#define SOUNDSYS cSoundSystem::GetSingleton()

/*//  ý
class cSoundSystem
{
	static cSoundSystem* mpSingleton;

public:
	cSoundSystem();
	~cSoundSystem();

	/// 
	void Clear();

	/// 
	void Exit();

	/// ʱȭ
	bool Init( NiWindowRef hwnd );

	/// ó
	void Process( float time );

	/// 
	NiAVObject* GetListener();

	/// ε
	bool LoadBackground( const cString& pathName );
	bool LoadEffect( const cString& pathName );

	/// ÷
	//void PlayBackground( unsigned int index );
	void PlayEffect( unsigned int index );

	void StopAllSounds();
	//void RewindAmbientSound();
	//void SetAmbientGain(float fGain);

protected:
	bool LoadAmbient( const cString& pathName, bool bgm );

public:
	/// ü 
	static cSoundSystem* GetSingleton();

private:
	///   迭
	//	typedef tArray<NiAudioSource*> cSoundArray;
	typedef tArray<void*> cSoundArray;
	cSoundArray mBackgroundArray;

	/// ȿ  迭
	cSoundArray mEffectArray;

	//NiAudioSource* mpCurrentAmbient;
};

inline cSoundSystem* cSoundSystem::GetSingleton()
{
	return mpSingleton;
}

#define SOUNDSYS cSoundSystem::GetSingleton()
*/
