#include "stdafx.h"
#include "StaticSceneNode.h"

#include "ResourceManager.h"
#include "CameraManager.h"
#include "SceneManager.h"

#include "NifAnimationInfo.h"

cStaticSceneNode::cStaticSceneNode( eType type )
: cSceneNode( type )
, mVisibleLevel( 0 )
, mOccludeLevel( 1 )
, mPickedByCamera( false )
{
	mNifAniInfo = new cNifAnimationInfo;
}

cStaticSceneNode::~cStaticSceneNode()
{
	SAFE_DELETE( mNifAniInfo );
}

void cStaticSceneNode::OnProcess( float deltaTime, float accumTime )
{

	/// ĸ ó
	if( mAlphaForced == false && mOccludeLevel == 1 )
		OnProcessAlpha( deltaTime );

	mTargetAlpha = 1.0f;

	/// ݺ     带 ó
	if( mNifAniInfo )
	{
		mNeedUpdate	= true;
		mNifAniInfo->Update( deltaTime, accumTime );
	}

	mPickedByCamera = false;
	cSceneNode::OnProcess( deltaTime, accumTime );
}

bool cStaticSceneNode::OnVisible( cSceneCuller& culler )
{
	if( mViewNode == false )
		return false;

	/// ĸ ó
	if( mOccludeLevel == 1 && mPickedByCamera )
		mTargetAlpha = 0.4f;

	return cSceneNode::OnVisible( culler );
}

bool cStaticSceneNode::Init( const cStaticSceneNodeParam& param )
{
	///  ε
	if( RESOURCEMAN->LoadMapNIF( param.mPathName.Cstr() ) == false )
	{
		//		assert( 0 && "failed to load nif file" );
		return false;
	}

	/// ҽ ڷκ  带 
	NiNode* n = RESOURCEMAN->CloneObjectByName( param.mPathName.Cstr() );
	if( n == 0 )
	{
		assert( 0 && "failed to clone node from resource manager" );
		return false;
	}

	///  ʱȭ
	mNiObject = n;
	if( cSceneNode::Init( param ) == false )
	{
		return false;
	}

	///   
	mVisibleLevel = param.mVisibleLevel;

	///   
	mOccludeLevel = param.mOccludeLevel;

	///  Ӽ 
	NiAlphaProperty* alphaProp = (NiAlphaProperty*)n->GetProperty( NiProperty::ALPHA );
	mAlphaForced = (alphaProp != 0);

	if( mAlphaForced )
	{
		mAlphaBlended = true;
	}
	else
	{
		mAlphaBlended = false;

		if( mOccludeLevel == 1 )
		{
			///  Ӽ  
			alphaProp = NiNew NiAlphaProperty;
			alphaProp->SetAlphaBlending( false );
			alphaProp->SetAlphaTesting( false );
			n->AttachProperty( alphaProp );

			bool blendEnabled = alphaProp->GetAlphaBlending();
			bool testEnabled = alphaProp->GetAlphaTesting();
			NiAlphaProperty::TestFunction testFunc = alphaProp->GetTestMode();
			unsigned char testRef = alphaProp->GetTestRef();

			mAlphaDataList.PushBack( new cAlphaData( blendEnabled, testEnabled, testFunc, testRef, alphaProp ) );
		}
	}

	/// Ӽ 
	CollectProperties( n );

	///  
	if( param.mMaterialApplied )
		SetMaterial( param.mMaterial );

	///// Ȱ Ӽ 
	//if( param.mFogApplied )
	//	n->AttachProperty( FOGAGENT->GetFogProperty() );

	if( param.mNoAttachLight == false )
	{
		n->AttachEffect( SCENEMAN->GetAmbientLight() );
//		///  
//		n->AttachEffect( LIGHTAGENT->GetSceneAmbientLight( 0 ) );
//		n->AttachEffect( LIGHTAGENT->GetSceneDirLight( 0 ) );
	}

	/// ִϸ̼ Ʈѷ  
	mNifAniInfo->CollectData( n );

	if( mNifAniInfo->GetNumberOfControllers() )
	{
		mNifAniInfo->SetAnimType( NiTimeController::APP_INIT );
		mNifAniInfo->SetLooping( true );
	}
	else
	{
		/// ִ  ٸ ޸ 
		SAFE_DELETE(mNifAniInfo);
	}

	if( mNifAniInfo && param.mDisableAnimation == true )
		mNifAniInfo->Stop();

	///  带 
	n->SetSelectiveUpdate( true );
	n->SetSelectiveUpdateTransforms( true );
	n->SetSelectiveUpdatePropertyControllers( true );
	n->SetSelectiveUpdateRigid( false );

	///  带 ó
	n->Update( 0.0f );
	n->UpdateProperties();
	n->UpdateEffects();
	n->UpdateNodeBound();

	return true;
}

bool cStaticSceneNode::Init( NiNode* node )
{
	///  Ʈ 
	CollectGeoms( node );

	///   
	CollectBillboards( node );

	/// Ӽ 
	CollectProperties( node );

	///  
//	node->AttachEffect( SCENEMAN->GetAmbientLight() );

	///  带 
	node->SetSelectiveUpdate( true );
	node->SetSelectiveUpdateTransforms( false );
	node->SetSelectiveUpdatePropertyControllers( true );
	node->SetSelectiveUpdateRigid( true );

	///  带 ó
	node->UpdateProperties();
	node->UpdateEffects();
	node->Update( 0.f );

	/// ִϸ̼ Ʈѷ  
	mNifAniInfo->CollectData( node );

	mNifAniInfo->SetAnimType( NiTimeController::APP_INIT );
	mNifAniInfo->SetLooping( true );

	///  ʱȭ
	mNiObject = node;

	mBoundSphere.Set( GetCenter(), GetRadius() );

	return true;
}

void cStaticSceneNode::SetMaterial( const cMaterialData& material )
{
	cMatPropList::cIterator i = mMatPropList.Begin();
	cMatPropList::cIterator end = mMatPropList.End();

	for( ; i != end; ++i )
	{
		NiMaterialProperty* matProp = (NiMaterialProperty*)*i;

		matProp->SetAmbientColor( material.mAmbient );
		matProp->SetDiffuseColor( material.mDiffuse );
		matProp->SetSpecularColor( material.mSpecular );
		matProp->SetEmittance( material.mEmissive );
		matProp->SetShineness( material.mShininess );
		matProp->SetAlpha( material.mAlpha );
	}

	mMaterial = material;
}

/*
#include "stdafx.h"
#include "StaticSceneNode.h"

#include "ResourceManager.h"
#include "CameraManager.h"
#include "SceneManager.h"

#include "NifAnimationInfo.h"

cStaticSceneNode::cStaticSceneNode( eType type )
: cSceneNode( type )
, mVisibleLevel( 0 )
, mOccludeLevel( 1 )
, mPickedByCamera( false )
{
	mNifAniInfo = new cNifAnimationInfo;
}

cStaticSceneNode::~cStaticSceneNode()
{
	SAFE_DELETE( mNifAniInfo );
}

void cStaticSceneNode::OnProcess( float deltaTime, float accumTime )
{
	/// ĸ ó
	if( mAlphaForced == false && mOccludeLevel == 1 )
		OnProcessAlpha( deltaTime );

	mTargetAlpha = 1.0f;

	/// ݺ     带 ó
	if( mNifAniInfo )
	{
		mNeedUpdate	= true;
		mNifAniInfo->Update( accumTime );
	}

	mPickedByCamera = false;
	cSceneNode::OnProcess( deltaTime, accumTime );
}

bool cStaticSceneNode::OnVisible( cSceneCuller& culler )
{
	/// ĸ ó
	if( mOccludeLevel == 1 && mPickedByCamera )
		mTargetAlpha = 0.4f;
	//else
	//	mTargetAlpha = 1.f;

	if( mAlpha < 0.00001f )
		return false;

	return cSceneNode::OnVisible( culler );
}

bool cStaticSceneNode::Init( const cStaticSceneNodeParam& param )
{
	///  ε
	if( RESOURCEMAN->LoadNIF( param.mPathName.Cstr() ) == false )
	{
//		assert( 0 && "failed to load nif file" );
		return false;
	}

	/// ҽ ڷκ  带 
	NiNode* n = RESOURCEMAN->CloneObjectByName( param.mPathName.Cstr() );
	if( n == 0 )
	{
		assert( 0 && "failed to clone node from resource manager" );
		return false;
	}

	///  ʱȭ
	mNiObject = n;
	param.mNiObject = mNiObject;
	if( cSceneNode::Init( param ) == false )
	{
		return false;
	}

	///   
	mVisibleLevel = param.mVisibleLevel;

	///   
	mOccludeLevel = param.mOccludeLevel;

	///  Ӽ 
	NiAlphaProperty* alphaProp = (NiAlphaProperty*)n->GetProperty( NiProperty::ALPHA );
	mAlphaForced = (alphaProp != 0);

	if( mAlphaForced )
	{
		mAlphaBlended = true;
	}
	else
	{
		mAlphaBlended = false;
	}

	/// Ӽ 
	CollectProperties( n );

	///  
	SetMaterial( param.mMaterial );

	///  
	n->AttachEffect( SCENEMAN->GetAmbientLight() );
//	n->AttachEffect( LIGHTAGENT->GetSceneDirLight( 0 ) );

	///  带 
	n->SetSelectiveUpdate( true );
	n->SetSelectiveUpdateTransforms( false );
	n->SetSelectiveUpdatePropertyControllers( true );
	n->SetSelectiveUpdateRigid( true );

	///  带 ó
	n->UpdateProperties();
	n->UpdateEffects();
	n->Update( 0.f );
//	n->UpdateNodeBound();

	/// ִϸ̼ Ʈѷ  
	mNifAniInfo->CollectData( n );

	if( mNifAniInfo->GetNumberOfControllers() )
	{
		mNifAniInfo->SetAnimType( NiTimeController::APP_INIT );
		mNifAniInfo->SetLooping( true );
	}
	else
	{
		/// ִ  ٸ ޸ 
		SAFE_DELETE(mNifAniInfo);
	}
	return true;
}

bool cStaticSceneNode::Init( NiNode* node )
{
	///  Ʈ 
	CollectGeoms( node );

	///   
	CollectBillboards( node );

	/// Ӽ 
	CollectProperties( node );

	///  
	node->AttachEffect( SCENEMAN->GetAmbientLight() );

	///  带 
	node->SetSelectiveUpdate( true );
	node->SetSelectiveUpdateTransforms( false );
	node->SetSelectiveUpdatePropertyControllers( true );
	node->SetSelectiveUpdateRigid( true );

	///  带 ó
	node->UpdateProperties();
	node->UpdateEffects();
	node->Update( 0.f );

	/// ִϸ̼ Ʈѷ  
	mNifAniInfo->CollectData( node );

	mNifAniInfo->SetAnimType( NiTimeController::APP_INIT );
	mNifAniInfo->SetLooping( true );

	///  ʱȭ
	mNiObject = node;

	mBoundSphere.Set( GetCenter(), GetRadius() );

	return true;
}

void cStaticSceneNode::SetMaterial( const cMaterialData& material )
{
	cMatPropList::cIterator i = mMatPropList.Begin();
	cMatPropList::cIterator end = mMatPropList.End();

	for( ; i != end; ++i )
	{
		NiMaterialProperty* matProp = (NiMaterialProperty*)*i;

		matProp->SetAmbientColor( material.mAmbient );
		matProp->SetDiffuseColor( material.mDiffuse );
		matProp->SetSpecularColor( material.mSpecular );
		matProp->SetEmittance( material.mEmissive );
		matProp->SetShineness( material.mShininess );
		matProp->SetAlpha( material.mAlpha );
	}

	mMaterial = material;
}

/*
void cStaticSceneNode::SetMaterial( const cMaterialData& material )
{
	mMaterial = material;

	NiMaterialProperty* pmpt = NULL;
	unsigned int size = mMaterialPropertyList.GetSize();

	for( unsigned int i=0; i<size; ++i )
	{
		pmpt = mMaterialPropertyList.GetAt(i);
		if( pmpt )
		{
			pmpt->SetAmbientColor( material.mAmbient );
			pmpt->SetDiffuseColor( material.mDiffuse );
			pmpt->SetSpecularColor( material.mSpecular );
			pmpt->SetEmittance( material.mEmissive );
			pmpt->SetShineness( material.mShininess );
			pmpt->SetAlpha( material.mAlpha );
		}
	}
}
*/
