#include "StdAfx.h"
#include "TexturePalette.h"

#include "RenderSystem.h"
#include "ResourceManager.h"
#include "Stream.h"
#include "EngineFile.h"
#include "ImageReader.h"

cTexturePalette::cTexturePalette( unsigned int sizeHint )
: NiDefaultTexturePalette( false )
, mTextureMap( sizeHint )
, mStream( 0 )
{
}

cTexturePalette::~cTexturePalette()
{
}

void cTexturePalette::RemoveAllTextures()
{
	mTextureMap.Clear();
	/*
	#ifdef _DEBUG
	NiTMapIterator mapiter = m_kHash.GetFirstPos();

	while (mapiter)
	{
	const char* name;
	NiTexturePtr texture;
	m_kHash.GetNext(mapiter, name, texture);

	//		assert(texture->GetRefCount() == 2);
	texture = 0;
	}
	#endif
	*/
	//m_kHash.RemoveAll();
}

//void cTexturePalette::RemoveTexture( NiTexture* tex )
//{
//	//   , ҽ  üũ ٽ ϶!!
//	assert( tex || tex->GetName() );
//
//	m_kHash.RemoveAt( tex->GetName() );
//}
//
//void cTexturePalette::RemoveTexture( char* texName )
//{
//	assert( ::strlen(texName) );
//
//	m_kHash.RemoveAt( texName );
//}

void cTexturePalette::SetTexture( const char* pathName, NiTexture* tex )
{
	assert( pathName );
	assert( tex );

	if( mTextureMap.Insert( pathName, tex ) == false )
	{
		assert(0);
	}
	//test
	//if( mStream )
	//{
	//	const char* path = mStream->GetPath().Cstr();
	//	path = path;
	//}
	//NiDefaultTexturePalette::SetTexture( pathName, tex );
	//NiFilename name = NiFilename(pcPath);
	//cString str = name.GetFilename();
	//str += name.GetExt();

	//NiDefaultTexturePalette::SetTexture( pathName, tex );
}

NiTexture* cTexturePalette::GetTexture( const char* pathName, NiTexture* /*tex*/ ) const
{
	assert( pathName );

	/// ̹ ϴ ˻
	cTextureMap::cIterator pos = mTextureMap.Find( pathName );

	if( pos != mTextureMap.End() )
	{
		return pos->mSecond;
	}

	if( mStream == 0 )
		return 0;

	/// Ʈ ܺ ؽó  ε
	NiTexturePtr nitex = 0;
	NiPixelDataPtr pixelData = 0;

	cString tempName;
	tempName.Format( "%s%s", mStream->GetPath().Cstr(), pathName );

	cString ext;
	::GetFileExtension( &ext, tempName );
	ext.ToLower();

	if( ext == "nif" )
	{
		cFileLoader loader;
		if( loader.Open( tempName, true ) == false )
			return 0;

		/// ȼ Ÿ ε
		cTextureStream stream( tempName );

		if( stream.Load( (char*)loader.GetBufferPtr(), loader.GetSize() ) == false )
			return 0;

		pixelData = stream.mPixelData;
	}
	else if( ext == "tga" )
	{
		cFileLoader loader;
		if( loader.Open( tempName, true ) == false )
			return 0;

		cEngineFile file( loader.GetFile() );
		cTGAReader tgaReader;
		pixelData = tgaReader.ReadFile( file, 0 );
	}
	else
	{
		assert( 0 );
		return 0;
	}

	if( pixelData == 0 )
		return 0;

	/// ȼ Ÿκ  ؽó 
	NiTexture::FormatPrefs prefs;
	prefs.m_eMipMapped = pixelData->GetNumMipmapLevels() == 1 ? NiTexture::FormatPrefs::NO : NiTexture::FormatPrefs::YES;

	nitex = NiSourceTexture::Create( pixelData, prefs );

	if( nitex == 0 )
		return 0;

	/// ؽó ʿ ߰
	if( mTextureMap.Insert( pathName, nitex ) == false )
	{
		assert(0);
		return 0;
	}

	return nitex;
}
