// CModelView.h : CModelView Ŭ ̽
//
#pragma once

class cApplication;
class cLookAtCamera;

// CModelView â

class CModelView : public CView
{
	static CModelView* mSingleton;
	DECLARE_DYNCREATE( CModelView )

	// 
public:
	CModelView();

	enum
	{
		eSTAGE_CHARACTER = 0,
		eSTAGE_MONSTER,
		eSTAGE_NPC,
	};

	void Init();

	/// ȭ ũ
	void Resize( unsigned int width, unsigned int height );

	/// 
	void Update();

	void ChangeStage( unsigned char stage );

	void CreateCharacter( unsigned long modelIndex, unsigned char race, unsigned char gender );
	void CreateMonster( unsigned long modelIndex );
	void CreateNpc( unsigned long modelIndex );

	/// 
	bool ChangeCharacterParts( unsigned long partIdx, const char* filename );
	bool ChangeCharacterPartsTexture( unsigned long partIdx, const char* filename );
	unsigned int LinkCharacterWeapon( unsigned long linkIdx, const char* filename, float scale );
	void UnLinkCharacterWeapon( unsigned int left, unsigned int right );

	///
	void ChangeAnimation( unsigned int seq );

	void ChangeBackColor( NiColor cr );

	inline unsigned char GetCurStage() { return mCurStage; }

	// Ư
public:

	// ۾
public:

	// 
protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	void OnDraw( CDC* dc );

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump( CDumpContext& dc ) const;
#endif

	// 
public:
	virtual ~CModelView();

	// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL()
protected:
	virtual BOOL OnCommand(WPARAM wparam, LPARAM lparam);
	//}}AFX_VIRTUAL

	// ޽  Լ ߽ϴ.
protected:
	afx_msg int OnCreate( LPCREATESTRUCT cs );
	afx_msg void OnDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* dc);
	afx_msg void OnSize( UINT type, int cx, int cy );
	afx_msg void OnMouseMove( UINT flags, CPoint point );
	afx_msg BOOL OnMouseWheel( UINT flags, short zdelta, CPoint point );
	afx_msg void OnLButtonDown( UINT flags, CPoint point );
	afx_msg void OnLButtonUp( UINT flags, CPoint point );
	afx_msg void OnRButtonDown( UINT flags, CPoint point );
	afx_msg void OnRButtonUp( UINT flags, CPoint point );
	afx_msg void OnMButtonDown( UINT flags, CPoint point );
	afx_msg void OnMButtonUp( UINT flags, CPoint point );
	afx_msg void OnContextMenu( CWnd* pWnd, CPoint pos );
//	afx_msg void OnSetFocus(CWnd* pOldWnd);
	DECLARE_MESSAGE_MAP()

public:
	/// ü 
	static CModelView* GetSingleton();

private:
	/// ø̼
	cApplication* mApplication;

	cLookAtCamera* mLookAtCamera;

	bool mInit;

	CMenu		m_cmenuCtxt;

	unsigned char mCurStage;
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
};

inline
CModelView* CModelView::GetSingleton()
{
	return mSingleton;
}

#define VIEW CModelView::GetSingleton()
