#include "StdAfx.h"
#include "bstreelinkedlist.h"
#include "Patcher.h"

CNode::CNode(void)
{
	m_pParent     = NULL;
	m_pLeftChild  = NULL;
	m_pRightChild = NULL;

	m_pNext_node  = NULL;
	m_pPrev_node  = NULL;

	m_pcKey		  = NULL;    // Ű
	
	m_psPatchfile = new Patchfile;
	memset( m_psPatchfile->fileName, 0, sizeof( m_psPatchfile->fileName));
	//m_psPatchfile = NULL;
}



CNode::~CNode(void)
{
	m_pParent     = NULL;
	m_pLeftChild  = NULL;
	m_pRightChild = NULL;

	m_pNext_node  = NULL;
	m_pPrev_node  = NULL;

	m_pcKey = NULL;        // Ű
	
	if( m_psPatchfile != NULL )
		delete m_psPatchfile;
	
	m_psPatchfile = NULL;

}


CBSTreeLinkedList::CBSTreeLinkedList(void)
{
	m_pLinked_List_Head = NULL;
	m_pLinked_List_Tail = NULL;
    m_pBSTreeRoot		= NULL;
}



CBSTreeLinkedList::~CBSTreeLinkedList(void)
{
	if( m_pLinked_List_Head != NULL)
		if( false == Delete_linked_list(m_pLinked_List_Head) )
		{
			assert(0);
			printf("error:ũ Ʈ  Ͽϴ.\n");
		}
	m_pLinked_List_Head = NULL;
	m_pLinked_List_Tail = NULL;
	m_pBSTreeRoot		= NULL;

}

bool CBSTreeLinkedList::ReleaseMemory()
{
	if( m_pLinked_List_Head != NULL)
		if( false == Delete_linked_list(m_pLinked_List_Head) )
		{
			assert(0);
			printf("error:ũ Ʈ  Ͽϴ.\n");
			return false;
		}
	m_pLinked_List_Head = NULL;
	m_pLinked_List_Tail = NULL;
	m_pBSTreeRoot		= NULL;

	return true;
}

bool CBSTreeLinkedList::Add_Node(Patchfile* input_data)
{
	if( strlen( input_data->fileName ) == 0 )
	{
		assert(0);
		return false;
	}
	else
	{
		//--------Ʈ ߰--------
		CNode  *pInsert_pos_finder = NULL, *pInsert_pos_parent = NULL;
		CNode  *new_node = NULL;

		pInsert_pos_finder = m_pBSTreeRoot; //root Ž

		//Ʈ  ġ ã.
		while( pInsert_pos_finder != NULL )
		{
			int ret= stricmp( pInsert_pos_finder->m_pcKey, input_data->fileName );

			pInsert_pos_parent = pInsert_pos_finder; //θ  

			//߰ Ͱ   ġ ã   
			if( ret < 0 )
			{
				pInsert_pos_finder = pInsert_pos_finder->m_pRightChild; //  ũٸ  ~
			}
			else if( ret > 0 )
			{
				pInsert_pos_finder = pInsert_pos_finder->m_pLeftChild; //  ۴ٸ  
			}
			else /*if( pInsert_pos_finder->m_pcKey == m_pcKey )*/// ٸ ߺ  Ƿ  ߻
			{
				// assert(0);
				return false;
			}
		}

		//Ӱ ߰  ִ  Ƿ ޸ Ҵ
		new_node = new CNode;

		if(new_node == NULL)
		{
			printf("error:ο  ޸ Ҵ з  ߰ .\n");
			return false;
		}
		
		new_node->m_psPatchfile->sizeHigh = input_data->sizeHigh;
		new_node->m_psPatchfile->sizeLow = input_data->sizeLow;
		new_node->m_psPatchfile->writeTime = input_data->writeTime;
		strncpy( new_node->m_psPatchfile->fileName, input_data->fileName, strlen( input_data->fileName ) );
        		
		new_node->m_pcKey = new_node->m_psPatchfile->fileName;

		//Ʈ  ġ .
		if( m_pBSTreeRoot == pInsert_pos_finder ) //ִ Ʈ 
		{
			m_pBSTreeRoot = new_node;
		}
		else if( stricmp( new_node->m_pcKey, pInsert_pos_parent->m_pcKey ) > 0 ) //θ庸 Ŭ    
		{
			pInsert_pos_parent->m_pRightChild = new_node;
			new_node->m_pParent = pInsert_pos_parent;
		}
		else /*if( strcmp( new_node->m_pcKey, pInsert_pos_parent->m_pcKey ) < 0 )*/ //θ庸     
		{
			pInsert_pos_parent->m_pLeftChild = new_node;
			new_node->m_pParent = pInsert_pos_parent;
		}

		//--------ũ Ʈ ߰--------
	
		//ִ ũ Ʈ ߰.
		if(m_pLinked_List_Head == NULL)
		{
			m_pLinked_List_Head = new_node;
			m_pLinked_List_Tail = new_node;
		}
		else //  Ʈ ߰.
		{
			m_pLinked_List_Tail->m_pNext_node = new_node;
			new_node->m_pPrev_node = m_pLinked_List_Tail;
			m_pLinked_List_Tail = m_pLinked_List_Tail->m_pNext_node;
		}

		return true;
	}

	return false;
}


bool CBSTreeLinkedList::Delete_linked_list(CNode *header) //ũ Ʈ   
{
	if(header->m_pPrev_node != NULL)
	{
		assert(0);
		//printf("error:! ũ Ʈ  ƴմϴ.\n");
		return false;
	}
	
	CNode *pdel_node = NULL;

	while( header != NULL) // ͸ ﶧ
	{
		pdel_node = header;
		header = header->m_pNext_node;
		delete pdel_node;
	}
	return true;
}



Patchfile* CBSTreeLinkedList::Search_Node(char *key, bool msg_off) // ã.
{

	CNode *pNode = m_pBSTreeRoot;

	if(pNode == NULL)
	{
		if(msg_off == false)
			printf("error:Ʈ ֽϴ\n");

		return NULL;
	}

	if( strlen( key ) == 0 ) //Ű ߸Ǿٸ ˻ 
	{
		if(msg_off == false)
			printf("error:߸ ͸ ̿Ͽ ˻ϼ̽ϴ.\n");

		assert(0);
		return NULL;
	}

	while(pNode != NULL)
	{
		int ret;
		
		ret = stricmp( pNode->m_pcKey,  key);
		
		//߰ Ͱ   ġ ã   
		if( ret < 0 )
		{
			pNode = pNode->m_pRightChild; //  ũٸ  ~
		}
		else if( ret > 0)
		{
			pNode = pNode->m_pLeftChild; //  ۴ٸ  
		}
		else /*if( pNode->m_pcKey == key_num )*/ // ٸ ˻ 
		{
			return pNode->m_psPatchfile;
		}	
	}

	//while Դٸ ִ  ãǷ ˻ 
	if(msg_off == false)
		printf("˻:ش ͸ ã  ϴ.\n");

	return NULL;

}

