/* ==========================================================================
*    : ̼
*    : 2007.06.21
*      : ó
* ǻ : 
*===========================================================================*/
#pragma once

#include "PatcherDlg.h"
#include "BSTreeLinkedList.h"
#include "HttpDownLoader.h"

#define MAX_PACKS	128

class cPatcherDlg;

/// .pack Ϸ  ȵǾ ϴ .
const char* const gUnpackFolder[]  = { "sound", "launcher", "guildmark", "script" };
/// Ŭ̾Ʈ     ʿ (񱳰 ȵǴ ).
const char* const gSkipFolder[]    = { "ScreenShot", "Option" };
const char* const SCRIPT_DIRECTORY = "script";
const DWORD       g16KBYTE         = 16384;

enum eUnpackFolder
{
	FOLDER_SOUND = 0,
	FOLDER_LAUNCHER,
	FOLDER_GUILDMARK,
	FOLDER_SCRIPT,
	UNPACK_FOLDER_COUNT,
};

enum eSkipFolder
{
	FOLDER_SCREENSHOT = 0,
	FOLDER_OPTION,
	SKIP_FOLDER_COUNT,
};


struct Packfile
{
 	char directory[ 1024 ];			// 丮
};
 
struct Packlist
{
 	Packfile* pack;
 	ULONG     offset;				// 
 	ULONG     length;				// ü
};
 
 struct Patchfile
 {
 	char     fileName[ 1024 ];		// ̸
 	DWORD    sizeHigh;				// ũ
 	DWORD    sizeLow;				// ũ
 	FILETIME writeTime;				// ϳ¥
 };
 
 struct Patchlist
 {
 	Patchfile* file;				// Ʈ  ü
 	ULONG      offset;				// 
 	ULONG      length;				// ü
 };

/// ó
class cPatcher
{
public:
	cPatcher( cPatcherDlg* dlg );
	~cPatcher();

	void Clear();
	void Init( HWND wnd, HINSTANCE instance );

	DWORD ThreadProc();
	void StopWorking();
	bool IsWorking() const;
	bool IsEndIO() const;

protected:
	bool MakeList(char* buffer);

	void SetProgressMax( ePatchStatus status, int max );
	void SetProgressPos( const char* fileName, int pos );

private:
	/// [12/9/2008 Jo] load.dll ε  ü.
	int  GetString(int id, char* buffer, int bufferSize ); 
	bool UnpackPatchList( char** buffer, DWORD *bufferLen );
	void FileTimeToDOS(FILETIME* filetime);

	bool VerifyFile(Patchfile* patchfile);
	bool UpdateFile(Patchfile* patchfile, char* buffer, DWORD bufferLen);
	void ErrorPrint(char *msg);
	int  Search(char* root, char* sub, int& files, int& directories, bool opcode);
	void EventWrite(LPCTSTR format, ...);
	HANDLE GetProcessList( bool* bFuncFailed );
private:
	/// ̾α
	cPatcherDlg* mDlg;
	HWND	     mWnd;
	HINSTANCE    mInstance;
	bool         mEndApp;
	bool         mEndIO;

	char         m_currentDirectory[ MAX_PATH ];

	Packlist   m_packlist;
	Patchlist  m_patchlist;

	/// Ŭ̾Ʈ  ִ ϵ Ʈ
	CBSTreeLinkedList m_compressedFileList; 
	CBSTreeLinkedList m_UnCompressedFileList;

	vector< Patchfile >  m_updateList;

	/// 
	unsigned int mNumPatchFiles;

	/// loader
	ClassDesc* m_libClassDesc;

public:
	static DWORD WINAPI LoaderProgressRoutine( DWORD totalFileSize, DWORD totalBytesTransferred, void* data );

};

inline
void cPatcher::Init( HWND wnd, HINSTANCE instance)
{
	assert( wnd );

	mWnd = wnd;
	mInstance = instance;

	//   .
	GetCurrentDirectory( sizeof(m_currentDirectory), m_currentDirectory );
	//strcpy( m_currentDirectory, "D:\\IrisOnline" );

	/// [12/9/2008 Jo] Dll ε
	m_libClassDesc = new Loader;
	if ( m_libClassDesc == NULL )
	{
		MessageBox( wnd, "LOADER Memory allocation Fail", "Error", MB_OK | MB_ICONERROR );
		PostMessage( wnd, WM_CLOSE, 0, 0 );
	}
}

inline
void cPatcher::SetProgressMax( ePatchStatus status, int max )
{
	if( mDlg != NULL )
		mDlg->SetProgressMax( status, max );
}

inline
void cPatcher::SetProgressPos( const char* fileName, int pos )
{
	if( mDlg != NULL )
		mDlg->SetProgressPos( fileName, pos );
}

inline
bool cPatcher::IsWorking() const
{
	return !mEndApp;
}

inline
bool cPatcher::IsEndIO() const
{
	return mEndIO;
}
