#include "stdafx.h"
#include "PatcherDlg.h"

#include "Patcher.h"
#include "skin/SkinResource.h"


BEGIN_MESSAGE_MAP( cPatcherDlg, cSkinDialog )
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED( CID_OK, OnOkButton )
	ON_BN_CLICKED( CID_CLOSE, OnCloseButton )
	ON_BN_CLICKED( CID_HOME, OnHomeButton )
	ON_BN_CLICKED( CID_JOIN, OnJoinButton )
	ON_MESSAGE(WM_USER_MESSAGE, OnUserMessage)
END_MESSAGE_MAP()


cPatcher* cPatcherDlg::mPatcher = 0;

cPatcherDlg::cPatcherDlg( const cString& path, const cString& hostName, const cString& baseDir, const cString& cmdLine, CWnd* parent )
: cSkinDialog( parent )
, mPath( path )
, mHostName( hostName )
, mBaseDir( baseDir )
, mCmdLine( cmdLine )
, mThread( 0 )
{
	mIcon = AfxGetApp()->LoadIcon( IDI_PATCHER_ICON );

	mBoardView = 0;

	mStatus = PATCH_SEARCHING;
}

cPatcherDlg::~cPatcherDlg()
{
	if( mPatcher )
	{
		delete mPatcher;
		mPatcher = 0;
	}
}



int cPatcherDlg::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
	lpCreateStruct->style |= WS_CLIPCHILDREN;

	if( cSkinDialog::OnCreate( lpCreateStruct ) == -1 )
		return -1;
	
	///  ŸƲ
	SetWindowText( "IrisPatcher" );

	/// Url  ε
	if( LoadUrl() == false )
	{
		MessageBox( "Failed to load url info", PATCHER );
		return -1;
	}

	///   ư
	mStartButton.Create( mResource->GetChild( "start" ), this, CID_OK );
	mStartButton.EnableWindow( 0 );

	///  ư
	mCloseButton.Create( mResource->GetChild( "close" ), this, CID_CLOSE );

	/// Ȩ ư
	mHomeButton.Create( mResource->GetChild( "home" ), this, CID_HOME );

	/// ȸ ư
	mJoinButton.Create( mResource->GetChild( "join" ), this, CID_JOIN );

	/// 
	mProgressBar.Create( mResource->GetChild( "probar" ), this, CID_PROGRESS );
	mProgressBar.SetValue( 0.0f );

	/// Խù 
	mBoardView = new cSkinHtmlView;
	mBoardView->Create( mResource->GetChild( "board" ), this, CID_BOARD );
	mBoardView->Go();

	RECT rc;
	rc.left = 21;
	rc.right = 128;
	rc.top = 394;
	rc.bottom = 408;

	mStatusStatic.Create( "", WS_CHILD | WS_VISIBLE | BS_OWNERDRAW, rc, this,  CID_STATUS );
	mStatusStatic.SetFont( &mFont );

	return 0;
}


BOOL cPatcherDlg::OnInitDialog()
{
	cSkinDialog::OnInitDialog();

	///  
	SetIcon( mIcon, 1 );
	SetIcon( mIcon, 0 );

	/// 带 
	mPatcher = new cPatcher( this );
	mPatcher->Init( GetSafeHwnd(), AfxGetInstanceHandle());
	BeginThread();

	return 1;
}

void cPatcherDlg::OnDestroy()
{
	/// ӽ ġ  
	//::FileRemove( PATCH_Z_FILENAME );


	//   
	if( mBoardView )
	{
		mBoardView->DestroyWindow();
	}

	cSkinDialog::OnDestroy();
}

void cPatcherDlg::OnPaint()
{
	if( IsIconic() )
	{
		CPaintDC dc( this );

		SendMessage( WM_ICONERASEBKGND, reinterpret_cast<WPARAM>( dc.GetSafeHdc() ), 0 );

		///  
		int cxIcon = GetSystemMetrics( SM_CXICON );
		int cyIcon = GetSystemMetrics( SM_CYICON );
		CRect rect;
		GetClientRect( &rect );
		int x = ( rect.Width() - cxIcon + 1 ) / 2;
		int y = ( rect.Height() - cyIcon + 1 ) / 2;

		dc.DrawIcon( x, y, mIcon );
	}
	else
	{
		cSkinDialog::OnPaint();
	}
}

HCURSOR cPatcherDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>( mIcon );
}

void cPatcherDlg::OnOK()
{
	static bool first = true;

	if( first == false )
		return;
	else
		first = false;

	if( mStartButton.IsWindowEnabled() )
	{
		// ɼ 
		//SaveOptInfo();

		//  
		RunGame();
		EndDialog( 0 );
		//cSkinDialog::OnOK();
	}
}

void cPatcherDlg::OnCancel()
{
	if( mThread )
	{
		DWORD ret = ::SuspendThread( mThread );
		assert( ret >= 0 );
		assert( mPatcher );

		mPatcher->StopWorking();
        ::ResumeThread( mThread );
		
		::Sleep( 0 );
		/// IO ۾    ٸ.
        while( mPatcher->IsEndIO() != true )
		{
			::Sleep( 0 );
			/// wait for IO END...
		}

		/// 尡   
		if( ::WaitForSingleObject( mThread, 5000 ) != WAIT_OBJECT_0 )
		{
			DWORD exitCode;
			::GetExitCodeThread( mThread, &exitCode );
			if ( exitCode == STILL_ACTIVE )
			{
				::TerminateThread( mThread, 0 );
			}
		}

		::CloseHandle( mThread );
		mThread = 0;
	}

	//if( mPatchStep == eSTEP_PATCH_COMPLETED )
	{
		cSkinDialog::OnCancel();
	}
}

void cPatcherDlg::OnOkButton()
{
	OnOK();
}

void cPatcherDlg::OnCloseButton()
{
	OnCancel();
}

void cPatcherDlg::OnHomeButton()
{
	ShellExecute( 0, 0, "Iexplore.exe", mUrlArray[URL_HOME].Cstr(), 0, SW_SHOWNORMAL );
}


void cPatcherDlg::OnJoinButton()
{
	ShellExecute( 0, 0, "Iexplore.exe", mUrlArray[URL_JOIN].Cstr(), 0, SW_SHOWNORMAL );
}

void cPatcherDlg::BeginThread()
{
	/// ̹ ۾ 尡 ִ ˻
	if( mThread != 0 )
	{
		MessageBox( "Thread is working.", PATCHER );
		return;
	}

	/// 带 
	DWORD threadId;
	mThread = ::CreateThread( 0, 0, ThreadProc, 0, 0, &threadId );

	if( mThread == 0 )
	{
		MessageBox( "Failed to create thread.", PATCHER );
		return;
	}
}

void cPatcherDlg::EndThread( bool result, bool updateSelf )
{
	if( updateSelf )
	{
		/// ó Ͽ ó ڽ ġ
		RunLauncher();
		EndDialog( 0 );

//		MessageBox( "ó Ʈ Ǿϴ. ٽ  Ͽ ֽʽÿ.", PATCHER );
//		RunLauncher();
//		EndDialog( 0 );

		return;
	}

	if( result )
	{
		///   غ
		mStartButton.EnableWindow( 1 );
		mProgressBar.SetValue( 1.0f );
		mProgressBar.Invalidate( 0 );

		mStatus = PATCH_COMPLETE;
	}

}

DWORD cPatcherDlg::ThreadProc( LPVOID /*param*/ )
{
	assert( mPatcher );
	return mPatcher->ThreadProc();
}

bool cPatcherDlg::LoadUrl()
{
	cString fileName = mPath;
	fileName += URLINFO_FILENAME;

	cFileLoader loader;
	if( loader.Open( fileName, true ) == false )
	{
		return false;
	}

	char temp[256];

	for( int i = 0; i < URL_COUNT; ++i )
	{
		if( loader.ReadLine( temp, 256 ) == 0 )
		{
			break;
		}
		mUrlArray[i] = temp;
	}
	return true;
}

bool cPatcherDlg::RunLauncher()
{
	//*
	STARTUPINFO	si;

	::memset( &si, 0, sizeof(STARTUPINFO) );
	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USEPOSITION | STARTF_USESIZE | STARTF_USESTDHANDLES;
	si.wShowWindow = SW_SHOW;

	PROCESS_INFORMATION pi;

	BOOL ret = ::CreateProcess( LAUNCHER_FILENAME,
		"-updatePatcher",
		0,
		0,
		0,
		CREATE_DEFAULT_ERROR_MODE | NORMAL_PRIORITY_CLASS,
		0,
		0,
		&si,
		&pi );

	if(ret == 0)
	{
		//MessageBox( "Failed to run launcher", PATCHER );
		return false;
	}

	::CloseHandle( pi.hProcess );
	::CloseHandle( pi.hThread );
	return true;
	//*/

	/*
	int ret = (int)::ShellExecute( 0, "open", LAUNCHER_FILENAME, "-updatePatcher", 0, SW_HIDE );

	if( ret <= 32 )
		return false;
	else
		return true;
	*/
}

bool cPatcherDlg::RunGame()
{
	/*
	STARTUPINFO	si;

	memset( &si, 0, sizeof(STARTUPINFO) );
	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USEPOSITION | STARTF_USESIZE | STARTF_USESTDHANDLES;
	si.wShowWindow = SW_SHOW;

	PROCESS_INFORMATION pi;

	BOOL ret = CreateProcess( GAMEEXE_FILENAME,
		"abc?",
		0,
		0,
		0,
		CREATE_DEFAULT_ERROR_MODE | NORMAL_PRIORITY_CLASS,
		0,
		0,
		&si,
		&pi );

	if( ret == 0 )
	{
		MessageBox( "Failed to run game", PATCHER );
		return false;
	}

	CloseHandle( pi.hProcess );
	CloseHandle( pi.hThread );
	*/

	cString path;
	path.Format( ".\\%s", GAMEEXE_FILENAME );
	int ret = (int)::ShellExecute( 0, "open", path.Cstr(), CMD_LINE, 0, SW_SHOWNORMAL );

	if( ret <= 32 )
	{
		MessageBox( "Failed to run game", PATCHER );
		return false;
	}
	return true;
}

void cPatcherDlg::SetProgressMax( ePatchStatus status, int max )
{
	mProgressTotalNum = max;
	mProgressBar.SetValue( 0.f );
	mProgressBar.Invalidate( 0 );

	SetStatus( status );
}

void cPatcherDlg::SetProgressPos( const char* /*fileName*/, int pos )
{
	float r = float(pos) / float(mProgressTotalNum);

	mProgressBar.SetValue( r );
	mProgressBar.Invalidate( 0 );

	SetStatus( PATCH_PATCHING );
}

void cPatcherDlg::SetStatus( ePatchStatus status )
{
	mStatus = status;

	cString out;
	switch( mStatus )
	{
	case PATCH_SEARCHING:
		out = mResource->GetText( 0 );
		break;
	case PATCH_PATCHING:
		{
			unsigned int v = unsigned int(mProgressBar.GetValue() * 100.0f);
			out.Format( mResource->GetText(1).Cstr(), v);
		}
		break;
	case PATCH_COMPLETE:
		out = mResource->GetText( 2 );
		break;
	}

	mStatusStatic.SetWindowText( out.Cstr() );

	RECT rc;
	rc.left = 21;
	rc.right = 128;
	rc.top = 394;
	rc.bottom = 408;
	InvalidateRect( &rc, 0 );
}

HBRUSH cPatcherDlg::OnCtlColor( CDC* pDC, CWnd* pWnd, UINT nCtlColor )
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	switch(nCtlColor)
	{
	case CTLCOLOR_STATIC:
		{
			pDC->SetTextColor(RGB(255, 255, 255));
			pDC->SetBkMode(TRANSPARENT);
			return hbr;
		}
	}
	return hbr;
}

LRESULT cPatcherDlg::OnUserMessage(WPARAM wParam, LPARAM lParam)
{
	if(mPatcher->IsWorking() == false)
		return 1;

	switch( wParam )
	{
	case _UMT_ERROR_INIT_ : 
		MessageBox("Init Error!", PATCHER, MB_OK );
		break;
	case _UMT_ERROR_SAVE_ : 
		MessageBox("Fail to save file!", PATCHER, MB_OK );
		break;
	case _UMT_ERROR_DOWNLOAD_:
		MessageBox("Fail to connect to patch server.", PATCHER, MB_OK );
		break;
	case _UMT_ERROR_PARSE_:
		MessageBox("Fail to parse server patch list file.", PATCHER, MB_OK );
		break;
	case _UMT_ERROR_MEMORY_ALLOC_:
		MessageBox( "Fail to allocation memory", PATCHER, MB_OK );
		break;
	case _UMT_ERROR_MEMORY_FREE_:
		MessageBox( "Fail to free memory", PATCHER, MB_OK );
		break;
	case _UMT_ERROR_UPDATE_:
		MessageBox( "Fail to Update", PATCHER, MB_OK );
		break;
	case _UMT_ERROR_SEARCH_:
		MessageBox( "Fail to Search", PATCHER, MB_OK );
		break;
	case _UMT_ERROR_CREATE_FOLDER_:
		MessageBox( "Fail to Create Folder", PATCHER, MB_OK );
		break;
	
	default : 
		MessageBox("Wrong Message");
		break;
	}

	PostMessage( WM_CLOSE, 0, 0 );

// 	LPVOID lpMsgBuf;
// 	FormatMessage( 
// 		FORMAT_MESSAGE_ALLOCATE_BUFFER|
// 		FORMAT_MESSAGE_FROM_SYSTEM,
// 		NULL, (DWORD)lParam,
// 		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
// 		(LPSTR)&lpMsgBuf, 0, NULL);
// 	MessageBox( (LPCSTR)lpMsgBuf, msg, MB_ICONERROR);
// 	LocalFree(lpMsgBuf);


	return 1;
}
