#include "stdafx.h"
#include "SkinResource.h"

cSkinDialogResource::cSkinDialogResource()
: mErrorTxt( "Error!" )
{
	/// Ʈ ʱȭ
	mFont.lfHeight = 12;
	mFont.lfWidth = 0;
	mFont.lfEscapement = 0;
	mFont.lfOrientation = 0;
	mFont.lfWeight = FW_NORMAL;
	mFont.lfItalic = 0;
	mFont.lfUnderline = 0;
	mFont.lfStrikeOut = 0;
	mFont.lfCharSet = DEFAULT_CHARSET;
	mFont.lfOutPrecision = OUT_DEFAULT_PRECIS;
	mFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	mFont.lfQuality = DEFAULT_QUALITY;
	mFont.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
	strcpy( mFont.lfFaceName, "" );
}

cSkinDialogResource::~cSkinDialogResource()
{
}

const cString& cSkinDialogResource::GetText( unsigned int id )
{
	cStringMap::cConstIterator i = mStringMap.Find( id );

	if( i == mStringMap.End() )
	{
		assert( 0 && "failed to find ui text" );
		return mErrorTxt;
	}
	else
		return i->mSecond;
}

bool cSkinDialogResource::Load( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
	{
		return false;
	}

	cString keyword;

	while( true )
	{
		if( parser.ParseString( &keyword ) == false )
		{
			return false;
		}

		if( keyword == "image" )
		{
			/// ̹ ε
			cString fileName;
			parser.ParseString( &fileName );

			if( LoadImage( &mBitmap, &mWidth, &mHeight, fileName ) == false )
			{
				return false;
			}
		}
		else if( keyword == "fontface" )
		{
			/// ü 
			cString fontFace;
			parser.ParseString( &fontFace );

			strcpy( mFont.lfFaceName, fontFace.Cstr() );
		}
		else if( keyword == "fontsize" )
		{
			///  ũ 
			mFont.lfHeight = parser.ParseInt();
		}
		else if( keyword == "dlgtext" )
		{
			if( LoadText( parser) == false )
				return false;
		}
		else if( keyword == "button" )
		{
			cString name;
			if( parser.ParseString( &name ) == false)
			{
				return false;
			}

			/// ư ҽ 
			cSkinButtonResource* p = new cSkinButtonResource;

			/// ε
			if( p->Load( parser ) )
			{
				/// Ʈ ҽ ʿ ߰
				mComponentResourceMap.Insert( name, (cSkinComponentResource*)p );
			}
			else
			{
				return false;
			}
		}
		else if( keyword == "progressbar" )
		{
			cString name;
			if( parser.ParseString( &name ) == false)
			{
				return false;
			}

			///  ҽ 
			cSkinProgressBarResource* p = new cSkinProgressBarResource;

			/// ε
			if( p->Load( parser ) )
			{
				/// Ʈ ҽ ʿ ߰
				mComponentResourceMap.Insert( name, (cSkinComponentResource*)p );
			}
			else
			{
				delete p;
				return false;
			}
		}
		//else if( keyword == "imageslide" )
		//{
		//	cString name;
		//	if( parser.ParseString( &name ) == false)
		//	{
		//		return false;
		//	}

		//	/// ̹ ̵ ҽ 
		//	cSkinImageSlideResource* p = new cSkinImageSlideResource;

		//	/// ε
		//	if( p->Load( parser ) )
		//	{
		//		/// Ʈ ҽ ʿ ߰
		//		mComponentResourceMap.Insert( name, (cSkinComponentResource*)p );
		//	}
		//	else
		//	{
		//		return false;
		//	}
		//}
		else if( keyword == "htmlview" )
		{
			cString name;
			if( parser.ParseString( &name ) == false)
			{
				return false;
			}

			/// Html  ҽ 
			cSkinHtmlViewResource* p = new cSkinHtmlViewResource;

			/// ε
			if( p->Load( parser ) )
			{
				/// Ʈ ҽ ʿ ߰
				mComponentResourceMap.Insert( name, (cSkinComponentResource*)p );
			}
			else
			{
				return false;
			}
		}
		else if( keyword == "}" )
		{
			///  Ż ^^
			break;
		}
		else
		{
			return false;
		}
	}
	return true;
}

bool cSkinDialogResource::LoadText( cParser& parser )
{
	if( parser.ExpectTokenString( "{" ) == false )
		return false;

	cString keyword;
	while( true )
	{
		parser.ParseString( &keyword );
		if( keyword == "txt" )
		{
			unsigned int key = parser.ParseInt();

			cString txt;
			parser.ParseString( &txt );

			if( mStringMap.Insert( key, txt.Cstr() ) == false )
				assert(0);
		}
		else if( keyword == "}" )
		{
			///  Ż ^^
			break;
		}
		else
		{
			return false;
		}
	}
	return true;
}
