/* ==========================================================================
*    : ̼
*    : 2006.09.19
* 
*      : Ų ҽ
* ǻ : 
*===========================================================================*/
#pragma once

#pragma warning( disable: 4244 )

#include <afxtempl.h>

class cSkinComponentResource;
class cSkinContainerResource;
class cSkinDialogResource;
class cSkinButtonResource;
class cSkinProgressBarResource;
class cSkinImageSlideResource;
class cSkinHtmlViewResource;
class cSkinManager;

/// Ų Ʈ ҽ
class cSkinComponentResource
{
	friend class cSkinManager;

public:
	cSkinComponentResource();
	virtual ~cSkinComponentResource();

public:
	/// Ʈ
	CBitmap mBitmap;

	/// 
	CRect mRect;

	/// ũ
	int mWidth;
	int mHeight;

protected:
	/// Ʈ  ε
	bool LoadImage( CBitmap* bitmap, int* width, int* height, const cString& fileName );

private:
	/// 
	static cString mPath;
};

/// Ų ̳ ҽ
class cSkinContainerResource : public cSkinComponentResource
{
public:
	cSkinContainerResource();
	virtual ~cSkinContainerResource();

	/// ε
	virtual bool Load( cParser& parser ) = 0;

	/// ڽ 
	cSkinComponentResource* GetChild( const cString& name );

public:
	/// Ʈ ҽ 
	typedef tHashMap<cString, cSkinComponentResource*> cComponentResourceMap;
	cComponentResourceMap mComponentResourceMap;
};

/// Ų ̾α ҽ
class cSkinDialogResource : public cSkinContainerResource
{
public:
	cSkinDialogResource();
	virtual ~cSkinDialogResource();

	/// ε
	virtual bool Load( cParser& parser );

	const cString& GetText( unsigned int id );

protected:
	bool LoadText( cParser& parser );

public:
	/// Ʈ
	LOGFONT mFont;

	typedef tHashMap<unsigned int, cString> cStringMap;
	cStringMap mStringMap;
	cString mErrorTxt;
};

/// Ų ư ҽ
class cSkinButtonResource : public cSkinComponentResource
{
public:
	cSkinButtonResource();
	virtual ~cSkinButtonResource();

	/// ε
	virtual bool Load( cParser& parser );

public:
	/// Ÿ (0 - Ǫ, 1 - üũ ڽ)
	int mStyle;
};

/// Ų  ҽ
class cSkinProgressBarResource : public cSkinComponentResource
{
public:
	cSkinProgressBarResource();
	virtual ~cSkinProgressBarResource();

	/// ε
	virtual bool Load( cParser& parser );

public:
	/// 
	COLORREF mColor;
	COLORREF mBackColor;
};

/// Ų   ҽ
class cSkinRoundGaugeResource : public cSkinComponentResource
{
public:
	cSkinRoundGaugeResource();
	virtual ~cSkinRoundGaugeResource();

	/// ε
	virtual bool Load( cParser& parser );

public:
	/// ȭǥ
	CBitmap mArrowBitmap;
	//CRect mArrowRect;
};

/// Ų ̹ ̵ ҽ
class cSkinImageSlideResource : public cSkinComponentResource
{
public:
	cSkinImageSlideResource();
	virtual ~cSkinImageSlideResource();

	/// ε
	virtual bool Load( cParser& parser );

public:
	/// Ʈ 迭
	CArray<CBitmap> mBitmapArray;
};

/// Ų Html  ҽ
class cSkinHtmlViewResource : public cSkinComponentResource
{
public:
	cSkinHtmlViewResource();
	virtual ~cSkinHtmlViewResource();

	/// ε
	virtual bool Load( cParser& parser );

public:
	/// Url
	cString mUrl;
};

/// Ų 
class cSkinManager
{
public:
	cSkinManager( const cString& path );
	~cSkinManager();

	/// ε
	bool Load( const cString& fileName );

	/// ̳ ҽ 
	cSkinContainerResource* GetContainer( const cString& name );

private:
	/// ̳ ҽ 
	typedef tHashMap<cString, cSkinContainerResource*> cContainerResourceMap;
	cContainerResourceMap mContainerResourceMap;
};
