#include "stdafx.h"

#include "MapDialog.h"
#include "Resource.h"
#include "RegenToolView.h"

IMPLEMENT_DYNAMIC(cMapDialog, CDialog)

BEGIN_MESSAGE_MAP(cMapDialog, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_MAP_LOAD, OnClickedLoad)
	ON_BN_CLICKED(IDC_CHECK_MAP_NAVIFIELD, OnCheckedButton)
END_MESSAGE_MAP()

cMapDialog::cMapDialog()
{
}

cMapDialog::~cMapDialog()
{
}

void cMapDialog::DoDataExchange( CDataExchange* dx )
{
	CDialog::DoDataExchange( dx );

	DDX_Control( dx, IDC_BUTTON_MAP_LOAD, mLoadButton );
}

BOOL cMapDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	mMapNum.Create( 1.0f, 1000.0f, 1.0f, 1.0f, this, IDC_EDIT_MAP_NUMBER );
	return TRUE;
}

void cMapDialog::OnClickedLoad()
{
	unsigned int mapIndex = (unsigned int)mMapNum.GetValue();
	cString str;
	str.Format( "Do you really want to load Map%02d?", mapIndex );
	int mb = MessageBox( str.Cstr(), "Map", MB_YESNO );

	if( mb == IDNO )
		return;

	if( VIEW->LoadMap( mapIndex ) == false )
		MessageBox( "Failed to load Map" );
}

void cMapDialog::OnCheckedButton()
{
	VIEW->Update();
}

bool cMapDialog::IsNaviFieldChecked() const
{
	CButton* check = (CButton*)GetDlgItem( IDC_CHECK_MAP_NAVIFIELD );
	return check->GetCheck() != 0;
}
