#include "stdafx.h"
#include "Monster.h"

#include "SceneManager.h"
#include "MonsterSceneNode.h"

cMonsterGroup::~cMonsterGroup()
{
	cNodeList::cIterator i = mNodeList.Begin();
	cNodeList::cIterator iend = mNodeList.End();

	for( ; i != iend; ++i )
	{
		cSceneNode* n = *i;

		///  ڿ 
		SCENEMAN->DestroyNode( n );
	}
}

void cMonsterGroup::RemoveNode( cMonsterSceneNode* node )
{
	assert( node );

	mNodeList.Remove( node );
}

bool cMonsterGroup::Save( cFileSaver& saver )
{
	if( mNodeList.IsEmpty() )
		return false;

	/// ε
	cString str;
	str.Format( "%d\r\n{\r\n", mIndex );
	saver.Write( str.Cstr(), str.GetSize() );

	/// ׷  
	str.Format( "\t%d\t%d\t%d\t%d\t%d\t%d\t%d\r\n", mFirstRegen, mRegenGroupIndex, mRegenPercent, mRegenRange, mRegenWaitTime, mMapGroupIndex, mChannelCheck );
	saver.Write( str.Cstr(), str.GetSize() );

	///   Ʈ
	cNodeList::cIterator i = mNodeList.Begin();
	cNodeList::cIterator iend = mNodeList.End();

	for( ; i != iend; ++i )
	{
		cMonsterSceneNode* n = *i;
		unsigned int index = n->GetUserData0();
		const NiPoint3& t = n->GetWorldTranslate();
		const NiMatrix3& r = n->GetWorldRotate();
		float xangle = 0.0f, yangle = 0.0f, zangle = 0.0f;
		r.ToEulerAnglesXYZ( xangle, yangle, zangle );

		str.Format( "\t%d\t%d\t%d\t%d\t%d\t%d\r\n", index, (unsigned int)t.x, (unsigned int)t.y, (unsigned int)D3DXToDegree(zangle), n->GetUserData1(), n->GetUserData3() );
		saver.Write( str.Cstr(), str.GetSize() );
	}

	///
	saver.Write( "}\r\n", 3 );
	return true;
}
