/* ==========================================================================
*    : ̼
*    : 2008.01.10
*      :  ̾α
* ǻ : 
*===========================================================================*/
#pragma once

#include "Button.h"
#include "NumericEdit.h"

#include "Resource.h"

class cMonsterInfo;
class cMonsterGroup;
class cMonsterSceneNode;

///  ̾α
class cMonsterDialog : public CDialog
{
	DECLARE_DYNAMIC(cMonsterDialog)

public:
	cMonsterDialog();
	~cMonsterDialog();

	///
	void Clear();

	///
	void SelectGroup( cMonsterGroup* group );
	void SelectNode( cMonsterSceneNode* node );

	/// Ÿ 
	void UpdateCombo( const tMap<unsigned int, cMonsterInfo*>& infoMap );
	void UpdateGroupList( const tMap<unsigned int, cMonsterGroup*>& groupMap );
	void UpdateList( const tList<cMonsterSceneNode*>& nodeList );
	void UpdateNodeTransform( const cMonsterSceneNode* node );

	/// Ȱȭ 
	void SetGroupEnabled( bool enabled );
	void SetEnabled( bool enabled );

	/// ġ
	NiPoint3 GetTranslate() const;

	/// ȸ
	float GetRotateAngle() const;

protected:
	virtual void DoDataExchange( CDataExchange* dx );
	BOOL OnInitDialog();

protected:
	afx_msg void OnClickedSave();
	afx_msg void OnClickedGroupCreate();
	afx_msg void OnClickedGroupDelete();
	afx_msg void OnSelchangeGroup();
	afx_msg void OnSelchangeGroupRegenIndex();
	afx_msg void OnCheckedGroupFirstRegen();
	afx_msg void OnCheckedChannelCheck();
	afx_msg void OnClickedCreate();
	afx_msg void OnClickedChange();
	afx_msg void OnClickedDelete();
	afx_msg void OnSelchangeNode();
	afx_msg LRESULT OnChangedNumber( WPARAM id, LPARAM );
	DECLARE_MESSAGE_MAP()

private:
	cButton mSaveButton;

	///  ׷
	cNumericEdit mGroupIndexNum;
	cNumericEdit mMapGroupIndex;
	cButton mGroupCreateButton;
	cButton mGroupDeleteButton;
	cNumericEdit mGroupRegenPercentNum;
	cNumericEdit mGroupRegenRangeNum;
	cNumericEdit mGroupRegenWaitTimeNum;

	cMonsterGroup* mSelMonsterGroup;

	/// 
	cButton mCreateButton;
	cButton mChangeButton;
	cButton mDeleteButton;
	cNumericEdit mTxNum;
	cNumericEdit mTyNum;
	cNumericEdit mRzNum;
	cNumericEdit mRegenWaitTimeNum;
	cNumericEdit mRegenLifeTimeNum;

	cMonsterSceneNode* mSelMonster;
};

inline
void cMonsterDialog::SetGroupEnabled( bool enabled )
{
	if( enabled )
	{
		mMapGroupIndex.SetEnabled( true );
		mGroupRegenPercentNum.SetEnabled( true );
		mGroupRegenRangeNum.SetEnabled( true );
		mGroupRegenWaitTimeNum.SetEnabled( true );
	}
	else
	{
		mMapGroupIndex.SetEnabled( false );
		mGroupRegenPercentNum.SetEnabled( false );
		mGroupRegenRangeNum.SetEnabled( false );
		mGroupRegenWaitTimeNum.SetEnabled( false );
	}
}

inline
void cMonsterDialog::SetEnabled( bool enabled )
{
	if( enabled )
	{
		mTxNum.SetEnabled( true );
		mTyNum.SetEnabled( true );
		mRzNum.SetEnabled( true );
		mRegenWaitTimeNum.SetEnabled( true );
		mRegenLifeTimeNum.SetEnabled( true );
	}
	else
	{
		GetDlgItem(IDC_EDIT_MONSTER_INDEX)->SetWindowText( "" );
		GetDlgItem(IDC_EDIT_MONSTER_NAME)->SetWindowText( "" );
		GetDlgItem(IDC_EDIT_MONSTER_MODEL)->SetWindowText( "" );

		///
		mTxNum.SetEnabled( false );
		mTyNum.SetEnabled( false );
		mRzNum.SetEnabled( false );
		mRegenWaitTimeNum.SetEnabled( false );
		mRegenLifeTimeNum.SetEnabled( false );
	}
}

inline
NiPoint3 cMonsterDialog::GetTranslate() const
{
	float x = mTxNum.GetValue() * 100;
	float y = mTyNum.GetValue() * 100;
	return NiPoint3( x, y, 0.0f );
}

inline
float cMonsterDialog::GetRotateAngle() const
{
	return D3DXToRadian( mRzNum.GetValue() );
}
