/* ==========================================================================
*    : ̼
*    : 2008.01.10
*      : Npc ̾α
* ǻ : 
*===========================================================================*/
#pragma once

#include "Button.h"
#include "NumericEdit.h"

#include "Resource.h"

class cNpcInfo;
class cNpcSceneNode;

/// Npc ̾α
class cNpcDialog : public CDialog
{
	DECLARE_DYNAMIC(cNpcDialog)

public:
	cNpcDialog();
	~cNpcDialog();

	void SelectNode( cNpcSceneNode* node );

	/// Ÿ 
	void UpdateCombo( const tMap<unsigned int, cNpcInfo*>& infoMap );
	void UpdateList( const tMap<unsigned int, cNpcSceneNode*>& nodeMap );
	void UpdateNodeTransform( cNpcSceneNode* node );

	/// Ȱȭ 
	void SetEnabled( bool enabled );

	/// ġ
	NiPoint3 GetTranslate() const;

	/// ȸ
	float GetRotateAngle() const;

protected:
	virtual void DoDataExchange( CDataExchange* dx );
	BOOL OnInitDialog();

protected:
	afx_msg void OnClickedSave();
	afx_msg void OnClickedCreate();
	afx_msg void OnClickedChange();
	afx_msg void OnClickedDelete();
	afx_msg void OnSelchangeNode();
	afx_msg LRESULT OnChangedNumber( WPARAM id, LPARAM );
	DECLARE_MESSAGE_MAP()

private:
	cButton mSaveButton;
	cButton mCreateButton;
	cButton mChangeButton;
	cButton mDeleteButton;
	
	/// ̵
	cNumericEdit mTxNum;
	cNumericEdit mTyNum;

	/// ȸ
	cNumericEdit mRzNum;
};

inline
void cNpcDialog::SetEnabled( bool enabled )
{
	if( enabled )
	{
		mTxNum.SetEnabled( true );
		mTyNum.SetEnabled( true );
		mRzNum.SetEnabled( true );
	}
	else
	{
		GetDlgItem(IDC_EDIT_NPC_INDEX)->SetWindowText( "" );
		GetDlgItem(IDC_EDIT_NPC_NAME)->SetWindowText( "" );
		GetDlgItem(IDC_EDIT_NPC_MODEL)->SetWindowText( "" );

		///
		mTxNum.SetValue( 0.0f );
		mTyNum.SetValue( 0.0f );
		mRzNum.SetValue( 0.0f );

		mTxNum.SetEnabled( false );
		mTyNum.SetEnabled( false );
		mRzNum.SetEnabled( false );
	}
}

inline
NiPoint3 cNpcDialog::GetTranslate() const
{
	float x = mTxNum.GetValue() * 100;
	float y = mTyNum.GetValue() * 100;
	return NiPoint3( x, y, 0.0f );
}

inline
float cNpcDialog::GetRotateAngle() const
{
	return D3DXToRadian( mRzNum.GetValue() );
}
