/* ==========================================================================
*    : ̼
*    : 2008.01.24
*      : Ż ̾α
* ǻ : 
*===========================================================================*/
#pragma once

#include "Button.h"
#include "NumericEdit.h"

#include "Resource.h"

class cPortalInfo;
class cPortalSceneNode;

/// Ż ̾α
class cPortalDialog : public CDialog
{
	DECLARE_DYNAMIC(cPortalDialog)

public:
	cPortalDialog();
	~cPortalDialog();

	void SelectNode( cPortalSceneNode* node );

	/// Ÿ 
	void UpdateList( const tMap<unsigned int, cPortalInfo*>& infoMap );
	void UpdateNodeTransform( cPortalSceneNode* node );

	/// Ȱȭ 
	void SetEnabled( bool enabled );

	/// ġ
	NiPoint3 GetTranslate() const;

	/// ȸ
	float GetRotateAngle() const;

protected:
	virtual void DoDataExchange( CDataExchange* dx );
	BOOL OnInitDialog();

protected:
	afx_msg void OnClickedSave();
	afx_msg void OnClickedCreate();
	afx_msg void OnClickedDelete();
	afx_msg void OnSelchangeNode();
	afx_msg void OnSelchangeTargetIndex();
	afx_msg LRESULT OnChangedNumber( WPARAM id, LPARAM );
	DECLARE_MESSAGE_MAP()

private:
	cButton mSaveButton;
	cButton mCreateButton;
	cButton mDeleteButton;
	
	/// ε
	cNumericEdit mIndexNum;

	/// 
	cNumericEdit mRangeNum;

	/// ̵
	cNumericEdit mTxNum;
	cNumericEdit mTyNum;

	/// ȸ
	cNumericEdit mRzNum;

	///
	cPortalInfo* mSelInfo;
};

inline
void cPortalDialog::SetEnabled( bool enabled )
{
	if( enabled )
	{
		mRangeNum.SetEnabled( true );
		mTxNum.SetEnabled( true );
		mTyNum.SetEnabled( true );
		mRzNum.SetEnabled( true );
	}
	else
	{
		GetDlgItem(IDC_EDIT_PORTAL_INDEX)->SetWindowText( "" );

		mRangeNum.SetEnabled( false );
		mTxNum.SetEnabled( false );
		mTyNum.SetEnabled( false );
		mRzNum.SetEnabled( false );
	}
}

inline
NiPoint3 cPortalDialog::GetTranslate() const
{
	float x = mTxNum.GetValue() * 100;
	float y = mTyNum.GetValue() * 100;
	return NiPoint3( x, y, 0.0f );
}

inline
float cPortalDialog::GetRotateAngle() const
{
	return D3DXToRadian( mRzNum.GetValue() );
}
