#include "stdafx.h"
#include "RegenToolApp.h"

#include "MainFrame.h"
#include "RegenToolView.h"
#include "Application.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

cRegenToolApp theApp;

BEGIN_MESSAGE_MAP(cRegenToolApp, CWinApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
END_MESSAGE_MAP()

cRegenToolApp::cRegenToolApp()
{
	mMutexHandle = NULL;
}

cRegenToolApp::~cRegenToolApp()
{
	if( mMutexHandle )
		::CloseHandle(mMutexHandle);
}

BOOL cRegenToolApp::InitInstance()
{
	/// α׷ ߺ  
	if( CheckMutex() == false )
	{
		return FALSE;
	}

	///   θ  丮 
	TCHAR exePathName[MAX_PATH];
	::GetModuleFileName( AfxGetApp()->m_hInstance, exePathName, MAX_PATH );

	cString exePath = exePathName;
	GetFilePath( &exePath, exePath );

	SetCurrentDirectory( exePath.Cstr() );
	mBaseDir = exePath;

	//  α׷ Ŵ佺Ʈ ComCtl32.dll  6 ̻ Ͽ ־ Ÿ
	// ϵ ϴ , Windows XP 󿡼 ݵ InitCommonControls() ʿմϴ. 
	// InitCommonControls()   â   ϴ.
	InitCommonControls();

	if( CWinApp::InitInstance() == FALSE )
		return FALSE;

	//// OLE ̺귯 ʱȭ
	//if(!AfxOleInit())
	//{
	//	AfxMessageBox(IDP_OLE_INIT_FAILED);
	//	return FALSE;
	//}
	//AfxEnableControlContainer();

	// Ÿ̸ ʱȭ: Ƽ̵ Ÿ̸ ػ󵵸 1000 1 
	timeBeginPeriod(1);

	///  
	cMainFrame* frame = new cMainFrame;
	if( frame == 0)
		return FALSE;
	m_pMainWnd = frame;

	//   ҽ Բ εմϴ.
	if( frame->LoadFrame( IDR_MAINFRAME ) == 0 )
		return FALSE;

	// â ϳ ʱȭǾǷ ̸ ǥϰ Ʈմϴ.
	frame->ShowWindow( SW_SHOW );
	frame->UpdateWindow();
	return TRUE;
}

bool cRegenToolApp::CheckMutex()
{
	/// ؽ 
	mMutexHandle = ::CreateMutex( 0, TRUE, "Iris RegenTool Mutex" );
	unsigned long err = ::GetLastError();
	if( err != ERROR_SUCCESS )
	{
		NiMessageBox( "RegenTool already running...", "Error Info" );
		return false;
	}
	return true;
}

BOOL cRegenToolApp::OnIdle( LONG count )
{
	if( VIEW == m_pMainWnd->GetFocus() )
	{
		VIEW->Update();
		return TRUE;
	}
	else
	{
		return CWinApp::OnIdle(count);
	}
}

class cAboutDialog : public CDialog
{
public:
	cAboutDialog();

	enum { IDD = IDD_ABOUTBOX };
};

cAboutDialog::cAboutDialog()
: CDialog(cAboutDialog::IDD)
{
}

void cRegenToolApp::OnAppAbout()
{
	cAboutDialog aboutDlg;
	aboutDlg.DoModal();
}
