/* ==========================================================================
*    : ̼
*    : 2006.12.02
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

#include "Npc.h"
#include "Monster.h"
#include "Portal.h"
#include "Gathering.h"

class cMapDialog;
class cNpcDialog;
class cMonsterDialog;
class cPortalDialog;
class cGatheringDialog;
class cCircleLines;

class cApplication;
class cCamera;
class cFreeCamera;
class cNaviMesh;
class cNaviField;
class cSceneNode;
class cNpcSceneNode;
class cMonsterSceneNode;
class cMonsterGroup;
class cPortalSceneNode;
class cGatheringSceneNode;

///  
//enum eEditMode
//{
//	eEDIT_NULL = -1,
//	eEDIT_NPC = 0,
//	eEDIT_PORTAL,
//	eEDIT_MONSTER,
//	eEDIT_MAX_MODES
//};

///  
class cRegenToolView : public CView
{
	static cRegenToolView* mSingleton;
	DECLARE_DYNCREATE( cRegenToolView )

public:
	cRegenToolView();
	virtual ~cRegenToolView();

	/// 
	void Clear();

	/// ʱȭ
	void Init();

	/// 
	void Update();

	/// ȭ ũ
	void Resize( unsigned int width, unsigned int height );

	/// 
	void RenderLines();

	/// ε
	bool LoadModelFileList();
	bool LoadNpcNameList();
	bool LoadNpcList();
	bool LoadMonsterNameList();
	bool LoadMonsterList();
	bool LoadMap( unsigned int mapIndex );
	bool LoadNpcRegen( unsigned int mapIndex );
	bool LoadMonsterRegen( unsigned int mapIndex );
	bool LoadPortalRegen();
	bool LoadGatheringNameList();
	bool LoadGatheringList();
	bool LoadGatheringRegen( unsigned int mapIndex );

	/// ̾α
	void SetMapDialog( cMapDialog* dlg );
	void SetNpcDialog( cNpcDialog* dlg );
	void SetMonsterDialog( cMonsterDialog* dlg );
	void SetPortalDialog( cPortalDialog* dlg );
	void SetGatheringDialog( cGatheringDialog* dlg );

	///  
	//void SetEditMode( eEditMode mode );
	//eEditMode GetEditMode() const;

	/// ī޶
	void SetCamFarDistance( float farDist );
	float GetCamFarDistance() const;
	void ZoomPersp();
	void ZoomOrtho();

	///  
	void SelectNode( cSceneNode* node, bool updateView = true );
	void DeleteSel();
	void SetSelTranslate( NiPoint3 trans, bool updateDialog = false );
	void SetSelRotate( float zangle, bool updateDialog = false );
	void SetSelAppendZ( float appendZ, bool updateDialog = false );
	cSceneNode* GetSelNode() const;
	NiPoint3 GetSelTranslate() const;
	float GetSelRotate() const;
	float GetSelAppendZ() const;

	///  
	const cString& GetModelFile( unsigned int modelIndex ) const;

	/// Npc
	bool SaveNpcRegen();

	int CreateNpc( unsigned int index, float x, float y, float zdegree, bool updateDialog, bool updateView );
	int ChangeNpc( unsigned int index );
	int DeleteNpc( cNpcSceneNode* node );
	void SelectNpc( cNpcSceneNode* node );
	const cNpcInfo* GetNpcInfo( unsigned int index ) const;
	const cString& GetNpcNameByNameIndex( unsigned int nameIndex ) const;
	const cString& GetNpcNameByNpcIndex( unsigned int npcIndex ) const;

	/// 
	bool SaveMonsterRegen();

	int CreateMonsterGroup( unsigned int index );
	int DeleteMonsterGroup( unsigned int index );
	void SelectMonsterGroup( cMonsterGroup* group );

	int CreateMonster( unsigned int index, unsigned int x, unsigned int y, int zdegree, unsigned int regenWaitTime, unsigned int regenLifeTime, bool updateDialog, bool updateView );
	int ChangeMonster( unsigned int index );
	int DeleteMonster( cMonsterSceneNode* node );
	void SelectMonster( cMonsterSceneNode* node );
	const cMonsterInfo* GetMonsterInfo( unsigned int index ) const;
	const cString& GetMonsterNameByNameIndex( unsigned int nameIndex ) const;
	const cString& GetMonsterNameByMonIndex( unsigned int monIndex ) const;

	/// Ż
	bool SavePortalRegen();

	int CreatePortal( unsigned int index, const char* potalName, float x, float y, unsigned int range, unsigned int targetIndex, int zdegree, bool updateDialog, bool updateView );
	int DeletePortal( cPortalSceneNode* node );
	void SelectPortal( cPortalSceneNode* node );
	cPortalInfo* GetPortalInfo( unsigned int index ) const;

	/// ä
	bool SaveGatheringRegen();

	int CreateGatheringGroup( unsigned int index );
	int DeleteGatheringGroup( unsigned int index );
	void SelectGatheringGroup( cGatheringGroup* group );

	int CreateGathering( unsigned int index, unsigned int x, unsigned int y, int zdegree, float appandZ, bool updateDialog, bool updateView );
	int ChangeGathering( unsigned int index );
	int DeleteGathering( cGatheringSceneNode* node );
	void SelectGathering( cGatheringSceneNode* node );

	const cGatheringInfo* GetGatheringInfo( unsigned int index ) const;
	const cString& GetGatheringNameByNameIndex( unsigned int nameIndex ) const;
	const cString& GetGatheringNameByGatherIndex( unsigned int gatherIndex ) const;

protected:
	BOOL PreCreateWindow( CREATESTRUCT& cs );
	void OnDraw( CDC* dc );

public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump( CDumpContext& dc ) const;
#endif

protected:
	afx_msg int OnCreate( LPCREATESTRUCT cs );
	afx_msg void OnDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* dc);
	afx_msg void OnSize( UINT type, int cx, int cy );
	afx_msg void OnTimer( UINT_PTR nIDEvent );
	afx_msg void OnMouseMove( UINT flags, CPoint point );
	afx_msg BOOL OnMouseWheel( UINT flags, short zdelta, CPoint point );
	afx_msg void OnLButtonDown( UINT flags, CPoint point );
	afx_msg void OnLButtonUp( UINT flags, CPoint point );
	afx_msg void OnRButtonDown( UINT flags, CPoint point );
	afx_msg void OnRButtonUp( UINT flags, CPoint point );
	afx_msg void OnMButtonDown( UINT flags, CPoint point );
	afx_msg void OnMButtonUp( UINT flags, CPoint point );
	afx_msg void OnKeyDown(UINT c, UINT repeats, UINT flags);
	afx_msg void OnKeyUp(UINT c, UINT repeats, UINT flags);
	DECLARE_MESSAGE_MAP()

public:
	/// ü 
	static cRegenToolView* GetSingleton();

private:
	/// ø̼
	cApplication* mApplication;

	/// ׺޽
	cNaviMesh* mNaviMesh;

	/// ׺ʵ
	cNaviField* mNaviField;

	/// ̾α
	cMapDialog* mMapDialog;
	cNpcDialog* mNpcDialog;
	cMonsterDialog* mMonsterDialog;
	cPortalDialog* mPortalDialog;
	cGatheringDialog* mGatheringDialog;

	///  
	//eEditMode mEditMode;

	/// ī޶
	cFreeCamera* mCamera;

	/// 
	cString mErrorModelFile;

	typedef tMap<unsigned int, cString> cModelFileMap;
	cModelFileMap mModelFileMap;

	/// 
	unsigned int mMapIndex;

	/// Npc
	cString mErrorNpcName;

	typedef tMap<unsigned int, cString> cNpcNameMap;
	cNpcNameMap mNpcNameMap;

	typedef tMap<unsigned int, cNpcInfo*> cNpcInfoMap;
	cNpcInfoMap mNpcInfoMap;

	typedef tMap<unsigned int, cNpcSceneNode*> cNpcNodeMap;
	cNpcNodeMap mNpcNodeMap;

	/// 
	cMonsterGroup* mSelMonsterGroup;
	cString mErrorMonsterName;

	typedef tMap<unsigned int, cString> cMonsterNameMap;
	cMonsterNameMap mMonsterNameMap;

	typedef tMap<unsigned int, cMonsterInfo*> cMonsterInfoMap;
	cMonsterInfoMap mMonsterInfoMap;

	typedef tMap<unsigned int, cMonsterGroup*> cMonsterGroupMap;
	cMonsterGroupMap mMonsterGroupMap;

	typedef tList<cMonsterSceneNode*> cMonsterList;

	/// ä ü
	cGatheringGroup* mSelGatheringGroup;
	cString mErrorGatheringName;

	typedef tMap<unsigned int, cString> cGatheringNameMap;
	cGatheringNameMap mGatheringNameMap;

	typedef tMap<unsigned int, cGatheringInfo*> cGatheringInfoMap;
	cGatheringInfoMap mGatheringInfoMap;

	typedef tMap<unsigned int, cGatheringGroup*> cGatheringGroupMap;
	cGatheringGroupMap mGatheringGroupMap;

	typedef tList<cGatheringSceneNode*> cGatheringList;

	/// Ż
	typedef tMap<unsigned int, cPortalInfo*> cPortalInfoMap;
	cPortalInfoMap mPortalInfoMap;

	cMonsterSceneNode* mDummyNode;

	/// 콺 ǥ
	CPoint mMousePos;

	/// ŷ   迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;

	/// õ 
	cSceneNode* mSelNode;
	cCircleLines* mSelLines;
	cCircleLines* mGroupLines;
};

inline
void cRegenToolView::SetMapDialog( cMapDialog* dlg )
{
	assert( dlg );

	mMapDialog = dlg;
}

inline
void cRegenToolView::SetNpcDialog( cNpcDialog* dlg )
{
	assert( dlg );

	mNpcDialog = dlg;
}

inline
void cRegenToolView::SetMonsterDialog( cMonsterDialog* dlg )
{
	assert( dlg );

	mMonsterDialog = dlg;
}

inline
void cRegenToolView::SetPortalDialog( cPortalDialog* dlg )
{
	assert( dlg );

	mPortalDialog = dlg;
}

inline
void cRegenToolView::SetGatheringDialog( cGatheringDialog* dlg )
{
	assert( dlg );

	mGatheringDialog = dlg;
}

inline
cSceneNode* cRegenToolView::GetSelNode() const
{
	return mSelNode;
}

//inline
//eEditMode cRegenToolView::GetEditMode() const
//{
//	return mEditMode;
//}
//
//inline
//cFreeCamera* cRegenToolView::GetDefaultCamera() const
//{
//	return mCamera;
//}

inline
cRegenToolView* cRegenToolView::GetSingleton()
{
	return mSingleton;
}

#define VIEW cRegenToolView::GetSingleton()
