#include "stdafx.h"
#include "RegenToolView.h"

#include "RegenToolApp.h"
#include "NpcDialog.h"
#include "MonsterDialog.h"
#include "PortalDialog.h"
#include "GatheringDialog.h"

#include "Terrain.h"
#include "NaviMesh.h"
#include "NaviField.h"
#include "SceneManager.h"
#include "MonsterSceneNode.h"
#include "GatheringSceneNode.h"

#define NPC_REGEN		"Script/Resource/NpcRegen"
#define MONSTER_REGEN	"Script/Resource/MonsterRegen"
#define GATHERING_REGEN	"script/resource/gatheringregen"

const char* MDL_FILE_LIST_TXT = "Script/Resource/ModelFileList.txt";
const char* NPC_NAME_LIST_TXT = "Script/Language/Npc_Name.txt";
const char* NPC_LIST_TXT = "Script/Resource/NpcList.txt";
const char* MONSTER_NAME_LIST_TXT = "Script/Language/Mon_Name.txt";
const char* MONSTER_LIST_TXT = "Script/Resource/MonsterList.txt";
const char* GATHERING_NAME_LIST_TXT = "Script/Language/gatheringname.txt";
const char* GATHERING_LIST_TXT = "Script/Resource/gatheringlist.txt";
const char* PORTAL_LIST_TXT = "Script/Resource/MapChangePos.txt";

bool cRegenToolView::LoadModelFileList()
{
	mModelFileMap.Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cFileLoader loader;

	if( loader.Open( MDL_FILE_LIST_TXT, true ) == false )
	{
		MessageBox( "Failed to open model file list.", "Init" );
		return false;
	}

	/// Ľ
	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", MDL_FILE_LIST_TXT );
	unsigned int index;
	cString str;

	while( tok.IsEnd() == false )
	{
		///  ε
		tok.GetNext( &str );
		index = str.ToInt();

		///  
		str.Clear();
		tok.GetNext( &str );

		if( str.IsEmpty() )
			continue;

		///
		cModelFileMap::cIterator i = mModelFileMap.Find( index );

		if( i != mModelFileMap.End() )
			continue;

		mModelFileMap.Insert( index, str );
	}
	return true;
}

bool cRegenToolView::LoadNpcNameList()
{
	mNpcNameMap.Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cFileLoader loader;

	if( loader.Open( NPC_NAME_LIST_TXT, true ) == false )
	{
		MessageBox( "Failed to open npc name list.", "Init" );
		return false;
	}

	/// Ľ
	cLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, NPC_NAME_LIST_TXT );
	unsigned int index;
	cString str;

	while( lexer.IsEnd() == false )
	{
		/// Npc ε
		index = parser.ParseInt();

		/// Npc ̸
		str = parser.ParseString();

		if( str.IsEmpty() )
			continue;

		///
		cNpcNameMap::cIterator i = mNpcNameMap.Find( index );

		if( i != mNpcNameMap.End() )
			continue;

		mNpcNameMap.Insert( index, str );
	}
	return true;
}

bool cRegenToolView::LoadNpcList()
{
	mNpcInfoMap.Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cFileLoader loader;

	if( loader.Open( NPC_LIST_TXT, true ) == false )
	{
		MessageBox( "Failed to open npc list.", "Init" );
		return false;
	}

	/// Ľ
	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", NPC_LIST_TXT );
	cString str;

	while( tok.IsEnd() == false )
	{
		/// ε
		tok.GetNext( &str );
		unsigned int index = str.ToInt();

		/// ̸ ε
		tok.GetNext( &str );
		unsigned int nameIndex = str.ToInt();
		cNpcNameMap::cIterator ni = mNpcNameMap.Find( nameIndex );

		if( ni == mNpcNameMap.End() )
		{
			MessageBox( "Can't find npc name index.", "Npc List" );
			return false;
		}

		///  ε
		tok.GetNext( &str );
		unsigned int jobIndex = str.ToInt();
		jobIndex;

		///  ε
		tok.GetNext( &str );
		unsigned int modelIndex = str.ToInt();
		cModelFileMap::cIterator mi = mModelFileMap.Find( modelIndex );

		if( mi == mModelFileMap.End() )
		{
			MessageBox( "Can't find model index.", "Npc List" );
			return false;
		}

		/// ٳѱ
		tok.GotoNextLine();

		///  ʿ ߰
		mNpcInfoMap.Insert( index, new cNpcInfo(nameIndex, modelIndex) );
	}

	assert( mNpcDialog );
	mNpcDialog->UpdateCombo( mNpcInfoMap );
	return true;
}

bool cRegenToolView::LoadMonsterNameList()
{
	mMonsterNameMap.Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cFileLoader loader;

	if( loader.Open( MONSTER_NAME_LIST_TXT, true ) == false )
	{
		MessageBox( "Failed to open monster name list.", "Init" );
		return false;
	}

	/// Ľ
	cLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, MONSTER_NAME_LIST_TXT );
	unsigned int index;
	cString str;

	while( lexer.IsEnd() == false )
	{
		///  ε
		index = parser.ParseInt();

		///  ̸
		str = parser.ParseString();

		if( str.IsEmpty() )
			continue;

		///
		cMonsterNameMap::cIterator i = mMonsterNameMap.Find( index );

		if( i != mMonsterNameMap.End() )
			continue;

		mMonsterNameMap.Insert( index, str );
	}
	return true;
}

bool cRegenToolView::LoadMonsterList()
{
	mMonsterInfoMap.Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cFileLoader loader;

	if( loader.Open( MONSTER_LIST_TXT, true ) == false )
	{
		MessageBox( "Failed to open monster list.", "Init" );
		return false;
	}

	/// Ľ
	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", MONSTER_LIST_TXT );
	cString str;

	while( tok.IsEnd() == false )
	{
		/// ε
		tok.GetNext( &str );
		unsigned int index = str.ToInt();

		/// ̸ ε
		tok.GetNext( &str );
		unsigned int nameIndex = str.ToInt();
		cMonsterNameMap::cIterator ni = mMonsterNameMap.Find( nameIndex );

		if( ni == mMonsterNameMap.End() )
		{
			MessageBox( "Can't find monster name index.", "Monster List" );
			return false;
		}

		///  ε
		tok.GetNext( &str );
		unsigned int modelIndex = str.ToInt();
		cModelFileMap::cIterator mi = mModelFileMap.Find( modelIndex );

		if( mi == mModelFileMap.End() )
		{
			MessageBox( "Can't find model index.", "Monster List" );
			return false;
		}

		/// ٳѱ
		tok.GotoNextLine();

		///  ʿ ߰
		mMonsterInfoMap.Insert( index, new cMonsterInfo(nameIndex, modelIndex) );
	}

	assert( mMonsterDialog );
	mMonsterDialog->UpdateCombo( mMonsterInfoMap );
	return true;
}

bool cRegenToolView::LoadGatheringNameList()
{
	mGatheringNameMap.Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cFileLoader loader;

	if( loader.Open( GATHERING_NAME_LIST_TXT, true ) == false )
	{
		MessageBox( "Failed to open gathering name list.", "Init" );
		return false;
	}

	/// Ľ
	cLexer lexer( loader.GetBufferPtr(), loader.GetSize() );
	cParser parser( &lexer, GATHERING_NAME_LIST_TXT );
	unsigned int index;
	cString str;

	while( lexer.IsEnd() == false )
	{
		/// ä ü ε
		index = parser.ParseInt();

		/// ä ü ̸
		str = parser.ParseString();

		if( str.IsEmpty() )
			continue;

		///
		cGatheringNameMap::cIterator i = mGatheringNameMap.Find( index );

		if( i != mGatheringNameMap.End() )
			continue;

		mGatheringNameMap.Insert( index, str );
	}

	return true;
}

bool cRegenToolView::LoadGatheringList()
{
	mGatheringInfoMap.Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cFileLoader loader;

	if( loader.Open( GATHERING_LIST_TXT, true ) == false )
	{
		MessageBox( "Failed to open gathering list.", "Init" );
		return false;
	}

	/// Ľ
	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", GATHERING_LIST_TXT );
	cString str;

	while( tok.IsEnd() == false )
	{
		/// ε
		tok.GetNext( &str );
		unsigned int index = str.ToInt();

		/// ̸ ε
		tok.GetNext( &str );
		unsigned int nameIndex = str.ToInt();
		cMonsterNameMap::cIterator ni = mGatheringNameMap.Find( nameIndex );

		if( ni == mGatheringNameMap.End() )
		{
			MessageBox( "Can't find gathering name index.", "Gathering List" );
			return false;
		}

		/// 
		tok.GetNext( &str );

		///  ε
		tok.GetNext( &str );
		cString fileName = str;

		/// ٳѱ
		tok.GotoNextLine();

		///  ʿ ߰
		mGatheringInfoMap.Insert( index, new cGatheringInfo(nameIndex, fileName) );
	}

	assert( mGatheringDialog );
	mGatheringDialog->UpdateCombo( mGatheringInfoMap );
	return true;
}

bool cRegenToolView::LoadMap( unsigned int mapIndex )
{
	///
	Clear();
	mNpcDialog->EnableWindow( 0 );
	mMonsterDialog->EnableWindow( 0 );
	mPortalDialog->EnableWindow( 0 );
	mGatheringDialog->EnableWindow( 0 );

	///  θ 
//	cString path;
//	path.Format( "%sMap/Map%02d/", theApp.GetBaseDir().Cstr(), mapIndex );
//	SetCurrentDirectory( path.Cstr() );

	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  ε
	cString pathName;
	pathName.Format( "./Map/Map%02d/%03d.terrain", mapIndex, mapIndex );

	if( TERRAIN->Load( pathName, mapIndex ) == false )
		return false;

	/// ׺޽ø ε
	pathName.Format( "./Map/Map%02d/%03d.navimesh", mapIndex, mapIndex );

	if( mNaviMesh->Load( pathName ) == false )
		return false;

	/// ׺ʵ带 ε
	pathName.Format( "./Map/Map%02d/%03d.navifield", mapIndex, mapIndex );

	if( mNaviField->Load( pathName ) == false )
		return false;

	///  ε
	pathName.Format( "./Map/Map%02d/%03d.scene", mapIndex, mapIndex );

	if( SCENEMAN->Load( pathName, mapIndex ) == false )
		return false;

	/// Ȱ 
	TERRAIN->SetFog( true, NiColor::WHITE, 0.1f );
	SCENEMAN->SetFog( true, NiColor::WHITE, 0.1f );

	/// 
	ZoomPersp();

	///
	mNpcDialog->EnableWindow( 1 );
	mMonsterDialog->EnableWindow( 1 );
	mPortalDialog->EnableWindow( 1 );
	mGatheringDialog->EnableWindow( 1 );

	///
	{
		///  θ 
//		cString path;
//		path.Format( "%sData/Monster/", theApp.GetBaseDir().Cstr() );
//		SetCurrentDirectory( path.Cstr() );

		/// ε ˻
		cMonsterInfoMap::cIterator ii = mMonsterInfoMap.Find( 1 );

		if( ii == mMonsterInfoMap.End() )
			return true;

		///   ˻
		cMonsterInfo* info = ii->mSecond;
		cModelFileMap::cIterator mi = mModelFileMap.Find( info->mModelIndex );

		SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

		///  带 
		cMonsterSceneNodeParam param;

		cString str = mi->mSecond;
		cString pathName;
		pathName.Format( "./Data/Monster/%s", str.Cstr() );
		param.mPathName = pathName;

		cMonsterSceneNode* n = SCENEMAN->CreateMonster( param );
		if( n == 0 )
			return true;

		n->SetTargetAnimation( 1 );
		mDummyNode = n;
	}

	///   ε
	mMapIndex = mapIndex;
	LoadNpcRegen( mapIndex );
	LoadMonsterRegen( mapIndex );
	LoadPortalRegen();
	LoadGatheringRegen( mapIndex );
	return true;
}

bool cRegenToolView::LoadNpcRegen( unsigned int mapIndex )
{
	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cString pathName;
	pathName.Format( NPC_REGEN "%d.txt", mapIndex );
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		MessageBox( "Failed to open npc regen.", "Npc Regen" );
		return false;
	}

	/// Ľ
	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", pathName.Cstr() );
	cString str;

	while( tok.IsEnd() == false )
	{
		/// ε
		tok.GetNext( &str );
		unsigned int npcIndex = str.ToInt();

		/// x ǥ
		tok.GetNext( &str );
		float x = str.ToFloat();

		/// y ǥ
		tok.GetNext( &str );
		float y = str.ToFloat();

		/// ȸ
		tok.GetNext( &str );
		float zdegree = str.ToFloat();

		/// Npc 
		CreateNpc( npcIndex, x, y, zdegree, false, false );
	}

	assert( mNpcDialog );
	mNpcDialog->UpdateList( mNpcNodeMap );
	return true;
}

bool cRegenToolView::LoadMonsterRegen( unsigned int mapIndex )
{
	mMonsterDialog->Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cString pathName;
	pathName.Format( MONSTER_REGEN "%d.txt", mapIndex );
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
//		MessageBox( "Failed to open monster regen.", "Monster Regen" );
		return false;
	}
 
	/// Ľ
	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", pathName.Cstr() );
	cString str;

	while( tok.IsEnd() == false )
	{
		///  ׷ ε
		tok.GetNext( &str );
		unsigned int groupIndex = str.ToInt();

		/// {
		tok.GetNext( &str );
		if( str != '{' )
			return false;

		///  ׷ 
		cMonsterGroup* group = new cMonsterGroup( groupIndex );

		if( mMonsterGroupMap.Insert( groupIndex, group ) == false )
		{
			MessageBox( "Monster group index is duplicated.", "Monster Regen" );
			delete group;
			return false;
		}

		///   
		tok.GetNext( &str );
		group->mFirstRegen = (str.ToInt() != 0)? true : false;

		/// Ǵ ׷ ε
		tok.GetNext( &str );
		group->mRegenGroupIndex = str.ToInt();

		///  ۼƮ
		tok.GetNext( &str );
		group->mRegenPercent = str.ToInt();

		///  
		tok.GetNext( &str );
		group->mRegenRange = str.ToInt();

		///   ð
		tok.GetNext( &str );
		group->mRegenWaitTime = str.ToInt();

		///
		tok.GetNext( &str );
		group->mMapGroupIndex = str.ToInt();

		///
		tok.GetNext( &str );
		group->mChannelCheck = (str.ToInt() != 0)? true : false;

		while( tok.IsEnd() == false )
		{
			/// }
			tok.GetNext( &str );
			if( str == '}' )
				break;

			///  ε
			unsigned int monIndex = str.ToInt();

			///   ǥ
			tok.GetNext( &str );
			unsigned int x = str.ToInt();

			tok.GetNext( &str );
			unsigned int y = str.ToInt();

			///  ȸ
			tok.GetNext( &str );
			int zdegree = str.ToInt();

			///    ð
			tok.GetNext( &str );
			unsigned int regenWaitTime = str.ToInt();

			///    ð
			tok.GetNext( &str );
			unsigned int regenLifeTime = str.ToInt();

			/// ͸ 
			mSelMonsterGroup = group;
			CreateMonster( monIndex, x, y, zdegree, regenWaitTime, regenLifeTime, false, false );
		}
	}

	///
	if( mMonsterGroupMap.IsEmpty() == false )
	{
		mMonsterDialog->UpdateGroupList( mMonsterGroupMap );
	}
	SelectMonsterGroup( 0 );
	return true;
}

bool cRegenToolView::LoadPortalRegen()
{
	mPortalInfoMap.Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cFileLoader loader;

	if( loader.Open( PORTAL_LIST_TXT, true ) == false )
	{
//		MessageBox( "Failed to open portal list.", "Init" );
		return false;
	}

	/// Ľ
	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", PORTAL_LIST_TXT );
	cString str;

	while( tok.IsEnd() == false )
	{
		/// ε
		tok.GetNext( &str );
		unsigned int index = str.ToInt();

		/// 
		tok.GetNext( &str );
		cString potalNif = str;

		/// ҼӸ ε
		tok.GetNext( &str );
		unsigned int mapIndex = str.ToInt();

		/// ǥ
		tok.GetNext( &str );
		float x = str.ToFloat();

		tok.GetNext( &str );
		float y = str.ToFloat();

		/// 
		tok.GetNext( &str );
		unsigned int range = str.ToInt();

		///  Ż ε
		tok.GetNext( &str );
		unsigned int targetIndex = str.ToInt();

		/// ȸ
		tok.GetNext( &str );
		int zdegree = str.ToInt();

		/// Ż 
		if( mapIndex == mMapIndex )
		{
			CreatePortal( index, potalNif.Cstr(), (float)x, (float)y, range, targetIndex, zdegree, false, false );
		}
		else
		{
			mPortalInfoMap.Insert( index, new cPortalInfo( potalNif.Cstr(), mapIndex, x, y, range, targetIndex, zdegree, 0) );
		}
	}

	assert( mPortalDialog );
	mPortalDialog->UpdateList( mPortalInfoMap );
	return true;
}

bool cRegenToolView::LoadGatheringRegen( unsigned int mapIndex )
{
	mGatheringDialog->Clear();

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cString pathName;
	pathName.Format( GATHERING_REGEN "%d.txt", mapIndex );
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
//		MessageBox( "Failed to open gathering regen.", "Gathering Regen" );
		return false;
	}

	/// Ľ
	cTokenizer tok( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n\"", pathName.Cstr() );
	cString str;

	while( tok.IsEnd() == false )
	{
		/// ä ׷ ε
		tok.GetNext( &str );
		unsigned int groupIndex = str.ToInt();
		tok.GetNext( &str );
		unsigned int regenWaitTime = str.ToInt();
		tok.GetNext( &str );
		unsigned int regenRandTime = str.ToInt();

		/// {
		tok.GetNext( &str );
		if( str != '{' )
			return false;

		/// ä ׷ 
		cGatheringGroup* group = new cGatheringGroup( groupIndex, regenWaitTime, regenRandTime );

		if( mGatheringGroupMap.Insert( groupIndex, group ) == false )
		{
			MessageBox( "Gatherint group index is duplicated.", "Gathering Regen" );
			delete group;
			return false;
		}

		while( tok.IsEnd() == false )
		{
			/// }
			tok.GetNext( &str );
			if( str == '}' )
				break;

			/// ä ü ε
			unsigned int gatheringIndex = str.ToInt();

			/// ä ü  ǥ
			tok.GetNext( &str );
			unsigned int x = str.ToInt();

			tok.GetNext( &str );
			unsigned int y = str.ToInt();

			/// ä ü ȸ
			tok.GetNext( &str );
			int zdegree = str.ToInt();

			/// ä ü ߰ Z
			tok.GetNext( &str );
			float appendZ = str.ToFloat();


			/// äü 
			mSelGatheringGroup = group;
			CreateGathering( gatheringIndex, x, y, zdegree, appendZ, false, false );
		}
	}

	///
	if( mGatheringGroupMap.IsEmpty() == false )
	{
		mGatheringDialog->UpdateGroupList( mGatheringGroupMap );
	}
	SelectGatheringGroup( 0 );
	return true;
}

