#include "stdafx.h"
#include "RegenToolView.h"

#include "RegenToolApp.h"
#include "PortalDialog.h"
#include "FreeCamera.h"
#include "NaviMesh.h"
#include "SceneManager.h"
#include "PortalSceneNode.h"
#include "MonsterSceneNode.h"

int cRegenToolView::CreatePortal( unsigned int index, const char* potalName, float x, float y, unsigned int range, unsigned int targetIndex, int zdegree, bool updateDialog, bool updateView )
{
	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	/// ߺ ˻
	cPortalInfoMap::cIterator i = mPortalInfoMap.Find( index );

	if( i != mPortalInfoMap.End() )
		return -1;

	///  带 
	float z = 0.0f;
	mNaviMesh->CalcHeight( &z, x, y );

	cPortalSceneNodeParam param;

	cString pathName;
	pathName.Format( "./Data/Effect/%s", potalName );
	param.mPathName = pathName;

	param.mTranslate = NiPoint3( x, y, z );
	param.mRotate.FromEulerAnglesXYZ( 0.0f, 0.0f, D3DXToRadian(zdegree) );

	cPortalSceneNode* n = SCENEMAN->CreatePortal( param );
	if( n == 0 )
		return -2;

	n->SetUserData0( index );

	cPortalInfo* info = new cPortalInfo( potalName, mMapIndex, x, y, range, targetIndex, zdegree, n);
	n->SetUserData1( info->mTargetIndex );

	if( mDummyNode && info->mTargetIndex == 0 )
	{
		mDummyNode->SetTranslate( param.mTranslate );
		mDummyNode->SetRotate( param.mRotate );
		mDummyNode->Update();
	}

	///  ʿ ߰
	mPortalInfoMap.Insert( index, info );

	/// ̾α׸ 
	if( updateDialog )
		mPortalDialog->UpdateList( mPortalInfoMap );

	///  带 
	SelectNode( n, updateView );
	return 1;
}

int cRegenToolView::DeletePortal( cPortalSceneNode* node )
{
	if( mSelNode == 0 || mSelNode != node )
		return -1;

	/// õ 带 
	DeleteSel();
	return 1;
}

void cRegenToolView::SelectPortal( cPortalSceneNode* node )
{
	if( node )
	{
		NiPoint3 at = node->GetCenter();
		NiPoint3 dir = node->GetWorldRotate() * -NiPoint3::UNIT_Y;
		dir.z = 0.0f;
		dir.Unitize();
		NiPoint3 pos = at + dir * 1200.0f;
		pos.z += 300.0f;
		mCamera->SetTranslate( pos );
		mCamera->LookAt( at );
	}

	SelectNode( node );
}
