#include "stdafx.h"
#include "RegenToolView.h"

#include "RegenToolApp.h"
#include "NpcSceneNode.h"
#include "PortalSceneNode.h"
#include <direct.h>

bool cRegenToolView::SaveNpcRegen()
{
	if( mMapIndex == 0 )
		return false;

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	cString folder;
	folder.Format( "%s%s", theApp.GetBaseDir().Cstr(), "Script\\Resource\\");
	::mkdir(folder.Cstr());

	///  
	cString pathName;
	pathName.Format( "Script/Resource/NpcRegen%d.txt", mMapIndex );
	cFileSaver saver;

	if( saver.Open( pathName ) == false )
	{
		MessageBox( "Failed to open npc regen.", "Map" );
		return false;
	}

	cString str;
	str = "// index x y zdegree\r\n";
	saver.Write( str.Cstr(), str.GetSize() );

	cNpcNodeMap::cIterator i = mNpcNodeMap.Begin();
	cNpcNodeMap::cIterator iend = mNpcNodeMap.End();

	for( ; i != iend; ++i )
	{
		unsigned int index = i->mFirst;
		cNpcSceneNode* node = i->mSecond;
		const NiPoint3& t = node->GetWorldTranslate();
		const NiMatrix3& r = node->GetWorldRotate();
		float xangle = 0.0f, yangle = 0.0f, zangle = 0.0f;
		r.ToEulerAnglesXYZ( xangle, yangle, zangle );

		str.Format( "%d\t%.2f\t%.2f\t%.2f\r\n", index, t.x, t.y, D3DXToDegree(zangle) );
		saver.Write( str.Cstr(), str.GetSize() );
	}
	return true;
}

bool cRegenToolView::SaveMonsterRegen()
{
	if( mMapIndex == 0 )
		return false;

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	cString folder;
	folder.Format( "%s%s", theApp.GetBaseDir().Cstr(), "Script\\Resource\\");
	::mkdir(folder.Cstr());

	///  
	cString pathName;
	pathName.Format( "Script/Resource/MonsterRegen%d.txt", mMapIndex );
	cFileSaver saver;

	if( saver.Open( pathName ) == false )
	{
		MessageBox( "Failed to open monster regen.", "Map" );
		return false;
	}

	/// 
	cMonsterGroupMap::cIterator i = mMonsterGroupMap.Begin();
	cMonsterGroupMap::cIterator iend = mMonsterGroupMap.End();

	for( ; i != iend; ++i )
	{
		cMonsterGroup* group = i->mSecond;
		group->Save( saver );
	}
	return true;
}

bool cRegenToolView::SaveGatheringRegen()
{
	if( mMapIndex == 0 )
		return false;

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	cString folder;
	folder.Format( "%s%s", theApp.GetBaseDir().Cstr(), "Script\\Resource\\");
	::mkdir(folder.Cstr());

	///  
	cString pathName;
	pathName.Format( "Script/Resource/gatheringregen%d.txt", mMapIndex );
	cFileSaver saver;

	if( saver.Open( pathName ) == false )
	{
		MessageBox( "Failed to open gathering regen.", "Map" );
		return false;
	}

	/// 
	cGatheringGroupMap::cIterator i = mGatheringGroupMap.Begin();
	cGatheringGroupMap::cIterator iend = mGatheringGroupMap.End();

	for( ; i != iend; ++i )
	{
		cGatheringGroup* group = i->mSecond;
		group->Save( saver );
	}
	return true;
}


bool cRegenToolView::SavePortalRegen()
{
	if( mMapIndex == 0 )
		return false;

	///  θ 
	SetCurrentDirectory( theApp.GetBaseDir().Cstr() );

	///  
	cFileSaver saver;

	cString folder;
	folder.Format( "%s%s", theApp.GetBaseDir().Cstr(), "Script\\Resource\\");
	::mkdir(folder.Cstr());

	if( saver.Open( "Script/Resource/MapChangePos.txt" ) == false )
	{
		MessageBox( "Failed to open portal regen.", "Map" );
		return false;
	}

	cString str;
	str = "// index mapIndex x y range targetIndex zdegree_testtest\r\n";
	saver.Write( str.Cstr(), str.GetSize() );

	cPortalInfoMap::cIterator i = mPortalInfoMap.Begin();
	cPortalInfoMap::cIterator iend = mPortalInfoMap.End();

	for( ; i != iend; ++i )
	{
		unsigned int index = i->mFirst;
		cPortalInfo* info = i->mSecond;
		cPortalSceneNode* node = info->mNode;
		float x = 0.0f;
		float y = 0.0f;
		int zdegree = 0;

		if( node )
		{
			x = node->GetWorldTranslate().x;
			y = node->GetWorldTranslate().y;

			//if( info->mTargetIndex == 0 )
			{
				const NiMatrix3& r = node->GetWorldRotate();
				float xangle = 0.0f, yangle = 0.0f, zangle = 0.0f;
				r.ToEulerAnglesXYZ( xangle, yangle, zangle );
				zdegree = (int)D3DXToDegree( zangle );
			}
			//else
			//{
			//	zdegree = 0;
			//}
		}
		else
		{
			x = info->mX;
			y = info->mY;
			zdegree = info->mZDegree;
		}

		str.Format( "%d\t%s\t%d\t%.2f\t%.2f\t%d\t%d\t%d\r\n", index, info->mPotalName.Cstr(), info->mMapIndex, x, y, info->mRange, info->mTargetIndex, zdegree );
		saver.Write( str.Cstr(), str.GetSize() );
	}
	return true;
}
