/*-- Include files
*/
#include "iocpclient.h"

/*-- Local definitions
*/
#define SafeCloseHandle(P)  if (P!=NULL) { CloseHandle(P); (P)=NULL; } // ڵ鸦 ϰ 
#define SafeDelete(P)       if (P!=NULL) { delete(P);      (P)=NULL; } // "

/*-- Global data
*/

/*-- cIocpClient Constructor
*/
cIocpClient::cIocpClient(void)
{
	// Critical Section ʱȭ.
	InitializeCriticalSection( &mCs );

	mIocp                   = NULL;
	mSocket                 = INVALID_SOCKET;
	mIocpWorkerThreadNumber = 0;
	mIoContextPool          = NULL;

	mConnected              = false;
	mConnectionDead         = false;
	mCloseSocket            = false;
	mTimeToLive             = 0;

	mRunClient              = false;
	mEndClient              = false;
}

/*-- ~cIocpClient Destructor.
*/
cIocpClient::~cIocpClient(void)
{
	// 
	Shutdown( );

	// Critical Section .
	DeleteCriticalSection( &mCs );
}

/*-- Initialize Method
*/
bool cIocpClient::Initialize(char* ipAddr, unsigned short port, unsigned short numWorkerThreads)
{
	/*-- CreateIoCompletionPort ̿Ͽ completion port Ʈ   Ϲ Ű  
		 ʹ NumberOfConcurrentThreads ̴. ó 3 Ķʹ   ʴ´.

		 NumberOfConcurrentThreads  completion port Ͽ  带  ΰ 
		 .  ̻   context switching ϱ Ͽ 񽺿 Ͽ ϳ 
		  ϳ 常 ϵ ϴ ̴. NumberOfConcurrentThreads  0 ϸ 
		  μ    ҴϿ Ѵ.
		 (ϳ CPU Ͽ IOCP ϳ ϳ 带 )
	*/
	mIocp = CreateIoCompletionPort( INVALID_HANDLE_VALUE, NULL, 0, 0 );
	if ( mIocp == NULL )
		return false;

	/*-- CreateIoCompletionPort Ʈ  ڿ ۾带 ϰ ڵ   ִµ,
	     ̶ ϴ ۾, 尡 ϵ ɼ ִٸ, NumberOfConcurrentThreads  
		   ϴ  . NumberOfConcurrentThreadsŭ 尡 ׻ ǰ   ֱ 
		 , ϵ 尡 ִٸ ٸ 尡   ̱ ̴.
	*/
	SYSTEM_INFO si;
	DWORD       threadId;

	// ýۿ   μ ִ ȮѴ.
	GetSystemInfo( &si );

	mIocpWorkerThreadNumber = min( si.dwNumberOfProcessors * numWorkerThreads, IOCP_MAX_WORKER_THREAD );
	for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
	{
		mIocpWorkerThread[i] = CreateThread( NULL, 0, WorkerThreadStartingPoint, (LPVOID)this, 0, &threadId );
		if ( mIocpWorkerThread[i] == NULL )
			return false;
	}

	/*-- I/O Context Pool Ѵ.
	*/
	mIoContextPool = new cIoContextPool( );
	if ( mIoContextPool == NULL )
		return false;

	/*-- Ŭ̾Ʈ  Ѵ.
	*/
	SOCKADDR_IN addr;
	PHOSTENT    phe;

	ZeroMemory( (void*)&addr, sizeof(addr) );
	addr.sin_family = AF_INET;
	addr.sin_port   = htons( port );
	addr.sin_addr.s_addr = inet_addr( ipAddr );

	if ( addr.sin_addr.s_addr == INADDR_NONE )
	{
		// the host name for the server is not in dot format, therefore try it just as a string
		if ( (phe = gethostbyname( ipAddr )) != NULL )
			CopyMemory( &addr.sin_addr, phe->h_addr_list[0], phe->h_length );
		else
			return false;
	}

	// ּ.
	mAddr = addr;
	mPort = port;

	// ȯ溯 .
	mConnected      = false;
	mConnectionDead = false;
	mCloseSocket    = false;
	mTimeToLive     = 0;

	mEndClient = false;
	mRunClient = true;
	return true;
}

/*-- Shutdown Method
*/
void cIocpClient::Shutdown(DWORD /*maxWait*/)
{
	/*-- ϰ Ѵ.
	*/
	mEndClient = true;
	mRunClient = false;

	/*-- Cause worker threads to exit
	*/
	if ( mIocp != NULL )
	{
		for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
		{
			PostQueuedCompletionStatus( mIocp, 0, 0, IOCP_SHUTDOWN );
		}
	}

	/*-- Make sure worker threads exits.
	*/
	for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
	{
		if ( WaitForSingleObject( mIocpWorkerThread[i], 60000 ) != WAIT_OBJECT_0 )
		{
			DWORD exitCode;
			GetExitCodeThread( mIocpWorkerThread[i], &exitCode);
			if ( exitCode == STILL_ACTIVE )
			{
				TerminateThread( mIocpWorkerThread[i], 0 );
			}
		}
		CloseHandle( mIocpWorkerThread[i] );
		mIocpWorkerThread[i] = NULL;
	}

	/*-- Overlapped I/O Model Pool Socket Context Pool Ѵ.
	*/
	SafeDelete( mIoContextPool );

	/*-- completion port Ѵ.
	*/
	SafeCloseHandle( mIocp );

	/*--  .
	*/
	Disconnect( );
}

/*-- IsConnect Method
*/
bool cIocpClient::IsConnect(void)
{
	cCSLock lock( &mCs );
	return ( mConnected == true && mConnectionDead == false ) ? true : false;
}

/*-- Connect Method
*/
bool cIocpClient::Connect(SOCKADDR_IN addr)
{
	int    zero;
	LINGER linger;

	// connect Ŭ̾Ʈ  Ѵ.
	mSocket = WSASocket( AF_INET, SOCK_STREAM, IPPROTO_IP, NULL, 0, WSA_FLAG_OVERLAPPED );
	if ( mSocket == INVALID_SOCKET )
		return false;

	// connect õ Ѵ.
	if ( connect( mSocket, (LPSOCKADDR)&addr, sizeof(addr) ) == SOCKET_ERROR )
	{
		closesocket( mSocket );
		return (mConnected=false);
	}

	/*-- The purpose of this algorithm is to reduce the number of very small segments sent, especially on
	     high-delay (remote) links.

		 Windows Sockets applications can disable the Nagle algorithm for their connections by setting the
		 TCP_NODELAY socket option. However, this practice should be used wisely and only when needed because
		 this practice increases network traffic. Usually, applications that need to disable the Nagle algorithm
		 are applications that need to send small packets and require that the peer application receive them
		 immediately. Some network applications may not perform well if their design does not take into account
		 the effects of transmitting large numbers of small packets and the Nagle algorithm.

		 Nagel ˰  Ư () ũ ũⰡ  ׸Ʈ ۵Ǵ Ƚ ̴
		 ̴.

		 Windows   α׷ ڽ ῡ  Nagle ˰    TCP_NODELAY
		  ɼ   ֽϴ. ׷ ̷ ۾ Ʈũ ̿ ø  ݵ ʿ
		 찡 ƴϸ   ʾƾ մϴ. ټ  Ŷ   ߻ϴ  Nagle
		 ˰   ·  Ʈũ  α׷     ֽϴ.
		 Nagle ˰ ɻ   TCP  ϴ   ʽϴ. Windows 2000
		 Netbt  ȣƮ / Ӹ ƴ϶ TCP  NetBIOS ῡ ؼ ̱۸
		    ϴ.  ټ     ϴ  α׷  
		   ֽϴ. ׷  α׷δ  /    ϴ  
		 ׷   ֽϴ. 

	BOOL nodelay = TRUE;
	if ( setsockopt( mSocket, IPPROTO_TCP, TCP_NODELAY, (BOOL*)&nodelay, sizeof(BOOL) ) == SOCKET_ERROR )
		return false;
	*/

	/*-- Disable receive buffering on the socket. Setting SO_RCVBUF to 0 causes winsock to stop bufferring
	     receive and perform receives directly from our buffers, thereby reducing CPU usage.

		 SO_RCVBUF 0Ͽ Ź۸  ʴ´. Ź۰ 0 ƴϸ ʿϰ  Ź۸
		 ļ overlapped I/O ȣ   ۷ 簡 ̷.
		 Ź   overlapped I/O ȣ   ۷ ýۿ  Ͱ 
		 .
	 */
	zero = 0;
	if ( setsockopt( mSocket, SOL_SOCKET, SO_RCVBUF, (char*)&zero, sizeof(zero)) == SOCKET_ERROR )
	{
		closesocket( mSocket );
		return (mConnected=false);
	}

	/*-- Disable send buffering on the socket. Setting SO_SNDBUF to 0 causes winsock to stop bufferring
		 sends and perform sends directly from our buffers, thereby reducing CPU usage.

		 SO_SNDBUF 0Ͽ ۽Ź۸  ʴ´. ۽Ź۰ 0 ƴϸ ʿϰ  ۽Ź۸
		 ļ overlapped I/O ȣ   ۷ 簡 ̷.
		 ۽Ź   overlapped I/O ȣ   ۷ ýۿ  Ͱ 
		 .
	*/
	zero = 0;
	if ( setsockopt( mSocket, SOL_SOCKET, SO_SNDBUF, (char*)&zero, sizeof(zero) ) == SOCKET_ERROR )
	{
		closesocket( mSocket );
		return (mConnected=false);
	}

	/*-- closesocket Լ ȣ Ŀ  Ϳ  ó ϱ  ɼ̴.
		 linger::u_short l_onoff  : option on/off
		 linger::u_short l_linger : linger time

		 SO_LINGER ɼ ŸӾƿ 0 ϸ (linger ü l_onoff ʵ带 0 ƴѰ, l_linger
		  0 ),  ۵  Ͱ ִ closesocket Լ ȣ ϵ ʰ 
		 . ̷ ȣ   (virtual circuit)  (reset)ǰ ۵  
		 ʹ սǵȴ.  ϴ   Լ WSAECONNRESET Ѵ.
	*/
	linger.l_onoff  = 1;
	linger.l_linger = 0;
	if ( setsockopt( mSocket, SOL_SOCKET, SO_LINGER, (char*)&linger, sizeof(linger) ) == SOCKET_ERROR )
	{
		closesocket( mSocket );
		return (mConnected=false);
	}

	// TTL.
	mTimeToLive = GetTickCount( ) + MIN_TTL;

	/*-- connect Ͽ ϵ  ڵ completion port ҴѴ.
	*/
	if ( CreateIoCompletionPort( (HANDLE)mSocket, mIocp, (ULONG_PTR)NULL, 0 ) == NULL )
	{
		closesocket( mSocket );
		return (mConnected=false);
	}

	/*--   I/O Context غѴ.
	*/
	PerIoContext* perIoContext = mIoContextPool->GetIoContext( mSocket, IOCP_REQUEST_READ );
	RecvPost( NULL, perIoContext );

	return (mConnected=true);
}

/*-- Disconnect Method
*/
bool cIocpClient::Disconnect(void)
{
	cCSLock lock( &mCs );
	SOCKET  sockTemp = mSocket;

	mSocket         = INVALID_SOCKET;
	mConnected      = false;
	mConnectionDead = false;
	mCloseSocket    = false;

	if ( sockTemp != INVALID_SOCKET )
	{
		closesocket( sockTemp );
	}
	return true;
}

/*-- GetIoPoolUsage Method
*/
void cIocpClient::GetIoPoolUsage(SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonePagedPoolUsage, SIZE_T& workingSetSize)
{
	if ( mIoContextPool != NULL )
	{
		mIoContextPool->GetProcessMemoryInfo( quotaPagedPoolUsage, quotaNonePagedPoolUsage, workingSetSize );
	}
}

/*-- QueueRequest Method
*/
BOOL cIocpClient::QueueRequest(ULONG_PTR completionKey, LPOVERLAPPED overlapped, DWORD bytesTransferred)
{
	return PostQueuedCompletionStatus( mIocp, bytesTransferred, completionKey, overlapped );
}

/*-- SendPost Method
*/
bool cIocpClient::SendPost(ULONG_PTR completionKey, PerIoContext* perIoContext)
{
	WSABUF wsaBuf;
	DWORD  sendBytes = 0;
	DWORD  flags     = 0;
	int    retcode;

	wsaBuf.len = perIoContext->offset;
	wsaBuf.buf = perIoContext->buffer;

	retcode = WSASend( perIoContext->socket,
					   &wsaBuf,
					   1,
					   &sendBytes,
					   flags,
					   &(perIoContext->wsaOverlapped),
					   NULL );

	if ( (retcode == SOCKET_ERROR) && (WSAGetLastError() != WSA_IO_PENDING) )
	{
		PostQueuedCompletionStatus( mIocp, 0, completionKey, (LPOVERLAPPED)perIoContext );
		return false;
	}
	return true;
}

/*-- RecvPost Method
*/
bool cIocpClient::RecvPost(ULONG_PTR completionKey, PerIoContext* perIoContext)
{
	WSABUF wsaBuf;
	DWORD  recvBytes = 0;
	DWORD  flags     = 0;
	int    retcode;

	wsaBuf.len = (perIoContext->length - perIoContext->offset);
	wsaBuf.buf = (perIoContext->buffer + perIoContext->offset);

	retcode = WSARecv( perIoContext->socket,
					   &wsaBuf,
					   1,
					   &recvBytes,
					   &flags,
					   &(perIoContext->wsaOverlapped),
					   NULL );

	if ( (retcode == SOCKET_ERROR) && (WSAGetLastError() != WSA_IO_PENDING) )
	{
		PostQueuedCompletionStatus( mIocp, 0, completionKey, (LPOVERLAPPED)perIoContext );
		return false;
	}
	return true;
}

/*-- CallbackPost Method
*/
bool cIocpClient::CallbackPost(ULONG_PTR completionKey, PerIoContext* perIoContext)
{
	int retcode;

	retcode = PostQueuedCompletionStatus( mIocp,
										  perIoContext->offset,
										  completionKey,
										  (LPOVERLAPPED)perIoContext );
	if ( retcode == 0 )
	{
		return false;
	}
	return true;;
}

/*-- Close Method - CompletionKey Overlapped  CompletionKey Ѵ.
*/
void cIocpClient::Close(ULONG_PTR /*completionKey*/, PerIoContext* perIoContext)
{
	cCSLock lock( &mCs );

	if ( perIoContext->socket == mSocket )
	{
		// / Ȱȭ.
		if ( !mConnectionDead )
		{
			shutdown( mSocket, SD_BOTH );
			mConnectionDead = true;

			//   .
			Disconnect( );
		}
	}

	//  Ϸ I/O Context ȸ.
	mIoContextPool->ReleaseIoContext( perIoContext );
}

/*-- SendComplete Method
*/
bool cIocpClient::SendComplete(ULONG_PTR    /*completionKey*/,
							  PerIoContext* perIoContext,
							  DWORD         /*bytesTransferred*/)
{
	//  Ϸ I/O Context ȸѴ.
	mIoContextPool->ReleaseIoContext( perIoContext );
	return true;
}

/*-- RecvComplete Method (Default Echo Server)
*/
bool cIocpClient::RecvComplete(ULONG_PTR    completionKey,
							  PerIoContext* perIoContext,
							  DWORD         bytesTransferred)
{
	cCSLock lock( &mCs );

	/*-- ŵ ͸ Echo  .
	*/
	perIoContext->offset      = bytesTransferred;
	perIoContext->requestType = IOCP_REQUEST_WRITE;

	if ( SendPost( NULL, perIoContext ) == false )
		return false;

	/*--   I/O Context غѴ.
	*/
	perIoContext = mIoContextPool->GetIoContext( mSocket, IOCP_REQUEST_READ );
	return RecvPost( completionKey, perIoContext );
}

/*-- CallbackComplete Method
*/
bool cIocpClient::CallbackComplete(ULONG_PTR    /*completionKey*/,
								  PerIoContext* perIoContext,
								  DWORD         /*bytesTransferred*/)
{
	//  Ϸ I/O Context ȸѴ.
	mIoContextPool->ReleaseIoContext( perIoContext );
	return true;
}

/*-- WorkerThread Method
*/
DWORD cIocpClient::WorkerThread(void)
{
	DWORD             bytesTransferred;
	ULONG_PTR         completionKey;
	OVERLAPPED*       overlapped;
	BOOL              retValue;

	PerIoContext*     perIoContext;

	// [warning C4127 ǽ ].
	bool boolean = true;
	while ( boolean )
	{
		/*-- completion port Ҵ   I/O ϷḦ ٸ.
		*/
		retValue = GetQueuedCompletionStatus( mIocp, &bytesTransferred, &completionKey, &overlapped, INFINITE );

		/*-- Shutdown
		*/
		if ( overlapped == IOCP_SHUTDOWN )
			return 0;

		perIoContext = (PerIoContext*)overlapped;

		/*-- client connection dropped, continue to service remaining (and possibly new) client connections
		*/
		if ( retValue == FALSE || bytesTransferred == 0 ) 
		{
			//  Ϸ I/O Context ȸѴ.
			perIoContext->offset = max( perIoContext->offset, bytesTransferred );
			Close( completionKey, perIoContext );
			continue;
		}

		switch ( perIoContext->requestType )
		{
		case IOCP_REQUEST_READ:
			RecvComplete( completionKey, perIoContext, bytesTransferred );
			break; // Receive Ϸ ڵ鷯 Լ.

		case IOCP_REQUEST_WRITE:
			SendComplete( completionKey, perIoContext, bytesTransferred );
			break; // Send Ϸ ڵ鷯 Լ.

		case IOCP_REQUEST_CALLBACK:
			CallbackComplete( completionKey, perIoContext, bytesTransferred );
			break; // Callback Ϸ ڵ鷯 Լ.
		}
	}
	return 0;
}

/*-- WorkerThreadStartingPoint Method ( Worker Thread  Ʈ )
*/
DWORD cIocpClient::WorkerThreadStartingPoint(void* ptr)
{
	cIocpClient* iocpClient = (cIocpClient*)ptr;
	return iocpClient->WorkerThread( );
}
