// Include files
#include "iocpserver.h"

// Local definitions
#pragma warning( disable: 4127 )

#define MAX_BUFFER          0x10000                                    // 64KByte

#define SafeCloseHandle(P)  if (P!=NULL) { CloseHandle(P); (P)=NULL; } // ڵ鸦 ϰ 
#define SafeDelete(P)       if (P!=NULL) { delete(P);      (P)=NULL; } // "

// Global data

// cIocpServer Constructor
cIocpServer::cIocpServer(void)
{
	// Critical Section ʱȭ.
	InitializeCriticalSection( &mCs );

	mIocp                   = NULL;
	mSocket                 = INVALID_SOCKET;
	mIocpAcceptThread       = NULL;
	mIocpWorkerThreadNumber = 0;
	mIocpBackendThread      = NULL;

	mIoContextPool          = NULL;
	mSocketContextPool      = NULL;

	mIoContextFrontBuffer   = NULL;
	mIoContextBackBuffer    = NULL;

	mRunServer              = false;
	mEndServer              = false;
}

// ~cIocpServer Destructor.
cIocpServer::~cIocpServer(void)
{
	// 
	Shutdown( );

	// Critical Section .
	DeleteCriticalSection( &mCs );
}

// Initialize Method
bool cIocpServer::Initialize(char* ipAddr, unsigned short port, unsigned short numWorkerThreads, unsigned short bufferLength)
{
	// CreateIoCompletionPort ̿Ͽ completion port Ʈ   Ϲ Ű  
	// ʹ NumberOfConcurrentThreads ̴. ó 3 Ķʹ   ʴ´.
	//
	// NumberOfConcurrentThreads  completion port Ͽ  带  ΰ 
	// .  ̻   context switching ϱ Ͽ 񽺿 Ͽ ϳ 
	//  ϳ 常 ϵ ϴ ̴. NumberOfConcurrentThreads  0 ϸ 
	//  μ    ҴϿ Ѵ.
	// (ϳ CPU Ͽ IOCP ϳ ϳ 带 )
	//
	mIocp = CreateIoCompletionPort( INVALID_HANDLE_VALUE, NULL, 0, 0 );
	if ( mIocp == NULL )
		return false;

	// CreateIoCompletionPort Ʈ  ڿ ۾带 ϰ ڵ   ִµ,
	// ̶ ϴ ۾, 尡 ϵ ɼ ִٸ, NumberOfConcurrentThreads  
	//   ϴ  . NumberOfConcurrentThreadsŭ 尡 ׻ ǰ   ֱ 
	// , ϵ 尡 ִٸ ٸ 尡   ̱ ̴.
	//
	SYSTEM_INFO si;
	DWORD       threadId;

	// ýۿ   μ ִ ȮѴ.
	GetSystemInfo( &si );

	mIocpWorkerThreadNumber = min( si.dwNumberOfProcessors * numWorkerThreads, IOCP_MAX_WORKER_THREAD );
	for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
	{
		// Worker Thread.
		mIocpWorkerThread[i] = CreateThread( NULL, 0, WorkerThreadStartingPoint, (LPVOID)this, 0, &threadId );
		if ( mIocpWorkerThread[i] == NULL )
			return false;
	}

	// Socket Context Pool Ѵ.
	mSocketContextPool = new cSocketContextPool( &mCs );
	if ( mSocketContextPool == NULL )
		return false;

	// I/O Context Pool Ѵ.
	// Recv/Send  Ŭ̾Ʈ * 2 Ѵ.
	//
	mIoContextPool = new cIoContextPool( bufferLength );
	if ( mIoContextPool == NULL )
		return false;

	// I/O Context Buffer Ѵ.
	mIoContextFrontBuffer = (IoContextBuffer*)GlobalAlloc( GPTR, sizeof(IoContextBuffer) );
	mIoContextBackBuffer  = (IoContextBuffer*)GlobalAlloc( GPTR, sizeof(IoContextBuffer) );
	if ( !mIoContextFrontBuffer && !mIoContextBackBuffer )
		return false;

	//   Ѵ.
	//
	PHOSTENT    phe;
	int         zero;
	LINGER      linger;

	// listen   Ѵ.
	mSocket = WSASocket( AF_INET, SOCK_STREAM, IPPROTO_IP, NULL, 0, WSA_FLAG_OVERLAPPED );
	if ( mSocket == INVALID_SOCKET )
		return false;

	ZeroMemory( (void*)&mAddr, sizeof(mAddr) );
	mAddr.sin_family = AF_INET;
	mAddr.sin_port   = htons( port );
	mAddr.sin_addr.s_addr = strlen( ipAddr ) ? inet_addr( ipAddr ) : INADDR_NONE;

	if ( mAddr.sin_addr.s_addr == INADDR_NONE )
	{
		// the host name for the server is not in dot format, therefore try it just as a string
		//  ȣƮ ̸ Ʈ (IPv4) ƴϹǷ, ڿ  õ.
		//
		if ( (phe = gethostbyname( "" )) != NULL )
			CopyMemory( &mAddr.sin_addr, phe->h_addr_list[0], phe->h_length );
		else
			return false;
	}

	mPort = port;

	if ( bind( mSocket, (LPSOCKADDR)&mAddr, sizeof(mAddr) ) == SOCKET_ERROR )
		return false;

	if ( listen( mSocket, SOMAXCONN ) == SOCKET_ERROR )
		return false;

	// The purpose of this algorithm is to reduce the number of very small segments sent, especially on
	// high-delay (remote) links.
	//
	// Windows Sockets applications can disable the Nagle algorithm for their connections by setting the
	// TCP_NODELAY socket option. However, this practice should be used wisely and only when needed because
	// this practice increases network traffic. Usually, applications that need to disable the Nagle algorithm
	// are applications that need to send small packets and require that the peer application receive them
	// immediately. Some network applications may not perform well if their design does not take into account
	// the effects of transmitting large numbers of small packets and the Nagle algorithm.
	//
	// Nagel ˰  Ư () ũ ũⰡ  ׸Ʈ ۵Ǵ Ƚ ̴
	// ̴.
	//
	// Windows   α׷ ڽ ῡ  Nagle ˰    TCP_NODELAY
	//  ɼ   ֽϴ. ׷ ̷ ۾ Ʈũ ̿ ø  ݵ ʿ
	// 찡 ƴϸ   ʾƾ մϴ. ټ  Ŷ   ߻ϴ  Nagle
	// ˰   ·  Ʈũ  α׷     ֽϴ.
	// Nagle ˰ ɻ   TCP  ϴ   ʽϴ. Windows 2000
	// Netbt  ȣƮ / Ӹ ƴ϶ TCP  NetBIOS ῡ ؼ ̱۸
	//    ϴ.  ټ     ϴ  α׷  
	//   ֽϴ. ׷  α׷δ  /    ϴ  
	// ׷   ֽϴ. 
	//
	// BOOL nodelay = TRUE;
	// if ( setsockopt( mSocket, IPPROTO_TCP, TCP_NODELAY, (BOOL*)&nodelay, sizeof(BOOL) ) == SOCKET_ERROR )
	//	throw 163;

	// Disable receive buffering on the socket. Setting SO_RCVBUF to 0 causes winsock to stop bufferring
	// receive and perform receives directly from our buffers, thereby reducing CPU usage.
	//
	// SO_RCVBUF 0Ͽ Ź۸  ʴ´. Ź۰ 0 ƴϸ ʿϰ  Ź۸
	// ļ overlapped I/O ȣ   ۷ 簡 ̷.
	// Ź   overlapped I/O ȣ   ۷ ýۿ  Ͱ 
	// .
	//
	zero = 0;
	if ( setsockopt( mSocket, SOL_SOCKET, SO_RCVBUF, (char*)&zero, sizeof(zero)) == SOCKET_ERROR )
		return false;

	// Disable send buffering on the socket. Setting SO_SNDBUF to 0 causes winsock to stop bufferring
	// sends and perform sends directly from our buffers, thereby reducing CPU usage.
	//
	// SO_SNDBUF 0Ͽ ۽Ź۸  ʴ´. ۽Ź۰ 0 ƴϸ ʿϰ  ۽Ź۸
	// ļ overlapped I/O ȣ   ۷ 簡 ̷.
	// ۽Ź   overlapped I/O ȣ   ۷ ýۿ  Ͱ 
	// .
	//
	zero = 0;
	if ( setsockopt( mSocket, SOL_SOCKET, SO_SNDBUF, (char*)&zero, sizeof(zero) ) == SOCKET_ERROR )
		return false;

	// closesocket Լ ȣ Ŀ  Ϳ  ó ϱ  ɼ̴.
	// linger::u_short l_onoff  : option on/off
	// linger::u_short l_linger : linger time
	//
	// SO_LINGER ɼ ŸӾƿ 0 ϸ (linger ü l_onoff ʵ带 0 ƴѰ, l_linger
	//  0 ),  ۵  Ͱ ִ closesocket Լ ȣ ϵ ʰ 
	// . ̷ ȣ   (virtual circuit)  (reset)ǰ ۵  
	// ʹ սǵȴ.  ϴ   Լ WSAECONNRESET Ѵ.
	//
	linger.l_onoff  = 1;
	linger.l_linger = 0;
	if ( setsockopt( mSocket, SOL_SOCKET, SO_LINGER, (char*)&linger, sizeof(linger) ) == SOCKET_ERROR )
		return false;

	mEndServer = false;
	mRunServer = true;

	// Accept Thread Ѵ.
	mIocpAcceptThread = CreateThread( NULL, 0, AcceptThreadStartingPoint, (LPVOID)this, 0, &threadId );
	if ( mIocpAcceptThread == NULL )
		return false;

	// Backend Thread Ѵ.
	mIocpBackendThread = CreateThread( NULL, 0, BackendThreadStartingPoint, (LPVOID)this, 0, &threadId );
	if ( mIocpBackendThread == NULL )
		return false;

	return true;
}

// Shutdown Method
void cIocpServer::Shutdown(DWORD maxWait)
{
	// ϰ Ѵ.
	mEndServer = true;
	mRunServer = false;

	// Backend Thread ɶ 
	if ( mIocpBackendThread != NULL )
	{
		WaitForSingleObjectEx( mIocpBackendThread, maxWait, TRUE );
		CloseHandle( mIocpBackendThread );
		mIocpBackendThread = NULL;
	}

	//  Ѵ.
	SOCKET sockTemp = mSocket;

	mSocket = INVALID_SOCKET;

	if ( sockTemp != INVALID_SOCKET )
	{
		closesocket( sockTemp );
	}

	// Accept Thread ɶ 
	if ( mIocpAcceptThread != NULL )
	{
		WaitForSingleObjectEx( mIocpAcceptThread, maxWait, TRUE );
		CloseHandle( mIocpAcceptThread );
		mIocpAcceptThread = NULL;
	}

	// Cause worker threads to exit
	if ( mIocp != NULL )
	{
		for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
		{
			PostQueuedCompletionStatus( mIocp, 0, 0, IOCP_SHUTDOWN );
		}
	}

	// Make sure worker threads exits.
	for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
	{
		if ( WaitForSingleObject( mIocpWorkerThread[i], 60000 ) != WAIT_OBJECT_0 )
		{
			DWORD exitCode;
			GetExitCodeThread( mIocpWorkerThread[i], &exitCode);
			if ( exitCode == STILL_ACTIVE )
			{
				TerminateThread( mIocpWorkerThread[i], 0 );
			}
		}
		CloseHandle( mIocpWorkerThread[i] );
		mIocpWorkerThread[i] = NULL;
	}

	// Overlapped I/O Model Pool Socket Context Pool Ѵ.
	if ( mIoContextFrontBuffer )
	{
		GlobalFree( mIoContextFrontBuffer );
		mIoContextFrontBuffer = NULL;
	}
	if ( mIoContextBackBuffer )
	{
		GlobalFree( mIoContextBackBuffer );
		mIoContextBackBuffer = NULL;
	}
	SafeDelete( mIoContextPool     );
	SafeDelete( mSocketContextPool );

	// completion port Ѵ.
	SafeCloseHandle( mIocp );
}

// GetPoolUsage Method
void cIocpServer::GetIoPoolUsage(SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonePagedPoolUsage, SIZE_T& workingSetSize)
{
	if ( mIoContextPool != NULL )
	{
		mIoContextPool->GetProcessMemoryInfo( quotaPagedPoolUsage, quotaNonePagedPoolUsage, workingSetSize );
	}
}

// GetPoolUsage Method
void cIocpServer::GetSocketPoolUsage(SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonePagedPoolUsage, SIZE_T& workingSetSize)
{
	if ( mSocketContextPool != NULL )
	{
		mSocketContextPool->GetProcessMemoryInfo( quotaPagedPoolUsage, quotaNonePagedPoolUsage, workingSetSize );
	}
}

// QueueRequest Method
BOOL cIocpServer::QueueRequest(ULONG_PTR completionKey, LPOVERLAPPED overlapped, DWORD bytesTransferred)
{
	return PostQueuedCompletionStatus( mIocp, bytesTransferred, completionKey, overlapped );
}

// AcceptComplete Method
bool cIocpServer::AcceptComplete(PerSocketContext* /*perSocketContext*/)
{
	return true;
}

// AcceptThread Method
DWORD cIocpServer::AcceptThread( )
{
	while ( true )
	{
		PerSocketContext* perSocketContext = NULL;
		PerIoContext*     perIoContext     = NULL;
		SOCKET            socket;
		SOCKADDR_IN       addr;
		int               addrlen;

		//  ϰ completion port Ѵ.
		addrlen = sizeof( addr );
		socket  = WSAAccept( mSocket, (sockaddr*)&addr, &addrlen, NULL, 0 );
		if ( socket == SOCKET_ERROR ) 
			break;

		// , Thread .
		if ( mEndServer == true )
			break;

		// ϳ Ằ TCP keepalive ȰȭŰ keepalive    Ѵ.
		// keepaliveinterval:    keepalive Ŷ  ̴.
		// keepalivetime    :  ȿ Ȯϱ Ͽ keepalive Ŷ  ̴.
		//
		// Header           : Declared in Mstcpip.h.
		//
		// tcp_keepalive keepAlive;
		// DWORD         bytesReturned;
		// 
		// keepAlive.onoff             = 1;
		// keepAlive.keepalivetime     = 3000;
		// keepAlive.keepaliveinterval = 1000;
		// 
		// if ( WSAIoctl( socket, SIO_KEEPALIVE_VALS, &keepAlive, sizeof(keepAlive), 0, 0, &bytesReturned, NULL, NULL ) == SOCKET_ERROR )
		// {
		// 	closesocket( socket );
		// 	continue;
		// }

		// cSocketContextPool class PerSocketContext ´.
		perSocketContext = mSocketContextPool->GetPerSocketContext( socket, addr, MAX_TTL );
		if ( perSocketContext == NULL )
			break;

		// Accept Ͽ ϵ  ڵ completion port ҴѴ.
		if ( CreateIoCompletionPort( (HANDLE)socket, mIocp, (ULONG_PTR)perSocketContext, 0 ) == NULL )
			break;

		// Accept Ϸ ڵ鷯 Լ.
		if ( AcceptComplete( perSocketContext ) == false )
		{
			// SocketContext ȸ.
			mSocketContextPool->ReleasePerSocketContext( perSocketContext );
			continue;
		}

		//   I/O Context غѴ.
		perIoContext = mIoContextPool->GetIoContext( perSocketContext->socket, IOCP_REQUEST_READ );
		if ( RecvPost( perIoContext ) == false )
		{
			Close( perSocketContext );
			continue;
		}
	}
	return 0;
}

// SendExec Method
bool cIocpServer::SendExec(PerIoContext* perIoContext)
{
	WSABUF wsaBuf;
	DWORD  sendBytes = 0;
	DWORD  flags     = 0;
	int    retcode;

	wsaBuf.len = perIoContext->offset;
	wsaBuf.buf = perIoContext->buffer;

	retcode = WSASend( perIoContext->socket,
					   &wsaBuf,
					   1,
					   &sendBytes,
					   flags,
					   &(perIoContext->wsaOverlapped),
					   NULL );

	if ( (retcode == SOCKET_ERROR) && (WSAGetLastError() != WSA_IO_PENDING) )
	{
		mIoContextPool->ReleaseIoContext( perIoContext );
		return false;
	}
	return true;
}

// SendPost Method
bool cIocpServer::SendPost(PerIoContext* perIoContext)
{
	cCSLock        lock( &mCs );
	PerIoContext** buffer = mIoContextBackBuffer->buffer;
	long&          offset = mIoContextBackBuffer->offset;

	if ( offset < MAX_IO_CONTEXT_BUFFER_LEN )
	{
		buffer[ offset ] = perIoContext;
		offset++;
		return true;
	}

	mIoContextPool->ReleaseIoContext( perIoContext );
	return false;
}

// RecvPost Method
bool cIocpServer::RecvPost(PerIoContext* perIoContext)
{
	WSABUF wsaBuf;
	DWORD  recvBytes = 0;
	DWORD  flags     = 0;
	int    retcode;

	wsaBuf.len = (perIoContext->length - perIoContext->offset);
	wsaBuf.buf = (perIoContext->buffer + perIoContext->offset);

	retcode = WSARecv( perIoContext->socket,
					   &wsaBuf,
					   1,
					   &recvBytes,
					   &flags,
					   &(perIoContext->wsaOverlapped),
					   NULL );

	if ( (retcode == SOCKET_ERROR) && (WSAGetLastError() != WSA_IO_PENDING) )
	{
		mIoContextPool->ReleaseIoContext( perIoContext );
		return false;
	}
	return true;
}

// Close Method - CompletionKey Overlapped  CompletionKey Ѵ.
void cIocpServer::Close(PerSocketContext* perSocketContext, PerIoContext* perIoContext)
{
	cCSLock lock( &mCs );

	//  Ϸ Socket Context ȸ.
	if ( perSocketContext->socket == perIoContext->socket )
	{
		// / Ȱȭ.
		if ( !perSocketContext->status.connectionDead )
		{
			shutdown( perSocketContext->socket, SD_BOTH );
			perSocketContext->status.connectionDead = 1;
		}
	}

	//  Ϸ I/O Context ȸ.
	mIoContextPool->ReleaseIoContext( perIoContext );
}

void cIocpServer::Close(PerSocketContext* perSocketContext)
{
	cCSLock lock( &mCs );

	// / Ȱȭ.
	if ( !perSocketContext->status.connectionDead )
	{
		shutdown( perSocketContext->socket, SD_BOTH );
		perSocketContext->status.connectionDead = 1;
	}
}

// SendComplete Method
bool cIocpServer::SendComplete(PerSocketContext* /*perSocketContext*/,
							   PerIoContext*     perIoContext,
							   DWORD             /*bytesTransferred*/)
{
	//  Ϸ I/O Context ȸѴ.
	mIoContextPool->ReleaseIoContext( perIoContext );
	return true;
}

// RecvComplete Method (Default Echo Server)
bool cIocpServer::RecvComplete(PerSocketContext* perSocketContext,
							   PerIoContext*     perIoContext,
							   DWORD             bytesTransferred)
{
	// ŵ ͸ Echo  .
	perIoContext->offset      = bytesTransferred;
	perIoContext->requestType = IOCP_REQUEST_WRITE;

	if ( SendPost( perIoContext ) == false )
	{
		Close( perSocketContext );
		return false;
	}

	//   I/O Context غѴ.
	perIoContext = mIoContextPool->GetIoContext( perSocketContext->socket, IOCP_REQUEST_READ );
	if ( RecvPost( perIoContext ) == false )
	{
		Close( perSocketContext );
		return false;
	}
	return true;
}

// CallbackComplete Method
bool cIocpServer::CallbackComplete(PerSocketContext* /*perSocketContext*/,
								   PerIoContext*     perIoContext,
								   DWORD             /*bytesTransferred*/)
{
	//  Ϸ I/O Context ȸѴ.
	mIoContextPool->ReleaseIoContext( perIoContext );
	return true;
}

/*-- IoContextPresent Method
*/
void cIocpServer::IoContextPresent( )
{
	IoContextBuffer* temp;

	// Double Buffering ó.
	EnterCriticalSection( &mCs );

		temp                  = mIoContextBackBuffer;
		mIoContextBackBuffer  = mIoContextFrontBuffer;
		mIoContextFrontBuffer = temp;

	LeaveCriticalSection( &mCs );

	// ۽.
	PerIoContext** buffer = mIoContextFrontBuffer->buffer;
	long&          offset = mIoContextFrontBuffer->offset;

	while ( offset > 0 )
	{
		SendExec( (*buffer) );
		(*buffer) = NULL;

		buffer++;
		offset--;
	}
}

// WorkerThread Method
DWORD cIocpServer::WorkerThread( )
{
	DWORD             bytesTransferred;
	ULONG_PTR         completionKey;
	OVERLAPPED*       overlapped;
	BOOL              retValue;

	PerSocketContext* perSocketContext;
	PerIoContext*     perIoContext;

	while ( true )
	{
		// completion port Ҵ   I/O ϷḦ ٸ.
		retValue = GetQueuedCompletionStatus( mIocp, &bytesTransferred, &completionKey, &overlapped, INFINITE );

		// Shutdown
		if ( overlapped == IOCP_SHUTDOWN )
			return 0;

		perSocketContext = (PerSocketContext*)completionKey;
		perIoContext     = (PerIoContext*)overlapped;

		// client connection dropped, continue to service remaining (and possibly new) client connections
		if ( retValue == FALSE || bytesTransferred == 0 ) 
		{
			//  Ϸ I/O Context ȸѴ.
			perIoContext->offset = max( perIoContext->offset, bytesTransferred );
			Close( perSocketContext, perIoContext );
			continue;
		}

		switch ( perIoContext->requestType )
		{
		case IOCP_REQUEST_READ:
			RecvComplete( perSocketContext, perIoContext, bytesTransferred );
			break; // Receive Ϸ ڵ鷯 Լ.

		case IOCP_REQUEST_WRITE:
			SendComplete( perSocketContext, perIoContext, bytesTransferred );
			break; // Send Ϸ ڵ鷯 Լ.

		case IOCP_REQUEST_CALLBACK:
			CallbackComplete( perSocketContext, perIoContext, bytesTransferred );
			break; // Callback Ϸ ڵ鷯 Լ.
		}
	}
	return 0;
}

// BackendThread Method
DWORD cIocpServer::BackendThread( )
{
	DWORD beginTick;
	DWORD endTick;
	DWORD tickDiff;

	while ( true )
	{
		beginTick = GetTickCount( );

		// , Thread .
		if ( mEndServer == true )
			break;

		//  TTL(Time To Live) ˻.
		if ( mSocketContextPool != NULL )
		{
			cCSLock           lock( &mCs );
			PerSocketContext* socketContext = mSocketContextPool->GetPagedPoolUsage( );
			PerSocketContext* next          = NULL;

			while ( socketContext != NULL )
			{
				next = socketContext->next;

				if ( socketContext->status.connectionDead )
				{
					// Close Socket On.
					socketContext->status.closeSocket = 1;
				}
				else
				{
					// TTL Ȯ
					if ( beginTick > socketContext->timeToLive )
					{
						PerIoContext* cbIoContext = mIoContextPool->GetIoContext( socketContext->socket, IOCP_REQUEST_CALLBACK );
						PostQueuedCompletionStatus( mIocp, 0, (ULONG_PTR)socketContext, (LPOVERLAPPED)cbIoContext );
					}
				}

				if ( socketContext->status.closeSocket )
				{
					// SocketContext ȸ.
					mSocketContextPool->ReleasePerSocketContext( socketContext );
				}

				socketContext = next;
			} // while ( socketContext != NULL )
		}

		// I/O Context ó.
		IoContextPresent( );

		endTick  = GetTickCount( );
		tickDiff = endTick - beginTick;
		Sleep( 10 );
	}
	return 0;
}

// AcceptThreadStartingPoint Method ( Accept Thread  Ʈ )
DWORD cIocpServer::AcceptThreadStartingPoint(void* ptr)
{
	cIocpServer* iocpServer = (cIocpServer*)ptr;
	return iocpServer->AcceptThread( );
}

// WorkerThreadStartingPoint Method ( Worker Thread  Ʈ )
DWORD cIocpServer::WorkerThreadStartingPoint(void* ptr)
{
	cIocpServer* iocpServer = (cIocpServer*)ptr;
	return iocpServer->WorkerThread( );
}

// BackendThreadStartingPoint Method ( Backend Thread  Ʈ )
DWORD cIocpServer::BackendThreadStartingPoint(void* ptr)
{
	cIocpServer* iocpServer = (cIocpServer*)ptr;
	return iocpServer->BackendThread( );
}
