// Include files
#include "iocpudprecv.h"

// Local definitions
#pragma warning( disable: 4127 )

#define SafeCloseHandle(P)  if (P!=NULL) { CloseHandle(P); (P)=NULL; } // ڵ鸦 ϰ 
#define SafeDelete(P)       if (P!=NULL) { delete(P);      (P)=NULL; } // "

// Global data

// IocpUdpRecv Constructor
IocpUdpRecv::IocpUdpRecv(void)
{
	// Critical Section ʱȭ.
	InitializeCriticalSection( &m_cs );

	m_iocp                   = NULL;
	m_socket                 = INVALID_SOCKET;
	m_iocpWorkerThreadNumber = 0;
	m_ioContextPool          = NULL;
	m_iocpBackendThread      = NULL;

	m_ioContextFrontBuffer   = NULL;
	m_ioContextBackBuffer    = NULL;

	m_runServer              = false;
	m_endServer              = false;
}

// ~IocpUdpRecv Destructor.
IocpUdpRecv::~IocpUdpRecv(void)
{
	// 
	Shutdown( );

	// Critical Section .
	DeleteCriticalSection( &m_cs );
}

// Initialize Method
bool IocpUdpRecv::Initialize(char* ipAddr, unsigned short port, unsigned short numWorkerThreads)
{
	// CreateIoCompletionPort ̿Ͽ completion port Ʈ   Ϲ Ű  
	// ʹ NumberOfConcurrentThreads ̴. ó 3 Ķʹ   ʴ´.

	// NumberOfConcurrentThreads  completion port Ͽ  带  ΰ 
	// .  ̻   context switching ϱ Ͽ 񽺿 Ͽ ϳ 
	//  ϳ 常 ϵ ϴ ̴. NumberOfConcurrentThreads  0 ϸ 
	//  μ    ҴϿ Ѵ.
	// (ϳ CPU Ͽ IOCP ϳ ϳ 带 )
	m_iocp = CreateIoCompletionPort( INVALID_HANDLE_VALUE, NULL, 0, 0 );
	if ( m_iocp == NULL )
		return false;

	// CreateIoCompletionPort Ʈ  ڿ ۾带 ϰ ڵ   ִµ,
	// ̶ ϴ ۾, 尡 ϵ ɼ ִٸ, NumberOfConcurrentThreads  
	//   ϴ  . NumberOfConcurrentThreadsŭ 尡 ׻ ǰ   ֱ 
	// , ϵ 尡 ִٸ ٸ 尡   ̱ ̴.
	SYSTEM_INFO si;
	DWORD       threadId;

	// ýۿ   μ ִ ȮѴ.
	GetSystemInfo( &si );

	m_iocpWorkerThreadNumber = min( si.dwNumberOfProcessors * numWorkerThreads, IOCP_MAX_WORKER_THREAD );
	for ( int i = 0; i < m_iocpWorkerThreadNumber; i++ )
	{
		m_iocpWorkerThread[i] = CreateThread( NULL, 0, WorkerThreadStartingPoint, (LPVOID)this, 0, &threadId );
		if ( m_iocpWorkerThread[i] == NULL )
			return false;
	}

	// I/O Context Pool Ѵ.
	// 0xffff: UDP(65,535) ִ Ŷ 
	// 0x0044: IPv4(60) + UDP(8)  ش 
	m_ioContextPool = new cIoContextPool( MAX_UDP_PACKET_SIZE );
	if ( m_ioContextPool == NULL )
		return false;

	// I/O Context Buffer Ѵ.
	m_ioContextFrontBuffer = (IoContextBuffer*)GlobalAlloc( GPTR, sizeof(IoContextBuffer) );
	m_ioContextBackBuffer  = (IoContextBuffer*)GlobalAlloc( GPTR, sizeof(IoContextBuffer) );
	if ( !m_ioContextFrontBuffer && !m_ioContextBackBuffer )
		return false;

	// IPv4 ּҸ .
	ZeroMemory( (void*)&m_addr, sizeof(SOCKADDR_IN) );
	m_addr.sin_family = AF_INET;
	m_addr.sin_port   = htons( port );
	m_addr.sin_addr.s_addr = inet_addr( ipAddr );

	if ( m_addr.sin_addr.s_addr == INADDR_NONE )
	{
		PHOSTENT phe;

		// the host name for the server is not in dot format, therefore try it just as a string
		if ( (phe = gethostbyname( ipAddr )) != NULL )
			CopyMemory( &m_addr.sin_addr, phe->h_addr_list[0], phe->h_length );
		else
			return false;
	}

	// connect Ŭ̾Ʈ  Ѵ.
	m_socket = WSASocket( AF_INET, SOCK_DGRAM, IPPROTO_UDP, NULL, 0, WSA_FLAG_OVERLAPPED );
	if ( m_socket == INVALID_SOCKET )
		return false;

	if ( bind( m_socket, (LPSOCKADDR)&m_addr, sizeof(SOCKADDR_IN) ) == SOCKET_ERROR )
		return false;

	// Disable receive buffering on the socket. Setting SO_RCVBUF to 0 causes winsock to stop bufferring
	// receive and perform receives directly from our buffers, thereby reducing CPU usage.

	// SO_RCVBUF 0Ͽ Ź۸  ʴ´. Ź۰ 0 ƴϸ ʿϰ  Ź۸
	// ļ overlapped I/O ȣ   ۷ 簡 ̷.
	// Ź   overlapped I/O ȣ   ۷ ýۿ  Ͱ 
	// .
	int zero;

	zero = 0;
	if ( setsockopt( m_socket, SOL_SOCKET, SO_RCVBUF, (char*)&zero, sizeof(zero)) == SOCKET_ERROR )
	{
		closesocket( m_socket );
		return false;
	}

	//   ڵ completion port ҴѴ.
	if ( CreateIoCompletionPort( (HANDLE)m_socket, m_iocp, (ULONG_PTR)NULL, 0 ) == NULL )
	{
		closesocket( m_socket );
		return false;
	}

	//   I/O Context غѴ.
	PerIoContext* perIoContext = m_ioContextPool->GetIoContext( m_socket, IOCP_REQUEST_READ );
	RecvPost( NULL, perIoContext );

	m_endServer = false;
	m_runServer = true;

	// Backend Thread Ѵ.
	m_iocpBackendThread = CreateThread( NULL, 0, BackendThreadStartingPoint, (LPVOID)this, 0, &threadId );
	if ( m_iocpBackendThread == NULL )
		return false;
	return true;
}

// Shutdown Method
void IocpUdpRecv::Shutdown(DWORD maxWait)
{
	// ϰ Ѵ.
	m_endServer = true;
	m_runServer = false;

	// Backend Thread ɶ 
	if ( m_iocpBackendThread != NULL )
	{
		WaitForSingleObjectEx( m_iocpBackendThread, maxWait, TRUE );
		CloseHandle( m_iocpBackendThread );
		m_iocpBackendThread = NULL;
	}

	// ϰ Ѵ.
	SOCKET sockTemp = m_socket;

	if ( sockTemp != INVALID_SOCKET )
	{
		closesocket( sockTemp );
	}

	// Cause worker threads to exit
	if ( m_iocp != NULL )
	{
		for ( int i = 0; i < m_iocpWorkerThreadNumber; i++ )
		{
			PostQueuedCompletionStatus( m_iocp, 0, 0, IOCP_SHUTDOWN );
		}
	}

	// Make sure worker threads exits.
	for ( int i = 0; i < m_iocpWorkerThreadNumber; i++ )
	{
		if ( WaitForSingleObject( m_iocpWorkerThread[ i ], 60000 ) != WAIT_OBJECT_0 )
		{
			DWORD exitCode;
			GetExitCodeThread( m_iocpWorkerThread[ i ], &exitCode);
			if ( exitCode == STILL_ACTIVE )
			{
				TerminateThread( m_iocpWorkerThread[ i ], 0 );
			}
		}
		CloseHandle( m_iocpWorkerThread[ i ] );
		m_iocpWorkerThread[i] = NULL;
	}

	//  ʱȭ.
	m_socket = INVALID_SOCKET;

	// Overlapped I/O Model Pool Socket Context Pool Ѵ.
	if ( m_ioContextFrontBuffer )
	{
		GlobalFree( m_ioContextFrontBuffer );
		m_ioContextFrontBuffer = NULL;
	}
	if ( m_ioContextBackBuffer )
	{
		GlobalFree( m_ioContextBackBuffer );
		m_ioContextBackBuffer = NULL;
	}
	// Overlapped I/O Model Pool Ѵ.
	SafeDelete( m_ioContextPool );

	// completion port Ѵ.
	SafeCloseHandle( m_iocp );
}

// GetIoPoolUsage Method
void IocpUdpRecv::GetIoPoolUsage(SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonePagedPoolUsage, SIZE_T& workingSetSize)
{
	if ( m_ioContextPool != NULL )
	{
		m_ioContextPool->GetProcessMemoryInfo( quotaPagedPoolUsage, quotaNonePagedPoolUsage, workingSetSize );
	}
}

// QueueRequest Method
BOOL IocpUdpRecv::QueueRequest(ULONG_PTR completionKey, LPOVERLAPPED overlapped, DWORD bytesTransferred)
{
	return PostQueuedCompletionStatus( m_iocp, bytesTransferred, completionKey, overlapped );
}

// RecvPost Method
bool IocpUdpRecv::RecvPost(ULONG_PTR completionKey, PerIoContext* perIoContext)
{
	WSABUF wsaBuf;
	DWORD  recvBytes = 0;
	DWORD  flags     = 0;
	int    addrlen   = sizeof(SOCKADDR_IN);
	int    retcode;

	wsaBuf.len = (perIoContext->length - perIoContext->offset);
	wsaBuf.buf = (perIoContext->buffer + perIoContext->offset);

	retcode = WSARecvFrom( perIoContext->socket,
						   &wsaBuf,
						   1,
						   &recvBytes,
						   &flags,
						   (SOCKADDR*)&perIoContext->addr,
						   &addrlen,
						   &(perIoContext->wsaOverlapped),
						   NULL );

	if ( (retcode == SOCKET_ERROR) && (WSAGetLastError() != WSA_IO_PENDING) )
	{
		PostQueuedCompletionStatus( m_iocp, 0, (ULONG_PTR)completionKey, (LPOVERLAPPED)perIoContext );
		return false;
	}
	return true;
}

// CallbackPost Method
bool IocpUdpRecv::CallbackPost(ULONG_PTR completionKey, PerIoContext* perIoContext)
{
	int retcode;

	retcode = PostQueuedCompletionStatus( m_iocp,
										  perIoContext->offset,
										  completionKey,
										  (LPOVERLAPPED)perIoContext );
	if ( retcode == 0 )
	{
		return false;
	}
	return true;;
}

// RecvComplete Method (Default Echo Server)
bool IocpUdpRecv::RecvComplete(ULONG_PTR completionKey, PerIoContext* perIoContext, DWORD bytesTransferred)
{
	cCSLock lock( &m_cs );

	//  Ϸ I/O Context ȸѴ.
	perIoContext->offset = bytesTransferred;
	m_ioContextPool->ReleaseIoContext( perIoContext );

	//   I/O Context غѴ.
	perIoContext = m_ioContextPool->GetIoContext( m_socket, IOCP_REQUEST_READ );
	return RecvPost( completionKey, perIoContext );
}

// CallbackComplete Method
bool IocpUdpRecv::CallbackComplete(ULONG_PTR /*completionKey*/, PerIoContext* perIoContext, DWORD /*bytesTransferred*/)
{
	//  Ϸ I/O Context ȸѴ.
	m_ioContextPool->ReleaseIoContext( perIoContext );
	return true;
}

// WorkerThread Method
DWORD IocpUdpRecv::WorkerThread( )
{
	DWORD             bytesTransferred;
	ULONG_PTR         completionKey;
	OVERLAPPED*       overlapped;
	BOOL              retValue;

	PerIoContext*     perIoContext;

	while ( true )
	{
		// completion port Ҵ   I/O ϷḦ ٸ.
		retValue = GetQueuedCompletionStatus( m_iocp, &bytesTransferred, &completionKey, &overlapped, INFINITE );

		// Shutdown
		if ( overlapped == IOCP_SHUTDOWN )
			return 0;

		perIoContext = (PerIoContext*)overlapped;

		if ( retValue == FALSE || bytesTransferred == 0 )
		{
			//  Ϸ I/O Context ȸѴ.
			perIoContext->offset = max( perIoContext->offset, bytesTransferred );
			m_ioContextPool->ReleaseIoContext( perIoContext );
			continue;
		}

		switch ( perIoContext->requestType )
		{
		case IOCP_REQUEST_READ:
			RecvComplete( completionKey, perIoContext, bytesTransferred );
			break; // Receive Ϸ ڵ鷯 Լ.

		case IOCP_REQUEST_CALLBACK:
			CallbackComplete( completionKey, perIoContext, bytesTransferred );
			break; // Callback Ϸ ڵ鷯 Լ.
		}
	}
	return 0;
}

// BackendThread Method
DWORD IocpUdpRecv::BackendThread( )
{
	while ( true )
	{
		// , Thread .
		if ( m_endServer == true )
			break;

		Sleep( 50 );
	}
	return 0;
}

// WorkerThreadStartingPoint Method ( Worker Thread  Ʈ )
DWORD IocpUdpRecv::WorkerThreadStartingPoint(void* ptr)
{
	IocpUdpRecv* iocpUdpRecv = (IocpUdpRecv*)ptr;
	return iocpUdpRecv->WorkerThread( );
}

// BackendThreadStartingPoint Method ( Backend Thread  Ʈ )
DWORD IocpUdpRecv::BackendThreadStartingPoint(void* ptr)
{
	IocpUdpRecv* iocpUdpRecv = (IocpUdpRecv*)ptr;
	return iocpUdpRecv->BackendThread( );
}
