// Include files
#include "iocpudpsend.h"

// Local definitions
#pragma warning( disable: 4127 )

#define SafeCloseHandle(P)  if (P!=NULL) { CloseHandle(P); (P)=NULL; } // ڵ鸦 ϰ 
#define SafeDelete(P)       if (P!=NULL) { delete(P);      (P)=NULL; } // "

// Global data

// cIocpUdpSend Constructor
cIocpUdpSend::cIocpUdpSend(void)
{
	// Critical Section ʱȭ.
	InitializeCriticalSection( &mCs );

	mIocp                   = NULL;
	mSocket                 = INVALID_SOCKET;
	mIocpWorkerThreadNumber = 0;
	mIoContextPool          = NULL;
	mIocpBackendThread      = NULL;

	mIoContextFrontBuffer   = NULL;
	mIoContextBackBuffer    = NULL;

	mRunServer              = false;
	mEndServer              = false;
}

// ~cIocpUdpSend Destructor.
cIocpUdpSend::~cIocpUdpSend(void)
{
	// 
	Shutdown( );

	// Critical Section .
	DeleteCriticalSection( &mCs );
}

// Initialize Method
bool cIocpUdpSend::Initialize(unsigned short numWorkerThreads)
{
	// CreateIoCompletionPort ̿Ͽ completion port Ʈ   Ϲ Ű  
	// ʹ NumberOfConcurrentThreads ̴. ó 3 Ķʹ   ʴ´.
	//
	// NumberOfConcurrentThreads  completion port Ͽ  带  ΰ 
	// .  ̻   context switching ϱ Ͽ 񽺿 Ͽ ϳ 
	//  ϳ 常 ϵ ϴ ̴. NumberOfConcurrentThreads  0 ϸ 
	//  μ    ҴϿ Ѵ.
	// (ϳ CPU Ͽ IOCP ϳ ϳ 带 )
	
	mIocp = CreateIoCompletionPort( INVALID_HANDLE_VALUE, NULL, 0, 0 );
	if ( mIocp == NULL )
		return false;

	// CreateIoCompletionPort Ʈ  ڿ ۾带 ϰ ڵ   ִµ,
	// ̶ ϴ ۾, 尡 ϵ ɼ ִٸ, NumberOfConcurrentThreads  
	//   ϴ  . NumberOfConcurrentThreadsŭ 尡 ׻ ǰ   ֱ 
	// , ϵ 尡 ִٸ ٸ 尡   ̱ ̴.
	//
	SYSTEM_INFO si;
	DWORD       threadId;

	// ýۿ   μ ִ ȮѴ.
	GetSystemInfo( &si );

	mIocpWorkerThreadNumber = min( si.dwNumberOfProcessors * numWorkerThreads, IOCP_MAX_WORKER_THREAD );
	for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
	{
		mIocpWorkerThread[i] = CreateThread( NULL, 0, WorkerThreadStartingPoint, (LPVOID)this, 0, &threadId );
		if ( mIocpWorkerThread[i] == NULL )
			return false;
	}

	// I/O Context Pool Ѵ.
	// 0xffff: UDP(65,535) ִ Ŷ 
	// 0x0044: IPv4(60) + UDP(8)  ش 
	mIoContextPool = new cIoContextPool( MAX_UDP_PACKET_SIZE );
	if ( mIoContextPool == NULL )
		return false;

	// I/O Context Buffer Ѵ.
	mIoContextFrontBuffer = (IoContextBuffer*)GlobalAlloc( GPTR, sizeof(IoContextBuffer) );
	mIoContextBackBuffer  = (IoContextBuffer*)GlobalAlloc( GPTR, sizeof(IoContextBuffer) );
	if ( !mIoContextFrontBuffer && !mIoContextBackBuffer )
		return false;

	// connect Ŭ̾Ʈ  Ѵ.
	mSocket = WSASocket( AF_INET, SOCK_DGRAM, IPPROTO_UDP, NULL, 0, WSA_FLAG_OVERLAPPED );
	if ( mSocket == INVALID_SOCKET )
		return false;

	// Disable send buffering on the socket. Setting SO_SNDBUF to 0 causes winsock to stop bufferring
	// sends and perform sends directly from our buffers, thereby reducing CPU usage.
	//
	// SO_SNDBUF 0Ͽ ۽Ź۸  ʴ´. ۽Ź۰ 0 ƴϸ ʿϰ  ۽Ź۸
	// ļ overlapped I/O ȣ   ۷ 簡 ̷.
	// ۽Ź   overlapped I/O ȣ   ۷ ýۿ  Ͱ 
	// .
	//
	int zero = 0;
	if ( setsockopt( mSocket, SOL_SOCKET, SO_SNDBUF, (char*)&zero, sizeof(zero) ) == SOCKET_ERROR )
	{
		closesocket( mSocket );
		return false;
	}

	//   ڵ completion port ҴѴ.
	if ( CreateIoCompletionPort( (HANDLE)mSocket, mIocp, (ULONG_PTR)NULL, 0 ) == NULL )
	{
		closesocket( mSocket );
		return false;
	}

	mEndServer = false;
	mRunServer = true;

	// Backend Thread Ѵ.
	mIocpBackendThread = CreateThread( NULL, 0, BackendThreadStartingPoint, (LPVOID)this, 0, &threadId );
	if ( mIocpBackendThread == NULL )
		return false;

	return true;
}

// Shutdown Method
void cIocpUdpSend::Shutdown(DWORD maxWait)
{
	// ϰ Ѵ.
	mEndServer = true;
	mRunServer = false;

	// Backend Thread ɶ 
	if ( mIocpBackendThread != NULL )
	{
		WaitForSingleObjectEx( mIocpBackendThread, maxWait, TRUE );
		CloseHandle( mIocpBackendThread );
		mIocpBackendThread = NULL;
	}

	// ϰ Ѵ.
	SOCKET sockTemp = mSocket;;

	mSocket = INVALID_SOCKET;

	if ( sockTemp != INVALID_SOCKET )
	{
		closesocket( sockTemp );
	}

	// Cause worker threads to exit
	if ( mIocp != NULL )
	{
		for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
		{
			PostQueuedCompletionStatus( mIocp, 0, 0, IOCP_SHUTDOWN );
		}
	}

	// Make sure worker threads exits.
	for ( int i = 0; i < mIocpWorkerThreadNumber; i++ )
	{
		if ( WaitForSingleObject( mIocpWorkerThread[i], 60000 ) != WAIT_OBJECT_0 )
		{
			DWORD exitCode;
			GetExitCodeThread( mIocpWorkerThread[i], &exitCode);
			if ( exitCode == STILL_ACTIVE )
			{
				TerminateThread( mIocpWorkerThread[i], 0 );
			}
		}
		CloseHandle( mIocpWorkerThread[i] );
		mIocpWorkerThread[i] = NULL;
	}

	// Overlapped I/O Model Pool Socket Context Pool Ѵ.
	if ( mIoContextFrontBuffer )
	{
		GlobalFree( mIoContextFrontBuffer );
		mIoContextFrontBuffer = NULL;
	}
	if ( mIoContextBackBuffer )
	{
		GlobalFree( mIoContextBackBuffer );
		mIoContextBackBuffer = NULL;
	}
	// Overlapped I/O Model Pool Ѵ.
	SafeDelete( mIoContextPool );

	// completion port Ѵ.
	SafeCloseHandle( mIocp );
}

// GetIoPoolUsage Method
void cIocpUdpSend::GetIoPoolUsage(SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonePagedPoolUsage, SIZE_T& workingSetSize)
{
	if ( mIoContextPool != NULL )
	{
		mIoContextPool->GetProcessMemoryInfo( quotaPagedPoolUsage, quotaNonePagedPoolUsage, workingSetSize );
	}
}

// QueueRequest Method
BOOL cIocpUdpSend::QueueRequest(ULONG_PTR completionKey, LPOVERLAPPED overlapped, DWORD bytesTransferred)
{
	return PostQueuedCompletionStatus( mIocp, bytesTransferred, completionKey, overlapped );
}

// SendExec Method
bool cIocpUdpSend::SendExec(PerIoContext* perIoContext)
{
	WSABUF wsaBuf;
	DWORD  sendBytes = 0;
	DWORD  flags     = 0;
	int    addrlen   = sizeof(SOCKADDR_IN);
	int    retcode;

	if ( perIoContext->offset > perIoContext->length )
	{
		PostQueuedCompletionStatus( mIocp, 0, (ULONG_PTR)NULL, (LPOVERLAPPED)perIoContext );
		return false;
	}

	wsaBuf.len = perIoContext->offset;
	wsaBuf.buf = perIoContext->buffer;

	retcode = WSASendTo( perIoContext->socket,
						 &wsaBuf,
						 1,
						 &sendBytes,
						 flags,
						 (SOCKADDR*)&perIoContext->addr,
						 addrlen,
						 &(perIoContext->wsaOverlapped),
						 NULL );

	if ( (retcode == SOCKET_ERROR) && (WSAGetLastError() != WSA_IO_PENDING) )
	{
		PostQueuedCompletionStatus( mIocp, 0, (ULONG_PTR)NULL, (LPOVERLAPPED)perIoContext );
		return false;
	}
	return true;
}

// SendPost Method
bool cIocpUdpSend::SendPost(PerIoContext* perIoContext)
{
	cCSLock        lock( &mCs );
	PerIoContext** buffer = mIoContextBackBuffer->buffer;
	long&          offset = mIoContextBackBuffer->offset;

	if ( offset < MAX_IO_CONTEXT_BUFFER_LEN )
	{
		buffer[ offset ] = perIoContext;
		offset++;
		return true;
	}

	mIoContextPool->ReleaseIoContext( perIoContext );
	return false;
}

/*-- IoContextPresent Method
*/
void cIocpUdpSend::IoContextPresent( )
{
	IoContextBuffer* temp;

	// Double Buffering ó.
	EnterCriticalSection( &mCs );

		temp                  = mIoContextBackBuffer;
		mIoContextBackBuffer  = mIoContextFrontBuffer;
		mIoContextFrontBuffer = temp;

	LeaveCriticalSection( &mCs );

	// ߽ŵ  ó.
	PerIoContext** buffer = mIoContextFrontBuffer->buffer;
	long&          offset = mIoContextFrontBuffer->offset;

	while ( offset > 0 )
	{
		SendExec( (*buffer) );
		(*buffer) = NULL;

		buffer++;
		offset--;

		Sleep( 10 );
	}
}

// SendComplete Method
bool cIocpUdpSend::SendComplete(ULONG_PTR     /*completionKey*/,
							    PerIoContext* perIoContext,
							    DWORD         /*bytesTransferred*/)
{
	//  Ϸ I/O Context ȸѴ.
	mIoContextPool->ReleaseIoContext( perIoContext );
	return true;
}

// CallbackComplete Method
bool cIocpUdpSend::CallbackComplete(ULONG_PTR     /*completionKey*/,
								    PerIoContext* perIoContext,
								    DWORD         /*bytesTransferred*/)
{
	//  Ϸ I/O Context ȸѴ.
	mIoContextPool->ReleaseIoContext( perIoContext );
	return true;
}

// WorkerThread Method
DWORD cIocpUdpSend::WorkerThread( )
{
	DWORD         bytesTransferred;
	ULONG_PTR     completionKey;
	OVERLAPPED*   overlapped;
	BOOL          retValue;

	PerIoContext* perIoContext;

	while ( true )
	{
		// completion port Ҵ   I/O ϷḦ ٸ.
		retValue = GetQueuedCompletionStatus( mIocp, &bytesTransferred, &completionKey, &overlapped, INFINITE );

		// Shutdown
		if ( overlapped == IOCP_SHUTDOWN )
			return 0;

		perIoContext = (PerIoContext*)overlapped;

		if ( retValue == FALSE || bytesTransferred == 0 )
		{
			if ( perIoContext != NULL )
			{
				//  Ϸ I/O Context ȸѴ.
				perIoContext->offset = max( perIoContext->offset, bytesTransferred );
				mIoContextPool->ReleaseIoContext( perIoContext );
			}
			continue;
		}

		switch ( perIoContext->requestType )
		{
		case IOCP_REQUEST_WRITE:
			SendComplete( completionKey, perIoContext, bytesTransferred );
			break; // Send Ϸ ڵ鷯 Լ.

		case IOCP_REQUEST_CALLBACK:
			CallbackComplete( completionKey, perIoContext, bytesTransferred );
			break; // Callback Ϸ ڵ鷯 Լ.
		}
	}
	return 0;
}

// BackendThread Method
DWORD cIocpUdpSend::BackendThread( )
{
	while ( mEndServer != true )
	{
		IoContextPresent( );
		Sleep( 50 );
	}

	IoContextPresent( );
	Sleep( 1000 );
	return 0;
}

// WorkerThreadStartingPoint Method ( Worker Thread  Ʈ )
DWORD cIocpUdpSend::WorkerThreadStartingPoint(void* ptr)
{
	cIocpUdpSend* iocpUdpSend = (cIocpUdpSend*)ptr;
	return iocpUdpSend->WorkerThread( );
}

// BackendThreadStartingPoint Method ( Backend Thread  Ʈ )
DWORD cIocpUdpSend::BackendThreadStartingPoint(void* ptr)
{
	cIocpUdpSend* iocpUdpSend = (cIocpUdpSend*)ptr;
	return iocpUdpSend->BackendThread( );
}
