// Include
#include "registryEdit.h"

// Local definitions

// Global data

// cRegistryEdit Constructor
cRegistryEdit::cRegistryEdit(void) : m_key(NULL)
{
}

// ~cRegistryEdit Destructor.
cRegistryEdit::~cRegistryEdit(void)
{
	CloseKey( );
}

// OpenKey Method
// HKEY key = HKEY_CLASSES_ROOT
//            HKEY_CURRENT_USER
//            HKEY_LOCAL_MACHINE
//            HKEY_USERS
bool cRegistryEdit::OpenKey(HKEY key, LPTSTR subKey)
{
	if ( RegOpenKeyEx( key, subKey, 0, KEY_ALL_ACCESS, &m_key ) == ERROR_SUCCESS )
	{
		return true;
	}
	else
	{
		CloseKey( );
		return false;
	}
}

// CloseKey Method
void cRegistryEdit::CloseKey(void)
{
	if ( m_key != NULL )
	{
		RegCloseKey( m_key );
		m_key = NULL;
	}
}

// CreateKey Method
// DWORD& disp[out] = REG_CREATED_NEW_KEY, REG_OPENED_EXISTING_KEY
bool cRegistryEdit::CreateKey(HKEY key, LPTSTR subKey, DWORD& disp)
{
	if ( RegCreateKeyEx( key, subKey, 0, NULL, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &m_key, &disp ) == ERROR_SUCCESS )
	{
		return true;
	}
	else
	{
		CloseKey( );
		return false;
	}
}

// DeleteKey Method
bool cRegistryEdit::DeleteKey(HKEY key, LPTSTR subKey)
{	
	return (RegDeleteKey( key, subKey ) == ERROR_SUCCESS) ? true : false;
}

// GetValue Method
bool cRegistryEdit::GetValue(LPTSTR valueName, LPTSTR valueData, DWORD size)
{
	DWORD type = REG_EXPAND_SZ;

	if ( RegQueryValueEx( m_key, valueName, NULL, &type, (LPBYTE)valueData, &size ) == ERROR_SUCCESS )
	{
		return true;
	}
	else
	{
		CloseKey( );
		return false;
	}
}

// GetValue Method
bool cRegistryEdit::GetValue(LPTSTR valueName, DWORD& valueData, DWORD size)
{
	DWORD type = REG_DWORD;

	if ( RegQueryValueEx( m_key, valueName, NULL, &type, (LPBYTE)&valueData, &size ) == ERROR_SUCCESS )
	{
		return true;
	}
	else
	{
		CloseKey( );
		return false;
	}
}

// SetValue Method
bool cRegistryEdit::SetValue(LPTSTR valueName, LPTSTR valueData)
{
	if ( RegSetValueEx( m_key, valueName, 0, REG_EXPAND_SZ, (LPBYTE)valueData, (DWORD)lstrlen(valueData)+1 ) == ERROR_SUCCESS )
	{
		return true;
	}
	else
	{
		CloseKey( );
		return false;
	}
}

// SetValue Method
bool cRegistryEdit::SetValue(LPTSTR valueName, DWORD valueData)
{
	if ( RegSetValueEx( m_key, valueName, 0, REG_DWORD, (LPBYTE)&valueData, sizeof(valueData) ) == ERROR_SUCCESS )
	{
		return true;
	}
	else
	{
		CloseKey( );
		return false;
	}
}

// DeleteValue Method
bool cRegistryEdit::DeleteValue(LPTSTR valueName)
{
	return (RegDeleteValue( m_key, valueName ) == ERROR_SUCCESS) ? true : false;
}
