/* ====================================================================
 *      :	registryEdit.h
 *      :	
 *    :	ö
 *    :	06/10/31
 * ǻ :	
 * =================================================================== */
#ifndef __REGISTRY_EDIT_H__
#define __REGISTRY_EDIT_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#ifndef REGISTRY_EDIT_VER
#define REGISTRY_EDIT_VER 0x0001
#else
#if defined(REGISTRY_EDIT_VER) && (REGISTRY_EDIT_VER < 0x0001)
#error REGISTRY_EDIT_VER setting conflicts
#endif
#endif

#pragma once

//  
#include <windows.h>

class cRegistryEdit
{
private:
	HKEY m_key;
public:
	cRegistryEdit(void);

	bool OpenKey     ( HKEY key, LPTSTR subKey );
	void CloseKey    ( void );

	bool CreateKey   ( HKEY key, LPTSTR subKey, DWORD& disp );
	bool DeleteKey   ( HKEY key, LPTSTR subKey );

	bool GetValue    ( LPTSTR valueName, LPTSTR valueData, DWORD size );
	bool GetValue    ( LPTSTR valueName, DWORD& valueData, DWORD size=sizeof(DWORD) );

	bool SetValue    ( LPTSTR valueName, LPTSTR valueData );
	bool SetValue    ( LPTSTR valueName, DWORD  valueData );

	bool DeleteValue ( LPTSTR valueName );
public:
	virtual ~cRegistryEdit(void);
};

#endif // __REGISTRY_EDIT_H__