// Include
#include <winsock2.h>

#include "sqlpool.h"
#include "iocontextpool.h"

// Local definitions
#pragma warning( disable: 4127 )

// memory ϰ 
#define SafeDelete(P) if (P!=NULL) { delete(P); (P)=NULL; }

// Global data

// cSQLPool Constructor.
cSQLPool::cSQLPool(void)
{
	// Critical Section ʱȭ.
	InitializeCriticalSection( &mCs );

	// SQLEnvironment ʱȭ.
	mSqlEnv                 = NULL;

	// SQLConnection ʱȭ.
	mPagedPoolUsage         = NULL;
	mNonPagedPoolUsage      = NULL;

	// ޸ ī ʱȭ.
	mQuotaPagedPoolUsage    = 0;
	mQuotaNonPagedPoolUsage = 0;
	mWorkingSetSize         = 0;
	mPeakWorkingSetSize     = 0;

	memset( mDsn, 0, sizeof(mDsn) );
	memset( mUid, 0, sizeof(mUid) );
	memset( mPwd, 0, sizeof(mPwd) );
}

// ~cSQLPool Destructor.
cSQLPool::~cSQLPool(void)
{
	// cSQLPool ThreadPool Ѵ.
	Shutdown( );

	// Critical Section .
	DeleteCriticalSection( &mCs );
}

// GetProcessMemoryInfo Method.
void cSQLPool::GetProcessMemoryInfo(SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonPagedPoolUsage, SIZE_T& workingSetSize)
{
	cCSLock lock( &mCs );
	quotaPagedPoolUsage    = mQuotaPagedPoolUsage;
	quotaNonPagedPoolUsage = mQuotaNonPagedPoolUsage;
	workingSetSize         = mWorkingSetSize;
}

// Initialize Method - ThreadPool::Initialize ġ !
bool cSQLPool::Initialize(char* dsn, char* uid, char* pwd, int numWorkerThreads)
{
	// SQLServer   ODBC ȯ .
	mSqlEnv  = new cSQLEnvironment( );

	// Audit .
	strcpy( mDsn, dsn );
	strcpy( mUid, uid );
	strcpy( mPwd, pwd );

	// ODBC, SQL  ʱȭ.
	if ( mSqlEnv->AllocEnv( ) == false )
		return false;

	// SQL_ATTR_ODBC_VERSION  SQL_OV_ODBC3  .
	if ( mSqlEnv->SetEnvAttr( ) == false )
		return false;

	// ThreadPool Class ʱȭ.
	// 3° Ű Լ numWorkerThreads CPU * 4 .
	return cThreadPool::Initialize( INVALID_HANDLE_VALUE, 0, numWorkerThreads );
}

// Shutdown Method - ThreadPool::Shutdown ġ !
void cSQLPool::Shutdown(void)
{
	// ThreadPool Class .
	cThreadPool::Shutdown( );

	// SQL Context .
	cCSLock           lock( &mCs );
	PerSQLConnection* temp;

	while ( mPagedPoolUsage != NULL )
	{
		temp               = mPagedPoolUsage;
		mPagedPoolUsage    = mPagedPoolUsage->next;
		FreeSQLConnection( &temp );
	}
	while ( mNonPagedPoolUsage != NULL )
	{
		temp               = mNonPagedPoolUsage;
		mNonPagedPoolUsage = mNonPagedPoolUsage->next;
		FreeSQLConnection( &temp );
	}

	// ODBC, SQL  .
	if ( mSqlEnv != NULL )
	{
		mSqlEnv->FreeEnv( );
	}

	// ODBC, SQL ޸𸮸 .
	SafeDelete( mSqlEnv );
}

// AllocSQLConnection Method
PerSQLConnection* cSQLPool::AllocSQLConnection(void)
{
	PerSQLConnection* perSQLConnection = (PerSQLConnection*)GlobalAlloc( GPTR, sizeof(PerSQLConnection) );

	if ( perSQLConnection != NULL )
	{
		// PerSQLConnection - ʱȭ
		perSQLConnection->sqlConnection = new cSQLConnection( );  // 1. SQLConnection .
		perSQLConnection->sqlStatement  = new cSQLStatement( );   // 2. SQLStatement  .
		perSQLConnection->prev          = NULL;                   // Ʈ  - .
		perSQLConnection->next          = NULL;                   // Ʈ  - .

		// Ŭ  Ȯ.
		if ( perSQLConnection->sqlConnection != NULL && perSQLConnection->sqlStatement != NULL )
		{
			// SQLEnvironment Ŭ Ͽ ڵ .
			if ( perSQLConnection->sqlConnection->AllocDbc( mSqlEnv ) == true )
			{
				// DBC .
				if ( perSQLConnection->sqlConnection->Connect( (SQLCHAR*)mDsn, (SQLCHAR*)mUid, (SQLCHAR*)mPwd ) == true )
				{
					// SQLConnectionŬ Ͽ ڵ .
					if ( perSQLConnection->sqlStatement->AllocStmt( perSQLConnection->sqlConnection ) == true )
					{
						// mWorkingSetSize .
						mWorkingSetSize++;
						return perSQLConnection;
					}
				}
			}
		}
	}

	FreeSQLConnection( &perSQLConnection );
	return perSQLConnection;
}

// FreeSQLConnection Method
void cSQLPool::FreeSQLConnection(PerSQLConnection** perSQLConnection)
{
	if ( perSQLConnection != NULL )
	{
		SafeDelete( (*perSQLConnection)->sqlStatement );  // 1. SQLStatement  .
		SafeDelete( (*perSQLConnection)->sqlConnection ); // 2. SQLConnection .

		GlobalFree( (*perSQLConnection) );
		(*perSQLConnection) = NULL;

		// mWorkingSetSize .
		mWorkingSetSize--;
	}
}

// AttachPool Method - POOL   .
void cSQLPool::AttachPool(PerSQLConnection** pool, PerSQLConnection* perSQLConnection)
{
	if ( (*pool) != NULL )
	{
		(*pool)->prev = perSQLConnection;

		perSQLConnection->prev = NULL;
		perSQLConnection->next = (*pool);
	}
	(*pool) = perSQLConnection;
}

// DetachPool Method - POOL   .
void cSQLPool::DetachPool(PerSQLConnection** pool, PerSQLConnection* perSQLConnection)
{
	PerSQLConnection* prev = perSQLConnection->prev;
	PerSQLConnection* next = perSQLConnection->next;

	if ( prev == NULL && next == NULL )
	{
		(*pool) = NULL;
	}
	else if ( prev == NULL && next != NULL )
	{
		next->prev = NULL;
		(*pool) = next;
	}
	else if ( prev != NULL && next == NULL )
	{
		prev->next = NULL;
	}
	else if ( prev != NULL && next != NULL )
	{
		prev->next = next;
		next->prev = prev;
	}

	perSQLConnection->prev = NULL;
	perSQLConnection->next = NULL;
}

// GetPool Method
// ReleasePool Բ LIFO ̷. LIFO Context Switching ּȭ ϱ  
PerSQLConnection* cSQLPool::GetPool(void)
{
	cCSLock           lock( &mCs );
	PerSQLConnection* perSQLConnection = mNonPagedPoolUsage;

	if ( perSQLConnection != NULL )
	{
		//  ȵ Ǯ 뷮 .
		DetachPool( &mNonPagedPoolUsage, perSQLConnection );
		mQuotaNonPagedPoolUsage--;

		//  ӻ° Ǵ Ȯ.
		if ( perSQLConnection->sqlConnection->ConnectionDead( ) )
		{
			FreeSQLConnection( &perSQLConnection );
		}
	}

	if ( perSQLConnection == NULL )
	{
		//     .
		perSQLConnection = AllocSQLConnection( );
	}

	if ( perSQLConnection != NULL )
	{
		//   Ǯ 뷮 .
		AttachPool( &mPagedPoolUsage, perSQLConnection );
		mQuotaPagedPoolUsage++;
	}

	return perSQLConnection;
}

// ReleasePool Method
// GetPool Բ LIFO ̷. LIFO Context Switching ּȭ ϱ  
void cSQLPool::ReleasePool(PerSQLConnection* perSQLConnection, bool isDelete)
{
	cCSLock lock( &mCs );

	//   Ǯ 뷮 .
	DetachPool( &mPagedPoolUsage, perSQLConnection );
	mQuotaPagedPoolUsage--;

	if ( isDelete != true )
	{
		//  ȵ Ǯ 뷮 .
		AttachPool( &mNonPagedPoolUsage, perSQLConnection );
		mQuotaNonPagedPoolUsage++;
	}
	else
	{
		//  .
		FreeSQLConnection( &perSQLConnection );
	}
}

// WorkerThread Method
DWORD cSQLPool::WorkerThread(void)
{
	PerSQLConnection* perSQLConnection = NULL;
	PerIoContext*     perIoContext     = NULL;
	BOOL              retValue;

	DWORD             bytesTransfered;
	ULONG_PTR         completionKey;
	OVERLAPPED*       overlapped;

	while ( true )
	{
		//  I/O .
		retValue = GetQueuedCompletionStatus( mRequestQueue, &bytesTransfered, &completionKey, &overlapped, INFINITE );

		// Shutdown.
		if ( overlapped == POOL_SHUTDOWN )
			break;

		// Error - .
		if ( retValue == FALSE || bytesTransfered == 0 ) 
			continue;

		// SQLConnection - .
		perSQLConnection = GetPool( );

		// SQLConnection - Ȯ.
		if ( perSQLConnection == NULL )
		{
			// 1( ), ð 10/1000(s) - CPU ȭ  .
			Sleep( 10 );

			// 2( ),   Ǿ , ٽ õ.
			QueueRequest( completionKey, overlapped, bytesTransfered );
			continue;
		}

		// OVERLAPPED PerIoContext ɽ.
		perIoContext = (PerIoContext*)overlapped;

		// 1. SQL 
		// 2. PerIoContext ȷ.

		// SQLConnection - .
		ReleasePool( perSQLConnection );
	}
	return 0L;
}
