/* ====================================================================
 *      :	sqlPool.h
 *      :	
 *    :	ö
 *    :	07/01/10
 * ǻ :	
 * =================================================================== */
#ifndef __SQL_POOL_H__
#define __SQL_POOL_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

#include "odbcsql.h"
#include "threadpool.h"
#include "criticalsectionlock.h"


#ifndef PER_SQL_CONNECTION
#define PER_SQL_CONNECTION

struct PerSQLConnection
{
	cSQLConnection*          sqlConnection;     // SQL Connection
	cSQLStatement*           sqlStatement;      // SQL Statement
	struct PerSQLConnection* next;              // Dual Linked List  
	struct PerSQLConnection* prev;              // Dual Linked List  
};

#endif // PER_SQL_CONNECTION


class cSQLPool :
	public cThreadPool
{
protected:
// ȯ溯.
	CRITICAL_SECTION          mCs;
	cSQLEnvironment*          mSqlEnv;

	PerSQLConnection*         mPagedPoolUsage;         //   Ǯ
	PerSQLConnection*         mNonPagedPoolUsage;      //  ȵ Ǯ
	SIZE_T                    mQuotaPagedPoolUsage;    //    Ǯ   - 뷮
	SIZE_T                    mQuotaNonPagedPoolUsage; //   ȵ Ǯ - 뷮
	SIZE_T                    mWorkingSetSize;         //  ۾ ũ.
	SIZE_T                    mPeakWorkingSetSize;     // ִ ۾ ũ.

	char                      mDsn[MAX_PATH];          // DataSource
	char                      mUid[MAX_PATH];          // UserID
	char                      mPwd[MAX_PATH];          // Password

protected:
// Page Pool  ޼ҵ.
	virtual PerSQLConnection* AllocSQLConnection   ( void );
	virtual void              FreeSQLConnection    ( PerSQLConnection** perSQLConnection );

	void                      AttachPool           ( PerSQLConnection** pool, PerSQLConnection* perSQLConnection );
	void                      DetachPool           ( PerSQLConnection** pool, PerSQLConnection* perSQLConnection );

	PerSQLConnection*         GetPool              ( void );
	void                      ReleasePool          ( PerSQLConnection* perSQLConnection, bool isDelete=false );

public:
// Ŭ    ޼ҵ.
	cSQLPool(void);

	virtual void              GetProcessMemoryInfo ( SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonPagedPoolUsage, SIZE_T& workingSetSize );

	virtual bool              Initialize           ( char* dsn, char* uid, char* pwd, int numWorkerThreads=2 );
	virtual void              Shutdown             ( void );

	virtual DWORD             WorkerThread         ( void );

public:
// Ŭ ı ޼ҵ.
	virtual ~cSQLPool(void);
};

#endif // __SQL_POOL_H__