// Include files
#include "threadpool.h"

// Local definitions

// Global data

// cThreadPool Constructor
cThreadPool::cThreadPool(void) : mRequestQueue(NULL), mWorkerThreadNumber(0)
{
}

// ~cThreadPool Destructor
cThreadPool::~cThreadPool(void)
{
	Shutdown( );
}

// Initialize Method
bool cThreadPool::Initialize(HANDLE completion, int numThreads, int numWorkerThreads)
{
	// CreateIoCompletionPort ̿Ͽ completion port Ʈ   Ϲ Ű  
	// ʹ NumberOfConcurrentThreads ̴. ó 3 Ķʹ   ʴ´.
	//
	// NumberOfConcurrentThreads  completion port Ͽ  带  ΰ 
	// .  ̻   context switching ϱ Ͽ 񽺿 Ͽ ϳ 
	//  ϳ 常 ϵ ϴ ̴. NumberOfConcurrentThreads  0 ϸ 
	//  μ    ҴϿ Ѵ.
	// (ϳ CPU Ͽ IOCP ϳ ϳ 带 )
	mRequestQueue = CreateIoCompletionPort( completion, NULL, 0, numThreads );

	// CreateIoCompletionPort Ʈ  ڿ ۾带 Ѵ. ̶ ϴ ۾,
	// 尡 ϵ ɼ ִٸ, NumberOfConcurrentThreads    ϴ  .
	// NumberOfConcurrentThreadsŭ 尡 ׻ ǰ   ֱ , ϵ 尡 ִٸ 
	//  尡   ̱ ̴.
	SYSTEM_INFO si;
	DWORD       threadId;

	GetSystemInfo(&si);

	mWorkerThreadNumber = min( si.dwNumberOfProcessors * numWorkerThreads, MAX_WORKER_THREAD );
	for ( int i = 0; i < mWorkerThreadNumber; i++ )
	{
		mWorkerThread[i] = CreateThread( NULL, 0, WorkerThreadStartingPoint, (LPVOID)this, 0, &threadId );
	}

	return (mRequestQueue != NULL) ? true : false;
}

// Shutdown Method
void cThreadPool::Shutdown( )
{
	// Not initialized
	if ( mRequestQueue == NULL )
		return;

	// Cause worker threads to exit
	if ( mRequestQueue != NULL )
	{
		for ( int i = 0; i < mWorkerThreadNumber; i++ )
		{
			PostQueuedCompletionStatus( mRequestQueue, 0, 0, POOL_SHUTDOWN );
		}
	}

	// Make sure worker threads exits.
	for ( int i = 0; i < mWorkerThreadNumber; i++ )
	{
		if ( WaitForSingleObject( mWorkerThread[i], 60000 ) != WAIT_OBJECT_0 )
		{
			DWORD exitCode;
			GetExitCodeThread( mWorkerThread[i], &exitCode);
			if ( exitCode == STILL_ACTIVE )
			{
				TerminateThread( mWorkerThread[i], 0 );
			}
		}
		CloseHandle( mWorkerThread[i] );
		mWorkerThread[i] = NULL;
	}

	// Close the request queue handle
	CloseHandle( mRequestQueue );

	// Clear the queue handle
	mRequestQueue = NULL;
}

// QueueRequest Method
BOOL cThreadPool::QueueRequest(ULONG_PTR completionKey, LPOVERLAPPED overlapped, DWORD bytesTransferred)
{
	return PostQueuedCompletionStatus( mRequestQueue, bytesTransferred, completionKey, overlapped );
}

// WorkerThread Method
DWORD cThreadPool::WorkerThread( )
{
	DWORD       bytesTransferred;
	ULONG_PTR   completionKey;
	OVERLAPPED* overlapped;

	while ( GetQueuedCompletionStatus( mRequestQueue, &bytesTransferred, &completionKey, &overlapped, INFINITE) )
	{
		// Shut down
		if ( overlapped == POOL_SHUTDOWN )
			break;
	}

	return 0L;
}

// WorkerThreadStartingPoint Method
DWORD cThreadPool::WorkerThreadStartingPoint(void* ptr)
{
	cThreadPool* threadPool = (cThreadPool*)ptr;
	return threadPool->WorkerThread( );
}
