/* ====================================================================
 *      :	logProtocol.h
 *      :	
 *    :	ö
 *    :	06/12/26
 * ǻ :	
 * =================================================================== */
#ifndef __LOG_PROTOCOL_H__
#define __LOG_PROTOCOL_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

//  
#include <windows.h>

// IRIS Common Ports
#define U_LOG_SPORT           15000

enum LOG_PROTOCOL
{
	MB_SERVER_EVENT = 0,
	MB_MEMBER_EVENT,
	MB_CHARACTER_EVENT,
	MB_MONEY_EVENT,
	MB_INVENTORY_EVENT,
	MB_CONCURRENT_EVENT,
	MB_DEPOSIT_EVENT,
	MB_QUEST_EVENT,
	MB_GUILD_EVENT,
};

// 1Byte  
#pragma pack(1)

#ifndef _MSGBUF_
#define _MSGBUF_
struct MSGBUF
{
//	char category;
	char protocol;
};
#endif

#ifndef SOURCE_BUF
#define SOURCE_LEN      50
#define SOURCE_BUF      SOURCE_LEN+1
#endif

#ifndef COMPUTER_BUF
#define COMPUTER_LEN    132
#define COMPUTER_BUF    COMPUTER_LEN+1
#endif

#ifndef ANY_SIZE
#define ANY_SIZE     1
#endif

struct SERVER_EVENT : MSGBUF
{
	TIMESTAMP_STRUCT registerDate;
	char             source[ SOURCE_BUF ];
	char             computer[ COMPUTER_BUF ];
	char             message[ ANY_SIZE ];
};


#define EVENT_MEMBER_SUCCESS_AUDIT	0
#define EVENT_MEMBER_FAILURE_AUDIT	1
#define EVENT_MEMBER_TIMEOUT        2
#define EVENT_MEMBER_LOGIN			0
#define EVENT_MEMBER_LOGOUT			(~0)

struct MEMBER_EVENT : MSGBUF
{
	TIMESTAMP_STRUCT registerDate;
	char             type;
	char             source[ SOURCE_BUF ];
	char             category;
	long             memberIdx;
	char             computer[ COMPUTER_BUF ];
	char             message[ ANY_SIZE ];
};

#define EVENT_CHARACTER_CREATE		0
#define EVENT_CHARACTER_DELETE		1
#define EVENT_CHARACTER_UPDATE		2

struct CHARACTER_EVENT : MSGBUF
{
	TIMESTAMP_STRUCT registerDate;
	char             category;
	long             memberIdx;
	long             serverIdx;
	long             characterIdx;
	char             computer[ COMPUTER_BUF ];
	char             message[ ANY_SIZE ];
};

struct MONEY_EVENT : MSGBUF
{
	TIMESTAMP_STRUCT registerDate;
	long             serverIdx;
	long             characterIdx;
	long             before;
	long             after;
	char             computer[ COMPUTER_BUF ];
	char             message[ ANY_SIZE ];
};

struct DEPOSIT_EVENT : MSGBUF
{
	TIMESTAMP_STRUCT registerDate;
	long             serverIdx;
	long             characterIdx;
	long             before;
	long             after;
	char             computer[ COMPUTER_BUF ];
	char             message[ ANY_SIZE ];
};

#define EVENT_INVENTORY_CREATE		0
#define EVENT_INVENTORY_DELETE		1
#define EVENT_INVENTORY_UPDATE		2

struct INVENTORY_EVENT : MSGBUF
{
	TIMESTAMP_STRUCT registerDate;
	long             serverIdx;
	char             category;
	long             inventoryIdx;
	long             characterIdx;
	long             itemDefineIndex;
	short            number;
	short            count;
	BYTE             enhanced;
	BYTE             seal;
	char             computer[ COMPUTER_BUF ];
	char             message[ ANY_SIZE ];
};

#define EVENT_QUEST_ADD				0
#define EVENT_QUEST_UPDATE			1
#define EVENT_QUEST_DELETE			2
#define EVENT_QUEST_COMPLETE		3
#define EVENT_QUEST_REWARD			4
#define EVENT_QUEST_REMOVE			7
#define EVENT_QUEST_TIMESELECT		8

struct QUEST_EVENT : MSGBUF
{
	TIMESTAMP_STRUCT registerDate;
	long             serverIdx;
	char             category;
	long             characterIdx;
	long             questIdx;
	char             computer[ COMPUTER_BUF ];
	char             message[ ANY_SIZE ];
};

struct GUILD_EVENT : MSGBUF
{
	TIMESTAMP_STRUCT registerDate;
	long             serverIdx;
	long             characterIdx;
	long             guildIdx;
	char			 guildPosition;
	char             computer[ COMPUTER_BUF ];
	char             message[ ANY_SIZE ];
};

struct CONCURRENT_EVENT : MSGBUF
{
	TIMESTAMP_STRUCT registerDate;
	long             serverIdx;
	long             minimum;
	long             maximum;
	char             computer[ COMPUTER_BUF ];
	char             message[ ANY_SIZE ];
};

// 1Byte  
#pragma pack( )

#endif // __LOG_PROTOCOL_H__