/* ====================================================================
 *      :	serverProtocol.h
 *      :	
 *    :	ö
 *    :	06/12/26
 * ǻ :	
 * =================================================================== */
#ifndef __SERVERL_PROTOCOL_H__
#define __SERVERL_PROTOCOL_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

//  
#include <windows.h>

// IRIS Login Srv Ports
#define T_LOGIN_CPORT			14400

// IRIS Game Srv Ports
#define T_GAME_CPORT			14600

// IRIS Common Ports
#define U_LOGIN_SPORT			15002
#define U_GAME_SPORT			15004

// IRIS Server & Channel
#define MAX_SERVER		20					// ִ 
#define MAX_CHANNEL		20					// ִ äμ

#define MAKECID(S,C) (((S<<16)&0xffff0000)|(C&0x0000ffff))

enum CHANNEL_NUMBER
{
	CHN_01 =  1,						//  ä
	CHN_10 = 10,						//  ä
	CHN_11,								//  ä-PVP
};

#define STATUS_SYNC_INIT		0		// 00
#define STATUS_SYNC_TIME		20000	// 20
#define STATUS_SYNC_WAIT		60000	// 60

//  (0غ/1Ȱ/2/3ȥ)
enum SERVER_STATUS
{
	_E_STATUS_CLOSED_ = 0,				// ϵ ä  
	_E_STATUS_RUNABLE_,					// ۾ 
	_E_STATUS_RUNNING_S1_,				// ۾ ϰ  - Ϲ    (Ȱ)
	_E_STATUS_RUNNING_S2_,				// ۾ ϰ  - Ϲ    ()
	_E_STATUS_RUNNING_S3_,				// ۾ ϰ  - Ϲ    (ȥ)
	_E_STATUS_CLOSING_,					// ä ݱ

	_E_STATUS_FIN_WAIT1_,				//   1
	_E_STATUS_FIN_WAIT2_,				//   2
	_E_STATUS_LAST_ACK_,				//  Ȯ
	_E_STATUS_DELETE_,					// 
	_E_STATUS_ERROR_,					// ߻
};

enum PVP_STATUS
{
	_E_PVP_CLOSED_ = 0,					// (Ϸ)
	_E_PVP_RUNABLE_,					// ۾ 
	_E_PVP_RUNNING_,					// ۾ ϰ 
	_E_PVP_CLOSING_,					// 
};

enum SERVER_PROTOCOL
{
	// ä
	MB_CH_SYNC_SYN = 0,
	MB_CH_LIST_SYN,
	MB_CH_STATUS_SYN,

	// 
	MB_SERVER_NOTICE_SYN,

	// ä
	MB_CHAT_SHOUT_SYN,
	MB_CHAT_SYN,

	// PVP
	MB_PVP_STATUS_SYN,
	MB_PVP_NOTICE_SYN,

	// 
	MB_GUILD_SYNC_SYN,
	MB_GUILD_CONNECTSYNC_SYN,

	// 
	MB_MONSTER_SYN_SYN,
};

// 1Byte  
#pragma pack(1)

#ifndef _MSGBUF_
#define _MSGBUF_
struct MSGBUF
{
//	char category;
	char protocol;
};
#endif

// SERVER_PROTOCOL::MB_CH_SYNC_SYN
struct MB_SYN_CH_SYNC : MSGBUF {};

// SERVER_PROTOCOL::MB_CH_LIST_SYN
struct MB_SYN_CH_LIST : MSGBUF
{
	long rowCount;
	struct
	{
		long cid;							// Connection Index (Server & Channel Number)
		BYTE status;						// SERVER_STATUS 
	} channels[1];
	long Length ( ) { return (sizeof(MB_SYN_CH_LIST)-sizeof(channels)) + (sizeof(channels)*rowCount); }
};

// SERVER_PROTOCOL::MB_CH_STATUS_SYN
struct MB_SYN_CH_STATUS : MSGBUF
{
	long cid;								// Connection Index (Server & Channel Number)
	BYTE status;							// SERVER_STATUS 
};

// SERVER_PROTOCOL::MB_SERVER_NOTICE_SYN
// defined commondefines.h file
#define MAX_SERVER_NOTICE_LEN	127
#define MAX_SERVER_NOTICE_BUF	MAX_SERVER_NOTICE_LEN+1

struct MB_SYN_SERVER_NOTICE : MSGBUF
{
	long    cid;							// Connection Index (Server & Channel Number)
	wchar_t message[MAX_SERVER_NOTICE_BUF];	// ޼
};

// SERVER_PROTOCOL::MB_CHAT_SHOUT_SYN
// defined commondefines.h file
#define MAX_NAME_LEN	16
#define MAX_NAME_BUF	MAX_NAME_LEN+1
#define MAX_CHAT_LEN	127
#define MAX_CHAT_BUF	MAX_CHAT_LEN+1

struct MB_SYN_CHAT_SHOUT : MSGBUF
{
	long		   cid;						// Connection Index (Server & Channel Number)
	unsigned short numOfMap;				//  ĳ ġ
	long           characterIdx;            //  ĳ ȣ
	wchar_t        name[MAX_NAME_BUF];		//  ĳ ̸
	wchar_t        message[MAX_CHAT_BUF];	// ޼
};

// SERVER_PROTOCOL::MB_PVP_STATUS_SYN
struct MB_SYN_PVP_STATUS : MSGBUF
{
	long cid;								// Connection Index (Server & Channel Number)
	BYTE status;							// PVP_STATUS 
};

// SERVER_PROTOCOL::MB_PVP_NOTICE_SYN
struct MB_SYN_PVP_NOTICE : MSGBUF
{
	long cid;								// Connection Index (Server & Channel Number)
	unsigned char leftMinute;				// ð()
};

// SERVER_PROTOCOL::MB_GUILD_SYNC_SYN
struct MB_SYN_GUILD_SYNC : MSGBUF
{
	long cid;								// Connection Index (Server & Channel Number)
	char msg[1];							// ޽
};

// SERVER_PROTOCOL::MB_GUILD_CONNECTSYNC_SYN
struct MB_SYN_GUILD_CONNECTSYNC : MSGBUF
{
	long cid;								// Connection Index (Server & Channel Number)
};

// SERVER_PROTOCOL::MB_MONSTER_SYNC_SYN
struct MB_SYN_MONSTER_SYNC : MSGBUF
{
	long cid;								// Connection Index (Server & Channel Number)
	char msg[1];							// ޽
};

// SERVER_PROTOCOL::MB_CHAT_SYN
struct MB_SYN_CHAT_SYNC : MSGBUF
{
	long cid;								// Connection Index (Server & Channel Number)
	char msg[1];							// ޽
};


// 1Byte  
#pragma pack( )

#endif // __SERVERL_PROTOCOL_H__
