#include "StdAfx.h"
#include "GameSrvNetwork.h"
#include "../common/CommonNetworkMsgStruct.h"
#include "../Common/Protocol.h"
#include "ServerToolDlg.h"


cGameSrvNetwork::cGameSrvNetwork(void)
{
}


cGameSrvNetwork::~cGameSrvNetwork(void)
{
}


bool cGameSrvNetwork::SuccessConnect()	
{ 
	mIsConnect = true; 

	CListCtrl* pChannelListC = (CListCtrl*)mpDlg->GetDlgItem( IDC_CHANNEL_LC );

	pChannelListC->SetItemText( mNumber, CHANNEL_STATE, _T("ON") );

	SendServerInfo();

	return true;
}


bool cGameSrvNetwork::DisConnect( WPARAM wParam )
{
	if( cNetwork::DisConnect( wParam ) == false )
		return false;

	CListCtrl* pChannelListC = (CListCtrl*)mpDlg->GetDlgItem( IDC_CHANNEL_LC );

	pChannelListC->SetItemText( mNumber, CHANNEL_STATE, _T("OFF") );

	return true;
}


bool cGameSrvNetwork::NetworkMsgParser( WPARAM wParam, char* chatmsg )
{

	if( cNetwork::NetworkMsgParser( wParam, chatmsg ) == false )
		return false;

	eRECV_RETURN recvReturn = eCONTINUE;

	int size = 0;
	while( eCONTINUE == recvReturn )
	{
		memset( chatmsg, 0, sizeof(chatmsg) );
		recvReturn = Recv( chatmsg, &size );

		if( size == 0 && recvReturn == eCONTINUE )
			continue;			

		if( recvReturn == eERROR ) 
		{
			assert(NULL);
			break;
		}

		if( recvReturn == eINCOMPLETION )
			break;

		MSGROOT* pRecvRoot = (MSGROOT*)chatmsg;

		switch( pRecvRoot->Category )
		{
		case NM_SERVERTOOL:
			{
				switch( pRecvRoot->Protocol )
				{
				case NM_SERVERTOOL_PING_RES:
					{
						CListCtrl* pChannelListC = (CListCtrl*)mpDlg->GetDlgItem( IDC_CHANNEL_LC );

						CString string;
						string.Format( _T("%d"), mPingDelayTime );
						pChannelListC->SetItemText( mNumber, CHANNEL_PING, string );

						string.Format( _T("%d"), mUserCnt );
						pChannelListC->SetItemText( mNumber, CHANNEL_USERCNT, string );
					}
					break;
				case NM_SERVERTOOL_SERVER_INFO_RES:
					{
						MSG_RES_SERVTOOL_CHANNEL_INFO* pRecvMsg = (MSG_RES_SERVTOOL_CHANNEL_INFO*)pRecvRoot;

						CListCtrl* pChannelListC = (CListCtrl*)mpDlg->GetDlgItem( IDC_CHANNEL_LC );

						CString string;
						string.Format( _T("%d"), pRecvMsg->mServerNum );
						pChannelListC->SetItemText( mNumber, CHANNEL_SERVERNUM, string );
						string.Format( _T("%s"), pRecvMsg->mServerName );
						pChannelListC->SetItemText( mNumber, CHANNEL_SERVERNAME, string );
						string.Format( _T("%d"), pRecvMsg->mChannelNum );
						pChannelListC->SetItemText( mNumber, CHANNEL_CHANNELNUM, string );

						mIsSubInfo = true;
					}
					break;
				default:
					assert(NULL);
				}
			}
			break;
		default:
			assert(NULL);
		}
	}

	return true;
}


void cGameSrvNetwork::Process()
{
	if( mIsConnect == true )
	{
		if( mPingCheckTime < GetTickCount() )
		{
			mPingCheckTime = GetTickCount() + 1000;

			PingSend();
		}

		if( mIsSubInfo == false && mSubInfoTime < GetTickCount() )
		{
			mSubInfoTime = GetTickCount() + 1000;
			SendServerInfo();
		}
	}
	else
	{
		if( mConnectCheckTime > GetTickCount() )
			return;

		mConnectCheckTime = GetTickCount() + 1000;

		Connect();
	}
}


void cGameSrvNetwork::SendServerInfo()
{
	MSGROOT sendMsg;
	sendMsg.Category = NM_SERVERTOOL;
	sendMsg.Protocol = NM_SERVERTOOL_SERVER_INFO_REQ;

	Send( (char*)&sendMsg, sizeof(sendMsg) );
}