#include "StdAfx.h"
#include "LogInSrvNetwork.h"
#include "../common/CommonNetworkMsgStruct.h"
#include "../Common/Protocol.h"
#include "ServerToolDlg.h"


cLogInSrvNetwork::cLogInSrvNetwork(void)
{
}


cLogInSrvNetwork::~cLogInSrvNetwork(void)
{
}


bool cLogInSrvNetwork::SuccessConnect()	
{ 
	mIsConnect = true; 

	SendServerList();

	CListCtrl* pLogInListC = (CListCtrl*)mpDlg->GetDlgItem( IDC_LOGIN_LC );

	pLogInListC->SetItemText( mNumber, LOGCOL_STATE, _T("ON") );

	return true;
}


bool cLogInSrvNetwork::DisConnect( WPARAM wParam )
{
	if( cNetwork::DisConnect( wParam ) == false )
		return false;

	CListCtrl* pLogInListC = (CListCtrl*)mpDlg->GetDlgItem( IDC_LOGIN_LC );

	pLogInListC->SetItemText( mNumber, LOGCOL_STATE, _T("OFF") );

	return true;
}

bool cLogInSrvNetwork::NetworkMsgParser( WPARAM wParam, char* chatmsg )
{

	if( cNetwork::NetworkMsgParser( wParam, chatmsg ) == false )
		return false;

	eRECV_RETURN recvReturn = eCONTINUE;

	int size = 0;
	while( eCONTINUE == recvReturn )
	{

		memset( chatmsg, 0, sizeof(chatmsg) );
		recvReturn = Recv( chatmsg, &size );

		if( size == 0 && recvReturn == eCONTINUE )
			continue;	

		if( recvReturn == eERROR ) 
		{
			assert(NULL);
			break;
		}

		if( recvReturn == eINCOMPLETION )
			break;

		MSGROOT* pRecvRoot = (MSGROOT*)chatmsg;

		switch( pRecvRoot->Category )
		{
		case NM_SERVERTOOL:
			{
				switch( pRecvRoot->Protocol )
				{
				case NM_SERVERTOOL_PING_RES:
					{
						CListCtrl* pLogInListC = (CListCtrl*)mpDlg->GetDlgItem( IDC_LOGIN_LC );

						CString string;
						string.Format( _T("%d"), mPingDelayTime );
						pLogInListC->SetItemText( mNumber, LOGCOL_PING, string );

						MSG_RES_SRVTOOL_PING* pRec = (MSG_RES_SRVTOOL_PING*)pRecvRoot;
						if( pRec->mUserIn == true )
							pLogInListC->SetItemText( mNumber, LOGCOL_USERIN, _T("ON") );
						else
							pLogInListC->SetItemText( mNumber, LOGCOL_USERIN, _T("OFF") );
					}
					break;
				case NM_SERVERTOOL_SERVER_LIST_RES:
					{
						MSG_RES_SERVERLIST* pRecvMsg = (MSG_RES_SERVERLIST*)pRecvRoot;

						CListCtrl* pSrvListC = (CListCtrl*)mpDlg->GetDlgItem( IDC_SERVER_LC );
						CString string;

						pSrvListC->DeleteAllItems();
						mIsSubInfo = true;

						for( unsigned long i = 0 ; i < pRecvMsg->RowCount ; ++ i )
						{
							pSrvListC->InsertItem( i, _T(""), SRVCOL_CHECK );
							string.Format( _T("%d"), pRecvMsg->Servers[i].NumOfServer );
							pSrvListC->SetItemText( i, SRVCOL_NUM, string );
							string.Format( _T("%s"), pRecvMsg->Servers[i].Name );
							pSrvListC->SetItemText( i, SRVCOL_NAME, string );
						}
					}
					break;
				case NM_SERVERTOOL_CHANNEL_LIST_RES:
					{
						//MSG_RES_SERVTOOL_CHLIST* pRecvMsg = (MSG_RES_SERVTOOL_CHLIST*)pRecvRoot;
						//
						//SP_ResList* pList = &pRecvMsg->mChList;
						//for( long i = 0 ; i < pList->rowCount ; ++i )
						//      mpDlg->ChannelSrvAdd( pList->channels[i].inetnum, 14600 );
					}
					break;
				default:
					assert(NULL);
				}
			}
			break;
		default:
			assert(NULL);
		}

	}

	return true;
}


void cLogInSrvNetwork::Process()
{
	if( mIsConnect == true )
	{
		if( mPingCheckTime < GetTickCount() )
		{
			mPingCheckTime = GetTickCount() + 1000;

			PingSend();
		}

		if( mIsSubInfo == false && mSubInfoTime < GetTickCount() )
		{
			mSubInfoTime = GetTickCount() + 1000;
			SendServerList();
		}
	}
	else
	{
		if( mConnectCheckTime > GetTickCount() )
			return;

		mConnectCheckTime = GetTickCount() + 1000;

		Connect();
	}
}


void cLogInSrvNetwork::SendServerList()
{
	MSGROOT sendMsg;
	sendMsg.Category = NM_SERVERTOOL;
	sendMsg.Protocol = NM_SERVERTOOL_SERVER_LIST_REQ;

	Send( (char*)&sendMsg, sizeof(sendMsg) );
}


void cLogInSrvNetwork::SendUserIn()
{
	MSGROOT sendMsg;
	sendMsg.Category = NM_SERVERTOOL;
	sendMsg.Protocol = NM_SERVERTOOL_USERIN_REQ;

	Send( (char*)&sendMsg, sizeof(sendMsg) );
}