#include "StdAfx.h"
#include "Network.h"
#include "../common/CommonNetworkMsgStruct.h"
#include "../Common/Protocol.h"
#include "../Common/Cheat_Common.h"


cNetwork::cNetwork(void) : 	mSendQueue(50)
{
	mSendMsg = new char[QUEUE_BUFFER_SIZE];
	memset( mSendMsg, 0, sizeof(mSendMsg) );
	mSendMsgTemp = new char[QUEUE_BUFFER_SIZE];
	memset( mSendMsgTemp, 0, sizeof(mSendMsgTemp) );

	mRecvMsg = new char[QUEUE_BUFFER_SIZE];
	memset( mRecvMsg, 0, sizeof(mRecvMsg) );
	mRecvMsgTemp = new char[QUEUE_BUFFER_SIZE];
	memset( mRecvMsgTemp, 0, sizeof(mRecvMsgTemp) );
	mRecvMsgPos = 0;

	mIsConnect = false;

	mPingDelayTime = 0;
	mUserCnt = 0;

	mPingCheckTime = GetTickCount() + 3000;
	mConnectCheckTime = GetTickCount() + 1000;

	mNumber = 0;
}



cNetwork::~cNetwork(void)
{
	delete []mRecvMsg;
	delete []mRecvMsgTemp;
	delete []mSendMsg;
	mRecvMsg = NULL;
	mRecvMsgTemp = NULL;
	mSendMsg = NULL;

	/// queue Ÿ   
	while( mSendQueue.IsEmpty() == false )
	{
		/// queue ù° Ÿ 
		char* sendmsg = mSendQueue.Front();
		delete []sendmsg;
		sendmsg = NULL;
	}
	mSendQueue.Clear();

	closesocket(mSocket);
	mSocket = INVALID_SOCKET;
}


bool cNetwork::NetworkMsgParser( WPARAM wParam, char* pMsg )
{
	if( mSocket != (SOCKET)wParam )
		return false;

	return true;
}


bool cNetwork::Init( HWND hwnd, unsigned long number, char* ip, int port, CServerToolDlg* pDlg )
{
	mpDlg = pDlg;

	mHwnd = hwnd;
	memcpy( mIp, ip, sizeof(mIp) );
	mPort = port;

	mNumber = number;

	///  ӵִ  
	mIsConnect = false;

	mIsSubInfo = false;
	mSubInfoTime = 0;	

	mSocket = socket( AF_INET, SOCK_STREAM, 0 );
	if( mSocket == INVALID_SOCKET ) 
	{ 
		assert(NULL);
		MessageBox( NULL, _T("New Socket ERROR"), _T("ERROR"), NULL );
		return false; 
	}

	mSockaddr.sin_family = AF_INET;
	mSockaddr.sin_addr.s_addr = inet_addr(mIp);
	mSockaddr.sin_port = htons(mPort);
	
	Connect();

	return true;
}


bool cNetwork::Connect()
{
	if( mIsConnect == true )
		return false;

	int errorcode;

	if( WSAAsyncSelect( mSocket, mHwnd, WM_ASYNC_WRC, FD_CONNECT ) == SOCKET_ERROR ) 
	{
		assert(NULL);
		MessageBox( NULL, _T("Async Select ERROR"), _T("ERROR"), NULL );
		return false;
	}

	errorcode = connect( mSocket, (LPSOCKADDR)&mSockaddr, sizeof(mSockaddr));
	if( errorcode == SOCKET_ERROR ) 
	{
		if( WSAGetLastError() != WSAEWOULDBLOCK ) 
			return false; 
	}

	return true;
}

bool cNetwork::FDConnect( WPARAM wParam )
 {
	 if( mSocket != (SOCKET)wParam )
		 return false;

	if( WSAAsyncSelect( mSocket, mHwnd, WM_ASYNC_WRC, FD_READ|FD_WRITE|FD_CLOSE ) == SOCKET_ERROR ) 
	{
		assert(NULL);
		MessageBox( NULL, _T("Async Select ERROR"), _T("ERROR"), NULL );
		return false;
	}

	return true;
 }

bool cNetwork::DisConnect( WPARAM wParam )
{
	if( mSocket != (SOCKET)wParam )
		return false;

	mIsConnect = false;

	closesocket(mSocket);
	mSocket = INVALID_SOCKET;

	Init( mHwnd, mNumber, mIp, mPort, mpDlg );

	return true;
}


bool cNetwork::Send( char* msg, unsigned long length )
{

	/// queue ִ Ÿ  
	QSend();

	/// 2send ʱȭ ȯ
	memset( mSendMsg, 0, sizeof(mSendMsg) );
	Packet* pMsg = (Packet*)mSendMsg;

	static int i = 0;

	///  ޼ 
	pMsg->ver  = 1;
	pMsg->hlen = sizeof(Packet);
	pMsg->tos = TOS_SERVERTOOL;
	pMsg->tlen = static_cast<u_short>( sizeof(Packet) + length );

	memcpy( mSendMsg + sizeof( Packet ) , msg, length );

	///  ޼ queue 
	char* sendmsg;
	sendmsg = new char[QUEUE_BUFFER_SIZE];
	memcpy( sendmsg, mSendMsg, pMsg->tlen );
	if( mSendQueue.IsFull() == true )
	{
		assert(NULL);
		MessageBox( NULL, _T("Queue is full"), _T("ERROR"), NULL );
		return false;
	}
	mSendQueue.PushBack( sendmsg );

	/// queue    
	return QSend();
}


void cNetwork::RetrySend( WPARAM wParam )
{
	if( mSocket != (SOCKET)wParam )
		return;

	QSend();
}


bool cNetwork::QSend()
{
	/// queue Ÿ   
	while( mSendQueue.IsEmpty() == false )
	{

		/// queue ù° Ÿ 
		char* sendmsg = mSendQueue.Front();
		Packet* pMsg = (Packet*)sendmsg;

		/// Ÿ 
		int errorcode;
		errorcode = send( mSocket, sendmsg, pMsg->tlen, 0 );
		if( errorcode == SOCKET_ERROR )
		{
			if( WSAGetLastError() != WSAEWOULDBLOCK ) 
			{ 
				return false; 
			}
			else
			{
				/// WSAEWOULDBLOCK ΰ ޼ 
				continue;
			}
		}

		/// queue Ÿ 
		mSendQueue.PopFront();
		pMsg = NULL;
		delete []sendmsg;
		sendmsg = NULL;
	}

	return true;
}


void cNetwork::PingSend()
{
	if( mIsConnect == false )
		return;

	///  ʱȭ
	memset( mSendMsgTemp, 0, sizeof(mSendMsgTemp) );
	Packet* pMsg = (Packet*)mSendMsgTemp;

	///  ޼
	MSG_REQ_SRVTOOL_PING sendMsg;

	///  ޼  
	pMsg->ver  = 1;
	pMsg->hlen = sizeof(Packet);
	pMsg->tos = TOS_SERVERTOOL;
	pMsg->tlen = static_cast<u_short>( sizeof(Packet) + sizeof(sendMsg) );

	///  
	memcpy( mSendMsgTemp, pMsg, pMsg->hlen );

	sendMsg.Category = NM_SERVERTOOL;
	sendMsg.Protocol = NM_SERVERTOOL_PING_REQ;
	sendMsg.mToolSendTime = GetTickCount();

	/// ڿ  ޼ 
	memcpy( mSendMsgTemp + sizeof( Packet ), &sendMsg, pMsg->tlen );

	/// Ÿ 
	int errorcode;
	errorcode = send( mSocket, mSendMsgTemp, pMsg->tlen, 0 );

	return;
}


eRECV_RETURN cNetwork::Recv( char* msg, int* size )
{
	int recvsize;

	do
	{
		if( QUEUE_BUFFER_SIZE - mRecvMsgPos < BUFFER_SIZE )
		{
			assert(NULL);
			return eERROR; 
		}

		/// Ÿ Ƶδ ۿ κп Ÿ ߰
		recvsize = recv( mSocket, &mRecvMsg[mRecvMsgPos], QUEUE_BUFFER_SIZE - mRecvMsgPos, 0 );
		/// Ÿ ó
		if( recvsize == SOCKET_ERROR ) 
		{ 
			/// recv WOULDBLOCK ó
			if( WSAGetLastError() != WSAEWOULDBLOCK ) 
			{
				assert(NULL);
				MessageBox( NULL, _T("Recv SOCKET ERROR"), _T("ERROR"), NULL );
				return eERROR; 
			}
		}

		///  ŸԷ  Ÿ Ƶδ ۳ġ 
		if( recvsize > 0 )
			mRecvMsgPos += recvsize;

	}while( recvsize > 0 ); ///   Ÿ  

	/// ۿ  Ÿ  1 Ǵ° 
	if( mRecvMsgPos < sizeof(Packet) ) 
		return eINCOMPLETION;

	/// ޼  ǵ
	Packet* pPhv1 = (Packet*)mRecvMsg;
	/// Ÿ ü ˾ƿ
	int msgSize = pPhv1->tlen;

	if( !( pPhv1->tos == TOS_LOGIN || pPhv1->tos == TOS_GAME || 
		pPhv1->tos == TOS_LOGIN_ACCEPT || pPhv1->tos == TOS_GAME_ACCEPT) )
	{
		assert(NULL);
		memset( mRecvMsg, 0, sizeof(char) * QUEUE_BUFFER_SIZE );
		mRecvMsgPos = 0;
	}

	///  ޼ ṵ̈  üũ
	if( mRecvMsgPos < pPhv1->tlen )
		return eINCOMPLETION;
	else if( sizeof(Packet) == pPhv1->tlen )
	{
		///  ޼  &  
		memset( mRecvMsgTemp, 0, sizeof(mRecvMsgTemp) );					/// ӽð clear
		memcpy( mRecvMsgTemp, &mRecvMsg[msgSize], mRecvMsgPos - msgSize);	/// ޼ ӽð 
		memset( mRecvMsg, 0, sizeof(mRecvMsg) );							/// ָ޸𸮰 clear
		memcpy( mRecvMsg, mRecvMsgTemp, mRecvMsgPos - msgSize );			/// ӽðִ ܿ޼ ָ޸𸮰 

		mRecvMsgPos = mRecvMsgPos - msgSize;
		*size = 0;
		if( mRecvMsgPos <= 0 )
            return eINCOMPLETION;
		else
			return eCONTINUE;
	}

    ///      ޼ 
	memcpy( msg, &mRecvMsg[sizeof(Packet)], msgSize - sizeof(Packet) );
	/// ó Ŷ 
	*size = msgSize;

	/// ping ޼ ó
	CalcPing( (MSGROOT*)msg );

	///  ޼  &  
	memset( mRecvMsgTemp, 0, sizeof(mRecvMsgTemp) );					/// ӽð clear
	memcpy( mRecvMsgTemp, &mRecvMsg[msgSize], mRecvMsgPos - msgSize);	/// ޼ ӽð 
	memset( mRecvMsg, 0, sizeof(mRecvMsg) );							/// ָ޸𸮰 clear
	memcpy( mRecvMsg, mRecvMsgTemp, mRecvMsgPos - msgSize );			/// ӽðִ ܿ޼ ָ޸𸮰 

	mRecvMsgPos = mRecvMsgPos - msgSize;

	/// ܿ Ÿ  1 Ǵ° 
	if( mRecvMsgPos < sizeof(Packet) ) 
		return eCOMPLETION;

	/// ܿ ޼  ǵ
	pPhv1 = (Packet*)mRecvMsg;
	/// ܿ Ÿ ü ˾ƿ
	msgSize = pPhv1->tlen;

	/// ܿ ޼ ṵ̈  üũ
	if( mRecvMsgPos < pPhv1->tlen )
		return eCOMPLETION;
	else
		return eCONTINUE; 
}


void cNetwork::NoticeSend( LPCTSTR chatmsg )
{
	MSG_REQ_CHEAT_NOTICE_CHANNEL sendMsgCh;
	::memset( &sendMsgCh, 0, sizeof( sendMsgCh ) );

	sendMsgCh.Category = NM_SERVERTOOL;
	sendMsgCh.Protocol = NM_SERVERTOOL_CHAT_NOTICE_REQ;

	Sstrncpy( sendMsgCh.mMessage, MAX_CHAT_BUFFER_SIZE, chatmsg, MAX_CHAT_SIZE );

	Send( (char*)&sendMsgCh, sendMsgCh.GetMsgLength() );
}


void cNetwork::CalcPing( MSGROOT* pMsg )
{
	/// ping ޼  Ȯ
	MSGROOT* pRootMsg = (MSGROOT*)pMsg;
	if( pRootMsg->Category != NM_SERVERTOOL && pRootMsg->Protocol != NM_SERVERTOOL_PING_RES )
		return;

	///  ð  ð 
	MSG_RES_SRVTOOL_PING* pPingMsg = (MSG_RES_SRVTOOL_PING*)pRootMsg;

	unsigned long time = GetTickCount();
	mPingDelayTime = time - pPingMsg->mToolSendTime;

	mUserCnt = pPingMsg->mUserCnt;
}