/* ==========================================================================
*      : Network.h
*      : 
*    : ڰ
*    : 2007-03-30
* ǻ :
*===========================================================================*/
#pragma once
#include "../GameSrv/MapServer/IndexGenerator.h"
#include "../Common/Packet.h"

#define WM_ASYNC (WM_APP +1)
#define WM_ASYNC_WRC WM_APP+2

#pragma pack(1) // 1Byte  

class CServerToolDlg;

const int BUFFER_SIZE = 65535;
const int QUEUE_BUFFER_SIZE = BUFFER_SIZE * 10;

const int PING_CHECK_TIME = 3000;
const int RECONN_CHECK_TIME = 1000;

/// recv ȯ
enum eRECV_RETURN
{
	eERROR, 			/// 
	eINCOMPLETION,		/// Ÿ ü ̸ŭ   
	eCOMPLETION,		/// ޼ ũ⸸ŭ  ٹް   
	eCONTINUE,			/// 1 ̻ ޼ ũ
};

/// on/off
enum eAGENT_ONOFF
{
	eAGENT_NONE,
	eAGENT_ON,
	eAGENT_OFF,
};

struct MSGROOT;

class cNetwork
{
public:
	cNetwork(void);
	virtual ~cNetwork(void);

public:

	/// Ʈũ  ó 
	virtual bool			Init( HWND hwnd, unsigned long number, char* ip, int port, CServerToolDlg* pDlg );	/// ʱȭ
	virtual bool			Connect();									/// Ʈ  õ
	virtual bool			FDConnect( WPARAM wParam );								///   Ȯ
	virtual bool			SuccessConnect() = 0;
	virtual bool			DisConnect( WPARAM wParam );				/// Ʈ  ó

	/// ޼ ó
	virtual bool			Send( char* msg, unsigned long length );	///  ͸ send queue 
	virtual void			RetrySend( WPARAM wParam );					/// fd_write   ޼ 
	virtual eRECV_RETURN	Recv( char* msg, int* size );				/// Ʈ ۹ Ÿ ˷

	///  ޼ ó
	virtual void			NoticeSend( LPCTSTR chatmsg );

	virtual void			Process() = 0;

	///	network msg parser
	virtual bool			NetworkMsgParser( WPARAM wParam, char* pMsg );


	///  ޼ ߼
	virtual void			PingSend();

private:

	virtual bool			QSend();									/// queue ִ sendŸ 

	/// ping ð 
	virtual void			CalcPing( MSGROOT* pMsg );

protected:

	/// ޼ 
	char			*mSendMsg;			/// send
	char			*mSendMsgTemp;		/// sendӽù
	char			*mRecvMsg;			/// recv
	char			*mRecvMsgTemp;		/// recvӽù
	int				mRecvMsgPos;		/// recv  ġ

	typedef tQueue<char*> cSendQueue;	/// send۸ ϰ ִ queue
	cSendQueue		mSendQueue;

protected:

	///  
	HWND			mHwnd;
	char			mIp[16];
	int				mPort;


	///  
	bool			mIsConnect;			

    ///  üũ
	cIndexGenerator	mIGen;

	///  ð
	unsigned long	mPingDelayTime;

	/// Ӽ
	unsigned long	mUserCnt;

	/// μ üũð
	unsigned long	mPingCheckTime;
	unsigned long	mConnectCheckTime;

	///  ȣ
	unsigned long	mNumber;

	CServerToolDlg* mpDlg;	

	bool			mIsSubInfo;
	unsigned long	mSubInfoTime;

public:

	SOCKET			mSocket;
	SOCKADDR_IN		mSockaddr;

};

#pragma pack( ) // 1Byte  