// ServerToolDlg.cpp :  
//

#include "stdafx.h"
#include "ServerTool.h"
#include "ServerToolDlg.h"
#include ".\servertooldlg.h"
#include "../common/Protocol.h"
#include "../common/CommonNetworkMsgStruct.h"
#include "../Util/FileSystem.h"
#include "Network.h"
#include "LogInSrvNetwork.h"
#include "LogInAgentNetwork.h"
#include "GameSrvNetwork.h"
#include "GameAgentNetwork.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

// CServerToolDlg ȭ 

CServerToolDlg::CServerToolDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CServerToolDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CServerToolDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CServerToolDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_TIMER()
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CServerToolDlg ޽ ó

BOOL CServerToolDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ý ޴ "..." ޴ ׸ ߰մϴ.

	mpFileSystem = new cFileSystem;

	if( WSAStartup( MAKEWORD(1,1), &mWsaData ) != 0 ) 
	{ 
		assert(NULL);
		MessageBox( _T("New WSAStartUP ERROR"), _T("ERROR") );
		return FALSE; 
	}

	mLogCnt = 0;
	mGameCnt = 0;

	/// α  Ʈ
	CListCtrl* pLogInListC = (CListCtrl*)GetDlgItem( IDC_LOGIN_LC );
	pLogInListC->InsertColumn( LOGCOL_STATE, _T("State") );
	pLogInListC->SetColumnWidth( LOGCOL_STATE, 45 );
	pLogInListC->InsertColumn( LOGCOL_AGENT, _T("Agent") );
	pLogInListC->SetColumnWidth( LOGCOL_AGENT, 50 );
	pLogInListC->InsertColumn( LOGCOL_USERIN, _T("UserIn") );
	pLogInListC->SetColumnWidth( LOGCOL_USERIN, 50 );
	pLogInListC->InsertColumn( LOGCOL_IP, _T("IP") );
	pLogInListC->SetColumnWidth( LOGCOL_IP, 120 );
	pLogInListC->InsertColumn( LOGCOL_PORT, _T("Port") );
	pLogInListC->SetColumnWidth( LOGCOL_PORT, 50 );
	pLogInListC->InsertColumn( LOGCOL_PING, _T("Ping") );
	pLogInListC->SetColumnWidth( LOGCOL_PING, 50 );
	pLogInListC->SetExtendedStyle( LVS_EX_FULLROWSELECT ); 

	/// Ӽ Ʈ
	CListCtrl* pServerListC = (CListCtrl*)GetDlgItem( IDC_SERVER_LC );
	pServerListC->InsertColumn( SRVCOL_CHECK, _T(" ") );
	pServerListC->SetColumnWidth( SRVCOL_CHECK, 20 );
	pServerListC->InsertColumn( SRVCOL_NUM, _T("ServerNo") );
	pServerListC->SetColumnWidth( SRVCOL_NUM, 70 );
	pServerListC->InsertColumn( SRVCOL_NAME, _T("ServerName") );
	pServerListC->SetColumnWidth( SRVCOL_NAME, 250 );
	pServerListC->SetExtendedStyle( LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES ); 

	/// ä  Ʈ
	CListCtrl* pChannelListC = (CListCtrl*)GetDlgItem( IDC_CHANNEL_LC );
	pChannelListC->InsertColumn( CHANNEL_CHECK, _T(" ") );
	pChannelListC->SetColumnWidth( CHANNEL_CHECK, 20 );
	pChannelListC->InsertColumn( CHANNEL_STATE, _T("State") );
	pChannelListC->SetColumnWidth( CHANNEL_STATE, 45 );
	pChannelListC->InsertColumn( CHANNEL_AGENT, _T("Agent") );
	pChannelListC->SetColumnWidth( CHANNEL_AGENT, 50 );
	pChannelListC->InsertColumn( CHANNEL_SERVERNUM, _T("SrvNo") );
	pChannelListC->SetColumnWidth( CHANNEL_SERVERNUM, 45 );
	pChannelListC->InsertColumn( CHANNEL_SERVERNAME, _T("SrvName") );
	pChannelListC->SetColumnWidth( CHANNEL_SERVERNAME, 110 );
	pChannelListC->InsertColumn( CHANNEL_CHANNELNUM, _T("ChanNo") );
	pChannelListC->SetColumnWidth( CHANNEL_CHANNELNUM, 55 );
	pChannelListC->InsertColumn( CHANNEL_IP, _T("IP") );
	pChannelListC->SetColumnWidth( CHANNEL_IP, 105 );
	pChannelListC->InsertColumn( CHANNEL_PORT, _T("Port") );
	pChannelListC->SetColumnWidth( CHANNEL_PORT, 50 );
	pChannelListC->InsertColumn( CHANNEL_PING, _T("Ping") );
	pChannelListC->SetColumnWidth( CHANNEL_PING, 50 );
	pChannelListC->InsertColumn( CHANNEL_USERCNT, _T("UserCnt") );
	pChannelListC->SetColumnWidth( CHANNEL_USERCNT, 55 );
	pChannelListC->SetExtendedStyle( LVS_EX_FULLROWSELECT | LVS_EX_CHECKBOXES ); 

	ScriptLoad();

	SetTimer( 1, 1000, NULL );

	// IDM_ABOUTBOX ý   ־ մϴ.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	//  ȭ   մϴ.  α׷  â ȭ ڰ ƴ 쿡
	// ӿũ  ۾ ڵ մϴ.
	SetIcon(m_hIcon, TRUE);			// ū  մϴ.
	SetIcon(m_hIcon, FALSE);		//   մϴ.

	// TODO: ⿡ ߰ ʱȭ ۾ ߰մϴ.
	
	return TRUE;  // Ʈѿ  Ŀ    TRUE ȯմϴ.
}

void CServerToolDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	CDialog::OnSysCommand(nID, lParam);
}

// ȭ ڿ ּȭ ߸ ߰   ׸ 
// Ʒ ڵ尡 ʿմϴ. /  ϴ MFC  α׷ 쿡
// ӿũ  ۾ ڵ մϴ.

void CServerToolDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // ׸⸦  ̽ ؽƮ

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Ŭ̾Ʈ 簢   ϴ.
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		//  ׸ϴ.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// ڰ ּȭ â  ȿ Ŀ ǥõǵ ýۿ
//   Լ ȣմϴ. 
HCURSOR CServerToolDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

LRESULT CServerToolDlg::DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{

	// TODO: ⿡ Ưȭ ڵ带 ߰ /Ǵ ⺻ Ŭ ȣմϴ.

	switch(message)
	{
	case WM_COMMAND:
		{
			switch(wParam) 
			{
			case IDC_EXIT: DestroyWindow(); break;
			case IDC_SENDALL_CHECK:
				{
					CListCtrl* pChannelList = (CListCtrl*)GetDlgItem( IDC_CHANNEL_LC );

					CButton* pCheck = (CButton*)GetDlgItem( IDC_SENDALL_CHECK );

					for( int j = 0 ; j < pChannelList->GetItemCount() ; ++j )
					{
						if( pCheck->GetCheck() == 1 ) //&& pChannelList->GetItemText( j, CHANNEL_STATE ) == "ON" )
						{
							ListView_SetItemState( pChannelList->m_hWnd, j, ON_LIST_CHECK, LVIS_STATEIMAGEMASK );
						}
						else
						{
							ListView_SetItemState( pChannelList->m_hWnd, j, OFF_LIST_CHECK, LVIS_STATEIMAGEMASK );
						}
					}
				}
				break;
			case IDC_SEND_BUTTON:
				{
					CListCtrl* pChannelList = (CListCtrl*)GetDlgItem( IDC_CHANNEL_LC );

					CEdit* pEdit = (CEdit*)GetDlgItem( IDC_SEND_EDIT );
					CString string;
					pEdit->GetWindowText( string );
                    
					if( MessageBox( string, _T("Warning"), MB_OKCANCEL ) == IDOK )
					{
						cNetwork* pNetwork;

						for( int i = 0 ; i < pChannelList->GetItemCount() ; ++i )
						{
							if( ListView_GetItemState( pChannelList->m_hWnd, i, LVIS_STATEIMAGEMASK ) == ON_LIST_CHECK )
							{
								if( pChannelList->GetItemText( i, CHANNEL_STATE ) == "ON" )
								{
									pNetwork = mpGameNet[i];

									pNetwork->NoticeSend( string );
								}
							}
						}
					}

					pEdit->SetWindowText( _T("") );
				}
				break;
			case IDC_APPLY_BUTTON:
				{
					CListCtrl* pServerListC = (CListCtrl*)GetDlgItem( IDC_SERVER_LC );
					CListCtrl* pChannelList = (CListCtrl*)GetDlgItem( IDC_CHANNEL_LC );

					CString srvNum, chSrvNum;

					for( int i = 0 ; i < pServerListC->GetItemCount() ; ++i )
					{			
						srvNum = pServerListC->GetItemText( i, SRVCOL_NUM );

						for( int j = 0 ; j < pChannelList->GetItemCount() ; ++j )
						{
							chSrvNum = pChannelList->GetItemText( j, CHANNEL_SERVERNUM );

							if( srvNum != chSrvNum )
								continue;

							if( ListView_GetItemState( pServerListC->m_hWnd, i, LVIS_STATEIMAGEMASK ) == ON_LIST_CHECK )
							{
								ListView_SetItemState( pChannelList->m_hWnd, j, ON_LIST_CHECK, LVIS_STATEIMAGEMASK );
							}
							else
							{
								ListView_SetItemState( pChannelList->m_hWnd, j, OFF_LIST_CHECK, LVIS_STATEIMAGEMASK );
							}
						}
					}
				}
				break;
			case IDC_SERVERLIST_BUTTON:
				{
					cLogInSrvNetwork* pNetwork = mpLogNet[0];
					if( pNetwork != NULL )
					{
                        pNetwork->SendServerList();
					}                    
				}
				break;
			case IDC_USERIN_BUTTON:
				{
					cLogInSrvNetwork* pNetwork = mpLogNet[0];
					if( pNetwork != NULL )
					{
						pNetwork->SendUserIn();
					}     
				}
				break;
			case IDC_CHNON_BUTTON:
				{
					ChannelSrvOn();
				}
				break;
			case IDC_CHNOFF_BUTTON:
				{
					ChannelSrvOff();
				}
				break;
			case IDC_LOGON_BUTTON:
				{
					LoginSrvOn();
				}
				break;
			case IDC_LOGOFF_BUTTON:
				{
					LoginSrvOff();
				}
				break;
			}
		}break;

	case WM_ASYNC_WRC:
		{
			cNetwork* pNetwork = NULL;

			/// α  ޼ ó
			for( unsigned long i = 0 ; i < mLogCnt ; ++i )
			{
				pNetwork = mpLogNet[i];
				if( pNetwork == NULL )
				{
					assert(NULL);
					continue;
				}

				ASYNC_Process( pNetwork, wParam, lParam );
			}

			/// αagent  ޼ ó
			for( unsigned long i = 0 ; i < mLogCnt ; ++i )
			{
				pNetwork = mpLogAgent[i];
				if( pNetwork == NULL )
				{
					assert(NULL);
					continue;
				}

				ASYNC_Process( pNetwork, wParam, lParam );
			}

			///   ޼ ó
			for( unsigned long i = 0 ; i < mGameCnt ; ++i )
			{
				pNetwork = mpGameNet[i];
				if( pNetwork == NULL )
				{
					assert(NULL);
					continue;
				}

				ASYNC_Process( pNetwork, wParam, lParam );
			}

			/// agent  ޼ ó
			for( unsigned long i = 0 ; i < mGameCnt ; ++i )
			{
				pNetwork = mpGameAgent[i];
				if( pNetwork == NULL )
				{
					assert(NULL);
					continue;
				}

				ASYNC_Process( pNetwork, wParam, lParam );
			}
		}

		return FALSE;
	}

	return CDialog::DefWindowProc(message, wParam, lParam);
}

void CServerToolDlg::ASYNC_Process( cNetwork* pNetwork, WPARAM wParam, LPARAM lParam )
{
	char chatmsg[BUFFER_SIZE];

	switch( WSAGETSELECTEVENT(lParam) )
	{
	case FD_CONNECT:
		{
			if( pNetwork->FDConnect( wParam ) )
			{
				if( !WSAGETSELECTERROR(lParam) )
					pNetwork->SuccessConnect();
			}
		}
		break;
	case FD_CLOSE:
		{
			pNetwork->DisConnect( wParam );
		}
		break;
	case FD_WRITE:
		{
			pNetwork->RetrySend( wParam );
		}
		break;
	case FD_READ:
		{
			pNetwork->NetworkMsgParser( wParam, chatmsg );
		}
		break;
	}
}

void CServerToolDlg::LogInSrvAdd( unsigned long num, char* ip, int port )
{
	CListCtrl* pLogInListC = (CListCtrl*)GetDlgItem( IDC_LOGIN_LC );

	CString string;

	pLogInListC->InsertItem( num, _T("OFF"), LOGCOL_STATE );
	pLogInListC->SetItemText( num, LOGCOL_AGENT, _T("OFF") );
	pLogInListC->SetItemText( num, LOGCOL_USERIN, _T("OFF") );

	string.Format( _T("%s"), ip );

	wchar_t wIp[16];
	MultiByteToWideChar( CP_ACP, 0, ip, (int)strlen(ip)+1, (LPWSTR)&wIp, 16 );

	pLogInListC->SetItemText( num, LOGCOL_IP, wIp );
	string.Format( _T("%d"), port );
	pLogInListC->SetItemText( num, LOGCOL_PORT, string );
	string.Format( _T("%d"), 0 );
	pLogInListC->SetItemText( num, LOGCOL_PING, string );

	if( num >= LOGSRV_MAX )
	{
		assert(NULL);
		MessageBox( _T("LogIn_Network Overflow"), _T("ERROR") );
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return;
	}

	mpLogNet[mLogCnt] = new cLogInSrvNetwork;
	if( mpLogNet[mLogCnt]->Init( this->m_hWnd, num, ip, port, this ) == false )
	{
		assert(NULL);
		MessageBox( _T("LogIn_Network Init Error"), _T("ERROR") );
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return;
	}

	mpLogAgent[mLogCnt] = new cLogInAgentNetwork;
	if( mpLogAgent[mLogCnt]->Init( this->m_hWnd, num, ip, AGENT_PORT, this ) == false )
	{
		assert(NULL);
		MessageBox( _T("LogIn_Agent_Network Init Error"), _T("ERROR") );
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return;
	}

	++mLogCnt;
}

void CServerToolDlg::ChannelSrvAdd( unsigned long num, char* ip, int port )
{
	CListCtrl* pChannelListC = (CListCtrl*)GetDlgItem( IDC_CHANNEL_LC );

	CString string;

	pChannelListC->InsertItem( num, _T(""), CHANNEL_CHECK );

	pChannelListC->SetItemText( num, CHANNEL_STATE, _T("OFF") );

	pChannelListC->SetItemText( num, CHANNEL_AGENT, _T("OFF") );

	string.Format( _T("%s"), ip );
	wchar_t wIp[16];
	MultiByteToWideChar( CP_ACP, 0, ip, (int)strlen(ip)+1, (LPWSTR)&wIp, 16 );
	pChannelListC->SetItemText( num, CHANNEL_IP, wIp );

	string.Format( _T("%d"), port );
	pChannelListC->SetItemText( num, CHANNEL_PORT, string );

	string.Format( _T("%d"), 0 );
	pChannelListC->SetItemText( num, CHANNEL_PING, string );

	string.Format( _T("%d"), 0 );
	pChannelListC->SetItemText( num, CHANNEL_USERCNT, string );

	if( num >= LOGSRV_MAX )
	{
		assert(NULL);
		MessageBox( _T("Channel_Network Overflow"), _T("ERROR") );
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return;
	}

	mpGameNet[mGameCnt] = new cGameSrvNetwork;
	if( mpGameNet[mGameCnt]->Init( this->m_hWnd, num, ip, port, this ) == false )
	{
		assert(NULL);
		MessageBox( _T("Channel_Server Init"), _T("ERROR") );
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return;
	}

	mpGameAgent[mGameCnt] = new cGameAgentNetwork;
	if( mpGameAgent[mGameCnt]->Init( this->m_hWnd, num, ip, AGENT_PORT, this ) == false )
	{
		assert(NULL);
		MessageBox( _T("Channel_Agent Init"), _T("ERROR") );
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return;
	}

	++mGameCnt;
}


void CServerToolDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO: ⿡ ޽ ó ڵ带 ߰մϴ.

	KillTimer( 1 );

	for( unsigned long i = 0 ; i < mGameCnt ; ++i )
		delete mpGameNet[i];

	for( unsigned long i = 0 ; i < mLogCnt ; ++i )
		delete mpLogNet[i];

	WSACleanup();

	delete mpFileSystem;
	mpFileSystem = NULL;
}


void CServerToolDlg::OnTimer(UINT nIDEvent)
{
	// TODO: ⿡ ޽ ó ڵ带 ߰ /Ǵ ⺻ ȣմϴ.
	switch( nIDEvent )
	{
	case 1:
		{
			cNetwork* pNetwork = NULL;

			/// α  ޼ ó
			for( unsigned long i = 0 ; i < mLogCnt ; ++i )
			{
				pNetwork = mpLogNet[i];
				if( pNetwork == NULL )
				{
					assert(NULL);
					continue;
				}

				pNetwork->Process();
			}

			/// αagent  ޼ ó
			for( unsigned long i = 0 ; i < mLogCnt ; ++i )
			{
				pNetwork = mpLogAgent[i];
				if( pNetwork == NULL )
				{
					assert(NULL);
					continue;
				}

				pNetwork->Process();
			}

			///   ޼ ó
			for( unsigned long i = 0 ; i < mGameCnt ; ++i )
			{
				pNetwork = mpGameNet[i];
				if( pNetwork == NULL )
				{
					assert(NULL);
					continue;
				}

				pNetwork->Process();
			}

			/// agent  ޼ ó
			for( unsigned long i = 0 ; i < mGameCnt ; ++i )
			{
				pNetwork = mpGameAgent[i];
				if( pNetwork == NULL )
				{
					assert(NULL);
					continue;
				}

				pNetwork->Process();
			}

		}break;
	}

	CDialog::OnTimer(nIDEvent);
}


void CServerToolDlg::ScriptLoad()
{
	cFileLoader loader;
	cString pathName = "ServerInfo.txt";

	if( loader.Open( pathName, true ) == false )
	{
		assert(NULL);
		MessageBox( _T("ServerInfo.txt Error"), _T("ERROR") );
		AfxGetMainWnd()->PostMessage(WM_CLOSE);
		return;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	char ip[16];

	unsigned long logNum = 0;
	unsigned long cheNum = 0;

	while( tokenizer.IsEnd() == false )
	{
		if( tokenizer.GetNext( &str ) == false )	{ return; }
		sprintf( ip, "%s", str.Cstr() ); 

		if( tokenizer.GetNext( &str ) == false )	{ return; }
		unsigned long port = str.ToInt();

		if( tokenizer.GetNext( &str ) == false )	{ return; }
		unsigned char flag = (unsigned char)str.ToInt();

		///   
		if( flag == SRVTYPE_LOGIN )
		{
			LogInSrvAdd( logNum, ip, port );
			++logNum;
		}
		else
		{
			ChannelSrvAdd( cheNum, ip, port );
			++cheNum;
		}
	}
}


BOOL CServerToolDlg::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	// TODO: ⿡ Ưȭ ڵ带 ߰ /Ǵ ⺻ Ŭ ȣմϴ.

	//if( LOWORD( wParam ) == IDC_SERVER_LC )
	//{
	//	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)lParam; 

	//	if( pNMListView->uNewState == (UINT)( LVIS_ACTIVATING ) )
	//	{
	//		CListCtrl* pServerListC = (CListCtrl*)GetDlgItem( IDC_SERVER_LC );

	//		if( ListView_GetItemState( pServerListC->m_hWnd, pNMListView->iItem, LVIS_STATEIMAGEMASK ) == ON_LIST_CHECK )
	//		{
	//			CString a = pServerListC->GetItemText( pNMListView->iItem, SRVCOL_NUM );
	//			a.Format( _T("%s"), 0 );
	//		}
	//	}

	//}

	return CDialog::OnNotify(wParam, lParam, pResult);
}


void CServerToolDlg::ChannelSrvOn()
{
	cGameAgentNetwork* pNetwork;

	CListCtrl* pChannelList = (CListCtrl*)GetDlgItem( IDC_CHANNEL_LC );

	if( MessageBox( _T("Channel Server ON"), _T("Warning"), MB_OKCANCEL ) == IDOK )
	{
		for( int i = 0 ; i < pChannelList->GetItemCount() ; ++i )
		{
			if( ListView_GetItemState( pChannelList->m_hWnd, i, LVIS_STATEIMAGEMASK ) == ON_LIST_CHECK )
			{
				if( pChannelList->GetItemText( i, CHANNEL_STATE ) == "OFF" )
				{
					pNetwork = mpGameAgent[i];

					pNetwork->SendOn();
				}
			}
		}
	}
}


void CServerToolDlg::ChannelSrvOff()
{
	cGameAgentNetwork* pNetwork;

	CListCtrl* pChannelList = (CListCtrl*)GetDlgItem( IDC_CHANNEL_LC );

	if( MessageBox( _T("Channel Server OFF"), _T("Warning"), MB_OKCANCEL ) == IDOK )
	{
		for( int i = 0 ; i < pChannelList->GetItemCount() ; ++i )
		{
			if( ListView_GetItemState( pChannelList->m_hWnd, i, LVIS_STATEIMAGEMASK ) == ON_LIST_CHECK )
			{
				if( pChannelList->GetItemText( i, CHANNEL_STATE ) == "ON" )
				{
					pNetwork = mpGameAgent[i];

					pNetwork->SendOff();
				}
			}
		}
	}
}


void CServerToolDlg::LoginSrvOn()
{
	cLogInAgentNetwork* pNetwork;

	CListCtrl* pLogList = (CListCtrl*)GetDlgItem( IDC_LOGIN_LC );

	if( MessageBox( _T("Login Server ON"), _T("Warning"), MB_OKCANCEL ) == IDOK )
	{
		for( int i = 0 ; i < pLogList->GetItemCount() ; ++i )
		{
			//if( ListView_GetItemState( pLogList->m_hWnd, i, LVIS_STATEIMAGEMASK ) == ON_LIST_CHECK )
			//{
				if( pLogList->GetItemText( i, LOGCOL_STATE ) == "OFF" )
				{
					pNetwork = mpLogAgent[i];

					pNetwork->SendOn();
				}
			//}
		}
	}
}


void CServerToolDlg::LoginSrvOff()
{
	cLogInAgentNetwork* pNetwork;

	CListCtrl* pLogList = (CListCtrl*)GetDlgItem( IDC_LOGIN_LC );

	if( MessageBox( _T("Login Server OFF"), _T("Warning"), MB_OKCANCEL ) == IDOK )
	{
		for( int i = 0 ; i < pLogList->GetItemCount() ; ++i )
		{
			//if( ListView_GetItemState( pLogList->m_hWnd, i, LVIS_STATEIMAGEMASK ) == ON_LIST_CHECK )
			//{
			if( pLogList->GetItemText( i, LOGCOL_STATE ) == "ON" )
			{
				pNetwork = mpLogAgent[i];

				pNetwork->SendOff();
			}
			//}
		}
	}
}

