/* ==========================================================================
*      : ServerToolDlg.h
*      : 
*    : ڰ
*    : 2007-03-30
* ǻ :
*===========================================================================*/
// ServerToolDlg.h :  
//

#pragma once

#include "ServerTool.h"

class cFileSystem;

const unsigned long LOGSRV_MAX = 255;
const unsigned long GAMESRV_MAX = 255;
const int AGENT_PORT = 14900;

class cNetwork;
class cLogInSrvNetwork;
class cLogInAgentNetwork;
class cGameSrvNetwork;
class cGameAgentNetwork;

enum LOGIN_COLUMNS
{
	LOGCOL_STATE,
	LOGCOL_AGENT,
	LOGCOL_USERIN,
	LOGCOL_IP,
	LOGCOL_PORT,
	LOGCOL_PING,
};

enum SERVER_COLUMNS
{
	SRVCOL_CHECK,
	SRVCOL_NUM,
	SRVCOL_NAME,
};

enum CHANNEL_COLUMNS
{
	CHANNEL_CHECK,
	CHANNEL_STATE,
	CHANNEL_AGENT,
	CHANNEL_SERVERNUM,
	CHANNEL_SERVERNAME,
	CHANNEL_CHANNELNUM,
	CHANNEL_IP,
	CHANNEL_PORT,
	CHANNEL_PING,
	CHANNEL_USERCNT,
};

typedef LOGIN_COLUMNS CHENNER_COLUMNS;

enum SERVER_TYPE
{
	SRVTYPE_LOGIN = 1,
	SRVTYPE_CHANNEL,
};

#define ON_LIST_CHECK 0x2000 
#define OFF_LIST_CHECK 0x1000 

// CServerToolDlg ȭ 
class CServerToolDlg : public CDialog
{
// 
public:
	CServerToolDlg(CWnd* pParent = NULL);	// ǥ 

// ȭ  
	enum { IDD = IDD_SERVERTOOL_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV 


// 
protected:
	HICON m_hIcon;

	// ޽  Լ ߽ϴ.
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()

public:
	void ASYNC_Process( cNetwork* pNetwork, WPARAM wParam, LPARAM lParam );

	void LogInSrvAdd( unsigned long num, char* ip, int port );
	void ChannelSrvAdd( unsigned long num, char* ip, int port );

	void ChannelSrvOn();
	void ChannelSrvOff();
	void LoginSrvOn();
	void LoginSrvOff();

private:
	WSADATA				mWsaData;

private:
	unsigned long		mLogCnt;
	cLogInSrvNetwork*	mpLogNet[LOGSRV_MAX];

	cLogInAgentNetwork*	mpLogAgent[LOGSRV_MAX];

	unsigned long		mGameCnt;
	cGameSrvNetwork*	mpGameNet[GAMESRV_MAX];

	cGameAgentNetwork*	mpGameAgent[GAMESRV_MAX];

	cFileSystem*		mpFileSystem;

protected:
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
public:
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnDestroy();

	void ScriptLoad();
protected:
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
};
